// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.auditmanager.model



/**
 * A breakdown of the latest compliance check status for the evidence in your Audit Manager assessments.
 */
public class EvidenceInsights private constructor(builder: Builder) {
    /**
     * The number of compliance check evidence that Audit Manager classified as compliant. This includes evidence that was collected from Security Hub with a *Pass* ruling, or collected from Config with a *Compliant* ruling.
     */
    public val compliantEvidenceCount: kotlin.Int? = builder.compliantEvidenceCount
    /**
     * The number of evidence that a compliance check ruling isn't available for. Evidence is inconclusive when the associated control uses Security Hub or Config as a data source but you didn't enable those services. This is also the case when a control uses a data source that doesn’t support compliance checks (for example, manual evidence, API calls, or CloudTrail).
     *
     * If evidence has a compliance check status of *not applicable* in the console, it's classified as *inconclusive* in `EvidenceInsights` data.
     */
    public val inconclusiveEvidenceCount: kotlin.Int? = builder.inconclusiveEvidenceCount
    /**
     * The number of compliance check evidence that Audit Manager classified as non-compliant. This includes evidence that was collected from Security Hub with a *Fail* ruling, or collected from Config with a *Non-compliant* ruling.
     */
    public val noncompliantEvidenceCount: kotlin.Int? = builder.noncompliantEvidenceCount

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.auditmanager.model.EvidenceInsights = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EvidenceInsights(")
        append("compliantEvidenceCount=$compliantEvidenceCount,")
        append("inconclusiveEvidenceCount=$inconclusiveEvidenceCount,")
        append("noncompliantEvidenceCount=$noncompliantEvidenceCount")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = compliantEvidenceCount ?: 0
        result = 31 * result + (inconclusiveEvidenceCount ?: 0)
        result = 31 * result + (noncompliantEvidenceCount ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EvidenceInsights

        if (compliantEvidenceCount != other.compliantEvidenceCount) return false
        if (inconclusiveEvidenceCount != other.inconclusiveEvidenceCount) return false
        if (noncompliantEvidenceCount != other.noncompliantEvidenceCount) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.auditmanager.model.EvidenceInsights = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The number of compliance check evidence that Audit Manager classified as compliant. This includes evidence that was collected from Security Hub with a *Pass* ruling, or collected from Config with a *Compliant* ruling.
         */
        public var compliantEvidenceCount: kotlin.Int? = null
        /**
         * The number of evidence that a compliance check ruling isn't available for. Evidence is inconclusive when the associated control uses Security Hub or Config as a data source but you didn't enable those services. This is also the case when a control uses a data source that doesn’t support compliance checks (for example, manual evidence, API calls, or CloudTrail).
         *
         * If evidence has a compliance check status of *not applicable* in the console, it's classified as *inconclusive* in `EvidenceInsights` data.
         */
        public var inconclusiveEvidenceCount: kotlin.Int? = null
        /**
         * The number of compliance check evidence that Audit Manager classified as non-compliant. This includes evidence that was collected from Security Hub with a *Fail* ruling, or collected from Config with a *Non-compliant* ruling.
         */
        public var noncompliantEvidenceCount: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.auditmanager.model.EvidenceInsights) : this() {
            this.compliantEvidenceCount = x.compliantEvidenceCount
            this.inconclusiveEvidenceCount = x.inconclusiveEvidenceCount
            this.noncompliantEvidenceCount = x.noncompliantEvidenceCount
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.auditmanager.model.EvidenceInsights = EvidenceInsights(this)
    }
}
