// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.auditmanager.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A summary of the latest analytics data for all your active assessments.
 *
 * This summary is a snapshot of the data that your active assessments collected on the `lastUpdated` date. It’s important to understand that the following totals are daily counts based on this date — they aren’t a total sum to date.
 *
 * The `Insights` data is eventually consistent. This means that, when you read data from `Insights`, the response might not instantly reflect the results of a recently completed write or update operation. If you repeat your read request after a few hours, the response should return the latest data.
 *
 * If you delete an assessment or change its status to inactive, `InsightsByAssessment` includes data for that assessment as follows.
 * + **Inactive assessments** - If Audit Manager collected evidence for your assessment before you changed it inactive, that evidence is included in the `InsightsByAssessment` counts for that day.
 * + **Deleted assessments** - If Audit Manager collected evidence for your assessment before you deleted it, that evidence isn't included in the `InsightsByAssessment` counts for that day.
 */
public class Insights private constructor(builder: Builder) {
    /**
     * The number of active assessments in Audit Manager.
     */
    public val activeAssessmentsCount: kotlin.Int? = builder.activeAssessmentsCount
    /**
     * The number of assessment controls that collected non-compliant evidence on the `lastUpdated` date.
     */
    public val assessmentControlsCountByNoncompliantEvidence: kotlin.Int? = builder.assessmentControlsCountByNoncompliantEvidence
    /**
     * The number of compliance check evidence that Audit Manager classified as compliant on the `lastUpdated` date. This includes evidence that was collected from Security Hub with a *Pass* ruling, or collected from Config with a *Compliant* ruling.
     */
    public val compliantEvidenceCount: kotlin.Int? = builder.compliantEvidenceCount
    /**
     * The number of evidence without a compliance check ruling. Evidence is inconclusive when the associated control uses Security Hub or Config as a data source but you didn't enable those services. This is also the case when a control uses a data source that doesn’t support compliance checks (for example: manual evidence, API calls, or CloudTrail).
     *
     * If evidence has a compliance check status of *not applicable*, it's classed as *inconclusive* in `Insights` data.
     */
    public val inconclusiveEvidenceCount: kotlin.Int? = builder.inconclusiveEvidenceCount
    /**
     * The time when the cross-assessment insights were last updated.
     */
    public val lastUpdated: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdated
    /**
     * The number of compliance check evidence that Audit Manager classified as non-compliant on the `lastUpdated` date. This includes evidence that was collected from Security Hub with a *Fail* ruling, or collected from Config with a *Non-compliant* ruling.
     */
    public val noncompliantEvidenceCount: kotlin.Int? = builder.noncompliantEvidenceCount
    /**
     * The total number of controls across all active assessments.
     */
    public val totalAssessmentControlsCount: kotlin.Int? = builder.totalAssessmentControlsCount

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.auditmanager.model.Insights = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Insights(")
        append("activeAssessmentsCount=$activeAssessmentsCount,")
        append("assessmentControlsCountByNoncompliantEvidence=$assessmentControlsCountByNoncompliantEvidence,")
        append("compliantEvidenceCount=$compliantEvidenceCount,")
        append("inconclusiveEvidenceCount=$inconclusiveEvidenceCount,")
        append("lastUpdated=$lastUpdated,")
        append("noncompliantEvidenceCount=$noncompliantEvidenceCount,")
        append("totalAssessmentControlsCount=$totalAssessmentControlsCount")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = activeAssessmentsCount ?: 0
        result = 31 * result + (assessmentControlsCountByNoncompliantEvidence ?: 0)
        result = 31 * result + (compliantEvidenceCount ?: 0)
        result = 31 * result + (inconclusiveEvidenceCount ?: 0)
        result = 31 * result + (lastUpdated?.hashCode() ?: 0)
        result = 31 * result + (noncompliantEvidenceCount ?: 0)
        result = 31 * result + (totalAssessmentControlsCount ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Insights

        if (activeAssessmentsCount != other.activeAssessmentsCount) return false
        if (assessmentControlsCountByNoncompliantEvidence != other.assessmentControlsCountByNoncompliantEvidence) return false
        if (compliantEvidenceCount != other.compliantEvidenceCount) return false
        if (inconclusiveEvidenceCount != other.inconclusiveEvidenceCount) return false
        if (lastUpdated != other.lastUpdated) return false
        if (noncompliantEvidenceCount != other.noncompliantEvidenceCount) return false
        if (totalAssessmentControlsCount != other.totalAssessmentControlsCount) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.auditmanager.model.Insights = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The number of active assessments in Audit Manager.
         */
        public var activeAssessmentsCount: kotlin.Int? = null
        /**
         * The number of assessment controls that collected non-compliant evidence on the `lastUpdated` date.
         */
        public var assessmentControlsCountByNoncompliantEvidence: kotlin.Int? = null
        /**
         * The number of compliance check evidence that Audit Manager classified as compliant on the `lastUpdated` date. This includes evidence that was collected from Security Hub with a *Pass* ruling, or collected from Config with a *Compliant* ruling.
         */
        public var compliantEvidenceCount: kotlin.Int? = null
        /**
         * The number of evidence without a compliance check ruling. Evidence is inconclusive when the associated control uses Security Hub or Config as a data source but you didn't enable those services. This is also the case when a control uses a data source that doesn’t support compliance checks (for example: manual evidence, API calls, or CloudTrail).
         *
         * If evidence has a compliance check status of *not applicable*, it's classed as *inconclusive* in `Insights` data.
         */
        public var inconclusiveEvidenceCount: kotlin.Int? = null
        /**
         * The time when the cross-assessment insights were last updated.
         */
        public var lastUpdated: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The number of compliance check evidence that Audit Manager classified as non-compliant on the `lastUpdated` date. This includes evidence that was collected from Security Hub with a *Fail* ruling, or collected from Config with a *Non-compliant* ruling.
         */
        public var noncompliantEvidenceCount: kotlin.Int? = null
        /**
         * The total number of controls across all active assessments.
         */
        public var totalAssessmentControlsCount: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.auditmanager.model.Insights) : this() {
            this.activeAssessmentsCount = x.activeAssessmentsCount
            this.assessmentControlsCountByNoncompliantEvidence = x.assessmentControlsCountByNoncompliantEvidence
            this.compliantEvidenceCount = x.compliantEvidenceCount
            this.inconclusiveEvidenceCount = x.inconclusiveEvidenceCount
            this.lastUpdated = x.lastUpdated
            this.noncompliantEvidenceCount = x.noncompliantEvidenceCount
            this.totalAssessmentControlsCount = x.totalAssessmentControlsCount
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.auditmanager.model.Insights = Insights(this)
    }
}
