// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.auditmanager.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The notification that informs a user of an update in Audit Manager. For example, this includes the notification that's sent when a control set is delegated for review.
 */
public class Notification private constructor(builder: Builder) {
    /**
     * The identifier for the assessment.
     */
    public val assessmentId: kotlin.String? = builder.assessmentId
    /**
     * The name of the related assessment.
     */
    public val assessmentName: kotlin.String? = builder.assessmentName
    /**
     * The identifier for the control set.
     */
    public val controlSetId: kotlin.String? = builder.controlSetId
    /**
     * Specifies the name of the control set that the notification is about.
     */
    public val controlSetName: kotlin.String? = builder.controlSetName
    /**
     * The description of the notification.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The time when the notification was sent.
     */
    public val eventTime: aws.smithy.kotlin.runtime.time.Instant? = builder.eventTime
    /**
     * The unique identifier for the notification.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The sender of the notification.
     */
    public val source: kotlin.String? = builder.source

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.auditmanager.model.Notification = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Notification(")
        append("assessmentId=$assessmentId,")
        append("assessmentName=$assessmentName,")
        append("controlSetId=$controlSetId,")
        append("controlSetName=$controlSetName,")
        append("description=$description,")
        append("eventTime=$eventTime,")
        append("id=$id,")
        append("source=$source")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = assessmentId?.hashCode() ?: 0
        result = 31 * result + (assessmentName?.hashCode() ?: 0)
        result = 31 * result + (controlSetId?.hashCode() ?: 0)
        result = 31 * result + (controlSetName?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (eventTime?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (source?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Notification

        if (assessmentId != other.assessmentId) return false
        if (assessmentName != other.assessmentName) return false
        if (controlSetId != other.controlSetId) return false
        if (controlSetName != other.controlSetName) return false
        if (description != other.description) return false
        if (eventTime != other.eventTime) return false
        if (id != other.id) return false
        if (source != other.source) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.auditmanager.model.Notification = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The identifier for the assessment.
         */
        public var assessmentId: kotlin.String? = null
        /**
         * The name of the related assessment.
         */
        public var assessmentName: kotlin.String? = null
        /**
         * The identifier for the control set.
         */
        public var controlSetId: kotlin.String? = null
        /**
         * Specifies the name of the control set that the notification is about.
         */
        public var controlSetName: kotlin.String? = null
        /**
         * The description of the notification.
         */
        public var description: kotlin.String? = null
        /**
         * The time when the notification was sent.
         */
        public var eventTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The unique identifier for the notification.
         */
        public var id: kotlin.String? = null
        /**
         * The sender of the notification.
         */
        public var source: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.auditmanager.model.Notification) : this() {
            this.assessmentId = x.assessmentId
            this.assessmentName = x.assessmentName
            this.controlSetId = x.controlSetId
            this.controlSetName = x.controlSetName
            this.description = x.description
            this.eventTime = x.eventTime
            this.id = x.id
            this.source = x.source
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.auditmanager.model.Notification = Notification(this)
    }
}
