// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.auditmanager.model



/**
 * The wrapper that contains the Audit Manager role information of the current user. This includes the role type and IAM Amazon Resource Name (ARN).
 */
public class Role private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the IAM role.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * The type of customer persona.
     *
     * In `CreateAssessment`, `roleType` can only be `PROCESS_OWNER`.
     *
     * In `UpdateSettings`, `roleType` can only be `PROCESS_OWNER`.
     *
     * In `BatchCreateDelegationByAssessment`, `roleType` can only be `RESOURCE_OWNER`.
     */
    public val roleType: aws.sdk.kotlin.services.auditmanager.model.RoleType? = builder.roleType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.auditmanager.model.Role = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Role(")
        append("roleArn=$roleArn,")
        append("roleType=$roleType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = roleArn?.hashCode() ?: 0
        result = 31 * result + (roleType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Role

        if (roleArn != other.roleArn) return false
        if (roleType != other.roleType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.auditmanager.model.Role = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the IAM role.
         */
        public var roleArn: kotlin.String? = null
        /**
         * The type of customer persona.
         *
         * In `CreateAssessment`, `roleType` can only be `PROCESS_OWNER`.
         *
         * In `UpdateSettings`, `roleType` can only be `PROCESS_OWNER`.
         *
         * In `BatchCreateDelegationByAssessment`, `roleType` can only be `RESOURCE_OWNER`.
         */
        public var roleType: aws.sdk.kotlin.services.auditmanager.model.RoleType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.auditmanager.model.Role) : this() {
            this.roleArn = x.roleArn
            this.roleType = x.roleType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.auditmanager.model.Role = Role(this)
    }
}
