// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.auditmanager.model



public class UpdateSettingsRequest private constructor(builder: Builder) {
    /**
     * The default storage destination for assessment reports.
     */
    public val defaultAssessmentReportsDestination: aws.sdk.kotlin.services.auditmanager.model.AssessmentReportsDestination? = builder.defaultAssessmentReportsDestination
    /**
     * A list of the default audit owners.
     */
    public val defaultProcessOwners: List<Role>? = builder.defaultProcessOwners
    /**
     * Specifies whether the evidence finder feature is enabled. Change this attribute to enable or disable evidence finder.
     *
     * When you use this attribute to disable evidence finder, Audit Manager deletes the event data store that’s used to query your evidence data. As a result, you can’t re-enable evidence finder and use the feature again. Your only alternative is to [deregister](https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_DeregisterAccount.html) and then [re-register](https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_RegisterAccount.html) Audit Manager.
     *
     * Disabling evidence finder is permanent, so consider this decision carefully before you proceed. If you’re using Audit Manager as a delegated administrator, keep in mind that this action applies to all member accounts in your organization.
     */
    public val evidenceFinderEnabled: kotlin.Boolean? = builder.evidenceFinderEnabled
    /**
     * The KMS key details.
     */
    public val kmsKey: kotlin.String? = builder.kmsKey
    /**
     * The Amazon Simple Notification Service (Amazon SNS) topic that Audit Manager sends notifications to.
     */
    public val snsTopic: kotlin.String? = builder.snsTopic

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.auditmanager.model.UpdateSettingsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateSettingsRequest(")
        append("defaultAssessmentReportsDestination=$defaultAssessmentReportsDestination,")
        append("defaultProcessOwners=$defaultProcessOwners,")
        append("evidenceFinderEnabled=$evidenceFinderEnabled,")
        append("kmsKey=$kmsKey,")
        append("snsTopic=$snsTopic")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = defaultAssessmentReportsDestination?.hashCode() ?: 0
        result = 31 * result + (defaultProcessOwners?.hashCode() ?: 0)
        result = 31 * result + (evidenceFinderEnabled?.hashCode() ?: 0)
        result = 31 * result + (kmsKey?.hashCode() ?: 0)
        result = 31 * result + (snsTopic?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateSettingsRequest

        if (defaultAssessmentReportsDestination != other.defaultAssessmentReportsDestination) return false
        if (defaultProcessOwners != other.defaultProcessOwners) return false
        if (evidenceFinderEnabled != other.evidenceFinderEnabled) return false
        if (kmsKey != other.kmsKey) return false
        if (snsTopic != other.snsTopic) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.auditmanager.model.UpdateSettingsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The default storage destination for assessment reports.
         */
        public var defaultAssessmentReportsDestination: aws.sdk.kotlin.services.auditmanager.model.AssessmentReportsDestination? = null
        /**
         * A list of the default audit owners.
         */
        public var defaultProcessOwners: List<Role>? = null
        /**
         * Specifies whether the evidence finder feature is enabled. Change this attribute to enable or disable evidence finder.
         *
         * When you use this attribute to disable evidence finder, Audit Manager deletes the event data store that’s used to query your evidence data. As a result, you can’t re-enable evidence finder and use the feature again. Your only alternative is to [deregister](https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_DeregisterAccount.html) and then [re-register](https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_RegisterAccount.html) Audit Manager.
         *
         * Disabling evidence finder is permanent, so consider this decision carefully before you proceed. If you’re using Audit Manager as a delegated administrator, keep in mind that this action applies to all member accounts in your organization.
         */
        public var evidenceFinderEnabled: kotlin.Boolean? = null
        /**
         * The KMS key details.
         */
        public var kmsKey: kotlin.String? = null
        /**
         * The Amazon Simple Notification Service (Amazon SNS) topic that Audit Manager sends notifications to.
         */
        public var snsTopic: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.auditmanager.model.UpdateSettingsRequest) : this() {
            this.defaultAssessmentReportsDestination = x.defaultAssessmentReportsDestination
            this.defaultProcessOwners = x.defaultProcessOwners
            this.evidenceFinderEnabled = x.evidenceFinderEnabled
            this.kmsKey = x.kmsKey
            this.snsTopic = x.snsTopic
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.auditmanager.model.UpdateSettingsRequest = UpdateSettingsRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.auditmanager.model.AssessmentReportsDestination] inside the given [block]
         */
        public fun defaultAssessmentReportsDestination(block: aws.sdk.kotlin.services.auditmanager.model.AssessmentReportsDestination.Builder.() -> kotlin.Unit) {
            this.defaultAssessmentReportsDestination = aws.sdk.kotlin.services.auditmanager.model.AssessmentReportsDestination.invoke(block)
        }
    }
}
