// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.auditmanager.paginators

import aws.sdk.kotlin.services.auditmanager.AuditManagerClient
import aws.sdk.kotlin.services.auditmanager.model.GetChangeLogsRequest
import aws.sdk.kotlin.services.auditmanager.model.GetChangeLogsResponse
import aws.sdk.kotlin.services.auditmanager.model.GetDelegationsRequest
import aws.sdk.kotlin.services.auditmanager.model.GetDelegationsResponse
import aws.sdk.kotlin.services.auditmanager.model.GetEvidenceByEvidenceFolderRequest
import aws.sdk.kotlin.services.auditmanager.model.GetEvidenceByEvidenceFolderResponse
import aws.sdk.kotlin.services.auditmanager.model.GetEvidenceFoldersByAssessmentControlRequest
import aws.sdk.kotlin.services.auditmanager.model.GetEvidenceFoldersByAssessmentControlResponse
import aws.sdk.kotlin.services.auditmanager.model.GetEvidenceFoldersByAssessmentRequest
import aws.sdk.kotlin.services.auditmanager.model.GetEvidenceFoldersByAssessmentResponse
import aws.sdk.kotlin.services.auditmanager.model.ListAssessmentControlInsightsByControlDomainRequest
import aws.sdk.kotlin.services.auditmanager.model.ListAssessmentControlInsightsByControlDomainResponse
import aws.sdk.kotlin.services.auditmanager.model.ListAssessmentFrameworkShareRequestsRequest
import aws.sdk.kotlin.services.auditmanager.model.ListAssessmentFrameworkShareRequestsResponse
import aws.sdk.kotlin.services.auditmanager.model.ListAssessmentFrameworksRequest
import aws.sdk.kotlin.services.auditmanager.model.ListAssessmentFrameworksResponse
import aws.sdk.kotlin.services.auditmanager.model.ListAssessmentReportsRequest
import aws.sdk.kotlin.services.auditmanager.model.ListAssessmentReportsResponse
import aws.sdk.kotlin.services.auditmanager.model.ListAssessmentsRequest
import aws.sdk.kotlin.services.auditmanager.model.ListAssessmentsResponse
import aws.sdk.kotlin.services.auditmanager.model.ListControlDomainInsightsByAssessmentRequest
import aws.sdk.kotlin.services.auditmanager.model.ListControlDomainInsightsByAssessmentResponse
import aws.sdk.kotlin.services.auditmanager.model.ListControlDomainInsightsRequest
import aws.sdk.kotlin.services.auditmanager.model.ListControlDomainInsightsResponse
import aws.sdk.kotlin.services.auditmanager.model.ListControlInsightsByControlDomainRequest
import aws.sdk.kotlin.services.auditmanager.model.ListControlInsightsByControlDomainResponse
import aws.sdk.kotlin.services.auditmanager.model.ListControlsRequest
import aws.sdk.kotlin.services.auditmanager.model.ListControlsResponse
import aws.sdk.kotlin.services.auditmanager.model.ListKeywordsForDataSourceRequest
import aws.sdk.kotlin.services.auditmanager.model.ListKeywordsForDataSourceResponse
import aws.sdk.kotlin.services.auditmanager.model.ListNotificationsRequest
import aws.sdk.kotlin.services.auditmanager.model.ListNotificationsResponse
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow


/**
 * Paginate over [GetChangeLogsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetChangeLogsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetChangeLogsResponse]
 */
public fun AuditManagerClient.getChangeLogsPaginated(initialRequest: GetChangeLogsRequest): Flow<GetChangeLogsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getChangeLogsPaginated.getChangeLogs(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [GetChangeLogsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetChangeLogsResponse]
 */
public fun AuditManagerClient.getChangeLogsPaginated(block: GetChangeLogsRequest.Builder.() -> Unit): Flow<GetChangeLogsResponse> =
    getChangeLogsPaginated(GetChangeLogsRequest.Builder().apply(block).build())

/**
 * Paginate over [GetDelegationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetDelegationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetDelegationsResponse]
 */
public fun AuditManagerClient.getDelegationsPaginated(initialRequest: GetDelegationsRequest): Flow<GetDelegationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getDelegationsPaginated.getDelegations(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [GetDelegationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetDelegationsResponse]
 */
public fun AuditManagerClient.getDelegationsPaginated(block: GetDelegationsRequest.Builder.() -> Unit): Flow<GetDelegationsResponse> =
    getDelegationsPaginated(GetDelegationsRequest.Builder().apply(block).build())

/**
 * Paginate over [GetEvidenceByEvidenceFolderResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetEvidenceByEvidenceFolderRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetEvidenceByEvidenceFolderResponse]
 */
public fun AuditManagerClient.getEvidenceByEvidenceFolderPaginated(initialRequest: GetEvidenceByEvidenceFolderRequest): Flow<GetEvidenceByEvidenceFolderResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getEvidenceByEvidenceFolderPaginated.getEvidenceByEvidenceFolder(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [GetEvidenceByEvidenceFolderResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetEvidenceByEvidenceFolderResponse]
 */
public fun AuditManagerClient.getEvidenceByEvidenceFolderPaginated(block: GetEvidenceByEvidenceFolderRequest.Builder.() -> Unit): Flow<GetEvidenceByEvidenceFolderResponse> =
    getEvidenceByEvidenceFolderPaginated(GetEvidenceByEvidenceFolderRequest.Builder().apply(block).build())

/**
 * Paginate over [GetEvidenceFoldersByAssessmentResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetEvidenceFoldersByAssessmentRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetEvidenceFoldersByAssessmentResponse]
 */
public fun AuditManagerClient.getEvidenceFoldersByAssessmentPaginated(initialRequest: GetEvidenceFoldersByAssessmentRequest): Flow<GetEvidenceFoldersByAssessmentResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getEvidenceFoldersByAssessmentPaginated.getEvidenceFoldersByAssessment(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [GetEvidenceFoldersByAssessmentResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetEvidenceFoldersByAssessmentResponse]
 */
public fun AuditManagerClient.getEvidenceFoldersByAssessmentPaginated(block: GetEvidenceFoldersByAssessmentRequest.Builder.() -> Unit): Flow<GetEvidenceFoldersByAssessmentResponse> =
    getEvidenceFoldersByAssessmentPaginated(GetEvidenceFoldersByAssessmentRequest.Builder().apply(block).build())

/**
 * Paginate over [GetEvidenceFoldersByAssessmentControlResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetEvidenceFoldersByAssessmentControlRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetEvidenceFoldersByAssessmentControlResponse]
 */
public fun AuditManagerClient.getEvidenceFoldersByAssessmentControlPaginated(initialRequest: GetEvidenceFoldersByAssessmentControlRequest): Flow<GetEvidenceFoldersByAssessmentControlResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getEvidenceFoldersByAssessmentControlPaginated.getEvidenceFoldersByAssessmentControl(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [GetEvidenceFoldersByAssessmentControlResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetEvidenceFoldersByAssessmentControlResponse]
 */
public fun AuditManagerClient.getEvidenceFoldersByAssessmentControlPaginated(block: GetEvidenceFoldersByAssessmentControlRequest.Builder.() -> Unit): Flow<GetEvidenceFoldersByAssessmentControlResponse> =
    getEvidenceFoldersByAssessmentControlPaginated(GetEvidenceFoldersByAssessmentControlRequest.Builder().apply(block).build())

/**
 * Paginate over [ListAssessmentControlInsightsByControlDomainResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAssessmentControlInsightsByControlDomainRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAssessmentControlInsightsByControlDomainResponse]
 */
public fun AuditManagerClient.listAssessmentControlInsightsByControlDomainPaginated(initialRequest: ListAssessmentControlInsightsByControlDomainRequest): Flow<ListAssessmentControlInsightsByControlDomainResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAssessmentControlInsightsByControlDomainPaginated.listAssessmentControlInsightsByControlDomain(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListAssessmentControlInsightsByControlDomainResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAssessmentControlInsightsByControlDomainResponse]
 */
public fun AuditManagerClient.listAssessmentControlInsightsByControlDomainPaginated(block: ListAssessmentControlInsightsByControlDomainRequest.Builder.() -> Unit): Flow<ListAssessmentControlInsightsByControlDomainResponse> =
    listAssessmentControlInsightsByControlDomainPaginated(ListAssessmentControlInsightsByControlDomainRequest.Builder().apply(block).build())

/**
 * Paginate over [ListAssessmentFrameworksResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAssessmentFrameworksRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAssessmentFrameworksResponse]
 */
public fun AuditManagerClient.listAssessmentFrameworksPaginated(initialRequest: ListAssessmentFrameworksRequest): Flow<ListAssessmentFrameworksResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAssessmentFrameworksPaginated.listAssessmentFrameworks(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListAssessmentFrameworksResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAssessmentFrameworksResponse]
 */
public fun AuditManagerClient.listAssessmentFrameworksPaginated(block: ListAssessmentFrameworksRequest.Builder.() -> Unit): Flow<ListAssessmentFrameworksResponse> =
    listAssessmentFrameworksPaginated(ListAssessmentFrameworksRequest.Builder().apply(block).build())

/**
 * Paginate over [ListAssessmentFrameworkShareRequestsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAssessmentFrameworkShareRequestsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAssessmentFrameworkShareRequestsResponse]
 */
public fun AuditManagerClient.listAssessmentFrameworkShareRequestsPaginated(initialRequest: ListAssessmentFrameworkShareRequestsRequest): Flow<ListAssessmentFrameworkShareRequestsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAssessmentFrameworkShareRequestsPaginated.listAssessmentFrameworkShareRequests(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListAssessmentFrameworkShareRequestsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAssessmentFrameworkShareRequestsResponse]
 */
public fun AuditManagerClient.listAssessmentFrameworkShareRequestsPaginated(block: ListAssessmentFrameworkShareRequestsRequest.Builder.() -> Unit): Flow<ListAssessmentFrameworkShareRequestsResponse> =
    listAssessmentFrameworkShareRequestsPaginated(ListAssessmentFrameworkShareRequestsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListAssessmentReportsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAssessmentReportsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAssessmentReportsResponse]
 */
public fun AuditManagerClient.listAssessmentReportsPaginated(initialRequest: ListAssessmentReportsRequest): Flow<ListAssessmentReportsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAssessmentReportsPaginated.listAssessmentReports(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListAssessmentReportsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAssessmentReportsResponse]
 */
public fun AuditManagerClient.listAssessmentReportsPaginated(block: ListAssessmentReportsRequest.Builder.() -> Unit): Flow<ListAssessmentReportsResponse> =
    listAssessmentReportsPaginated(ListAssessmentReportsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListAssessmentsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAssessmentsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAssessmentsResponse]
 */
public fun AuditManagerClient.listAssessmentsPaginated(initialRequest: ListAssessmentsRequest): Flow<ListAssessmentsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAssessmentsPaginated.listAssessments(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListAssessmentsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAssessmentsResponse]
 */
public fun AuditManagerClient.listAssessmentsPaginated(block: ListAssessmentsRequest.Builder.() -> Unit): Flow<ListAssessmentsResponse> =
    listAssessmentsPaginated(ListAssessmentsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListControlDomainInsightsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListControlDomainInsightsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListControlDomainInsightsResponse]
 */
public fun AuditManagerClient.listControlDomainInsightsPaginated(initialRequest: ListControlDomainInsightsRequest): Flow<ListControlDomainInsightsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listControlDomainInsightsPaginated.listControlDomainInsights(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListControlDomainInsightsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListControlDomainInsightsResponse]
 */
public fun AuditManagerClient.listControlDomainInsightsPaginated(block: ListControlDomainInsightsRequest.Builder.() -> Unit): Flow<ListControlDomainInsightsResponse> =
    listControlDomainInsightsPaginated(ListControlDomainInsightsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListControlDomainInsightsByAssessmentResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListControlDomainInsightsByAssessmentRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListControlDomainInsightsByAssessmentResponse]
 */
public fun AuditManagerClient.listControlDomainInsightsByAssessmentPaginated(initialRequest: ListControlDomainInsightsByAssessmentRequest): Flow<ListControlDomainInsightsByAssessmentResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listControlDomainInsightsByAssessmentPaginated.listControlDomainInsightsByAssessment(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListControlDomainInsightsByAssessmentResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListControlDomainInsightsByAssessmentResponse]
 */
public fun AuditManagerClient.listControlDomainInsightsByAssessmentPaginated(block: ListControlDomainInsightsByAssessmentRequest.Builder.() -> Unit): Flow<ListControlDomainInsightsByAssessmentResponse> =
    listControlDomainInsightsByAssessmentPaginated(ListControlDomainInsightsByAssessmentRequest.Builder().apply(block).build())

/**
 * Paginate over [ListControlInsightsByControlDomainResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListControlInsightsByControlDomainRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListControlInsightsByControlDomainResponse]
 */
public fun AuditManagerClient.listControlInsightsByControlDomainPaginated(initialRequest: ListControlInsightsByControlDomainRequest): Flow<ListControlInsightsByControlDomainResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listControlInsightsByControlDomainPaginated.listControlInsightsByControlDomain(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListControlInsightsByControlDomainResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListControlInsightsByControlDomainResponse]
 */
public fun AuditManagerClient.listControlInsightsByControlDomainPaginated(block: ListControlInsightsByControlDomainRequest.Builder.() -> Unit): Flow<ListControlInsightsByControlDomainResponse> =
    listControlInsightsByControlDomainPaginated(ListControlInsightsByControlDomainRequest.Builder().apply(block).build())

/**
 * Paginate over [ListControlsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListControlsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListControlsResponse]
 */
public fun AuditManagerClient.listControlsPaginated(initialRequest: ListControlsRequest): Flow<ListControlsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listControlsPaginated.listControls(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListControlsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListControlsResponse]
 */
public fun AuditManagerClient.listControlsPaginated(block: ListControlsRequest.Builder.() -> Unit): Flow<ListControlsResponse> =
    listControlsPaginated(ListControlsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListKeywordsForDataSourceResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListKeywordsForDataSourceRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListKeywordsForDataSourceResponse]
 */
public fun AuditManagerClient.listKeywordsForDataSourcePaginated(initialRequest: ListKeywordsForDataSourceRequest): Flow<ListKeywordsForDataSourceResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listKeywordsForDataSourcePaginated.listKeywordsForDataSource(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListKeywordsForDataSourceResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListKeywordsForDataSourceResponse]
 */
public fun AuditManagerClient.listKeywordsForDataSourcePaginated(block: ListKeywordsForDataSourceRequest.Builder.() -> Unit): Flow<ListKeywordsForDataSourceResponse> =
    listKeywordsForDataSourcePaginated(ListKeywordsForDataSourceRequest.Builder().apply(block).build())

/**
 * Paginate over [ListNotificationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListNotificationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListNotificationsResponse]
 */
public fun AuditManagerClient.listNotificationsPaginated(initialRequest: ListNotificationsRequest): Flow<ListNotificationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listNotificationsPaginated.listNotifications(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListNotificationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListNotificationsResponse]
 */
public fun AuditManagerClient.listNotificationsPaginated(block: ListNotificationsRequest.Builder.() -> Unit): Flow<ListNotificationsResponse> =
    listNotificationsPaginated(ListNotificationsRequest.Builder().apply(block).build())
