// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.auditmanager.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.auditmanager.model.AuditManagerException
import aws.sdk.kotlin.services.auditmanager.model.BatchCreateDelegationByAssessmentError
import aws.sdk.kotlin.services.auditmanager.model.BatchCreateDelegationByAssessmentResponse
import aws.sdk.kotlin.services.auditmanager.model.Delegation
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class BatchCreateDelegationByAssessmentOperationDeserializer: HttpDeserialize<BatchCreateDelegationByAssessmentResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): BatchCreateDelegationByAssessmentResponse {
        if (!response.status.isSuccess()) {
            throwBatchCreateDelegationByAssessmentError(context, response)
        }
        val builder = BatchCreateDelegationByAssessmentResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeBatchCreateDelegationByAssessmentOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwBatchCreateDelegationByAssessmentError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw AuditManagerException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> AuditManagerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeBatchCreateDelegationByAssessmentOperationBody(builder: BatchCreateDelegationByAssessmentResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DELEGATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("delegations"))
    val ERRORS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("errors"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DELEGATIONS_DESCRIPTOR)
        field(ERRORS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DELEGATIONS_DESCRIPTOR.index -> builder.delegations =
                    deserializer.deserializeList(DELEGATIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<Delegation>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeDelegationDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                ERRORS_DESCRIPTOR.index -> builder.errors =
                    deserializer.deserializeList(ERRORS_DESCRIPTOR) {
                        val col0 = mutableListOf<BatchCreateDelegationByAssessmentError>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeBatchCreateDelegationByAssessmentErrorDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
