// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.auditmanager.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.auditmanager.model.Assessment
import aws.sdk.kotlin.services.auditmanager.model.AuditManagerException
import aws.sdk.kotlin.services.auditmanager.model.GetAssessmentResponse
import aws.sdk.kotlin.services.auditmanager.model.Role
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetAssessmentOperationDeserializer: HttpDeserialize<GetAssessmentResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetAssessmentResponse {
        if (!response.status.isSuccess()) {
            throwGetAssessmentError(context, response)
        }
        val builder = GetAssessmentResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetAssessmentOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetAssessmentError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw AuditManagerException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> AuditManagerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetAssessmentOperationBody(builder: GetAssessmentResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ASSESSMENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("assessment"))
    val USERROLE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("userRole"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ASSESSMENT_DESCRIPTOR)
        field(USERROLE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ASSESSMENT_DESCRIPTOR.index -> builder.assessment = deserializeAssessmentDocument(deserializer)
                USERROLE_DESCRIPTOR.index -> builder.userRole = deserializeRoleDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
