// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.auditmanager.transform

import aws.sdk.kotlin.services.auditmanager.model.ControlMappingSource
import aws.sdk.kotlin.services.auditmanager.model.UpdateControlRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateControlOperationSerializer: HttpSerialize<UpdateControlRequest> {
    override suspend fun serialize(context: ExecutionContext, input: UpdateControlRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            val pathSegments = listOf<String>(
                "controls",
                "${input.controlId}".encodeLabel(),
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeUpdateControlOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateControlOperationBody(context: ExecutionContext, input: UpdateControlRequest): ByteArray {
    val serializer = JsonSerializer()
    val ACTIONPLANINSTRUCTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("actionPlanInstructions"))
    val ACTIONPLANTITLE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("actionPlanTitle"))
    val CONTROLMAPPINGSOURCES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("controlMappingSources"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val TESTINGINFORMATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("testingInformation"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACTIONPLANINSTRUCTIONS_DESCRIPTOR)
        field(ACTIONPLANTITLE_DESCRIPTOR)
        field(CONTROLMAPPINGSOURCES_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(TESTINGINFORMATION_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.actionPlanInstructions?.let { field(ACTIONPLANINSTRUCTIONS_DESCRIPTOR, it) }
        input.actionPlanTitle?.let { field(ACTIONPLANTITLE_DESCRIPTOR, it) }
        if (input.controlMappingSources != null) {
            listField(CONTROLMAPPINGSOURCES_DESCRIPTOR) {
                for (el0 in input.controlMappingSources) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeControlMappingSourceDocument))
                }
            }
        }
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        input.name?.let { field(NAME_DESCRIPTOR, it) }
        input.testingInformation?.let { field(TESTINGINFORMATION_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
