// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.auditmanager.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A finalized document that's generated from an Audit Manager assessment. These reports summarize the relevant evidence that was collected for your audit, and link to the relevant evidence folders. These evidence folders are named and organized according to the controls that are specified in your assessment.
 */
public class AssessmentReport private constructor(builder: Builder) {
    /**
     * The identifier for the specified assessment.
     */
    public val assessmentId: kotlin.String? = builder.assessmentId
    /**
     * The name of the associated assessment.
     */
    public val assessmentName: kotlin.String? = builder.assessmentName
    /**
     * The name of the user who created the assessment report.
     */
    public val author: kotlin.String? = builder.author
    /**
     * The identifier for the specified Amazon Web Services account.
     */
    public val awsAccountId: kotlin.String? = builder.awsAccountId
    /**
     * Specifies when the assessment report was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The description of the specified assessment report.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The unique identifier for the assessment report.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The name that's given to the assessment report.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The current status of the specified assessment report.
     */
    public val status: aws.sdk.kotlin.services.auditmanager.model.AssessmentReportStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.auditmanager.model.AssessmentReport = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AssessmentReport(")
        append("assessmentId=$assessmentId,")
        append("assessmentName=$assessmentName,")
        append("author=$author,")
        append("awsAccountId=$awsAccountId,")
        append("creationTime=$creationTime,")
        append("description=$description,")
        append("id=$id,")
        append("name=$name,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = assessmentId?.hashCode() ?: 0
        result = 31 * result + (assessmentName?.hashCode() ?: 0)
        result = 31 * result + (author?.hashCode() ?: 0)
        result = 31 * result + (awsAccountId?.hashCode() ?: 0)
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AssessmentReport

        if (assessmentId != other.assessmentId) return false
        if (assessmentName != other.assessmentName) return false
        if (author != other.author) return false
        if (awsAccountId != other.awsAccountId) return false
        if (creationTime != other.creationTime) return false
        if (description != other.description) return false
        if (id != other.id) return false
        if (name != other.name) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.auditmanager.model.AssessmentReport = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The identifier for the specified assessment.
         */
        public var assessmentId: kotlin.String? = null
        /**
         * The name of the associated assessment.
         */
        public var assessmentName: kotlin.String? = null
        /**
         * The name of the user who created the assessment report.
         */
        public var author: kotlin.String? = null
        /**
         * The identifier for the specified Amazon Web Services account.
         */
        public var awsAccountId: kotlin.String? = null
        /**
         * Specifies when the assessment report was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description of the specified assessment report.
         */
        public var description: kotlin.String? = null
        /**
         * The unique identifier for the assessment report.
         */
        public var id: kotlin.String? = null
        /**
         * The name that's given to the assessment report.
         */
        public var name: kotlin.String? = null
        /**
         * The current status of the specified assessment report.
         */
        public var status: aws.sdk.kotlin.services.auditmanager.model.AssessmentReportStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.auditmanager.model.AssessmentReport) : this() {
            this.assessmentId = x.assessmentId
            this.assessmentName = x.assessmentName
            this.author = x.author
            this.awsAccountId = x.awsAccountId
            this.creationTime = x.creationTime
            this.description = x.description
            this.id = x.id
            this.name = x.name
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.auditmanager.model.AssessmentReport = AssessmentReport(this)
    }
}
