// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.auditmanager.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A control in Audit Manager.
 */
public class Control private constructor(builder: Builder) {
    /**
     * The recommended actions to carry out if the control isn't fulfilled.
     */
    public val actionPlanInstructions: kotlin.String? = builder.actionPlanInstructions
    /**
     * The title of the action plan for remediating the control.
     */
    public val actionPlanTitle: kotlin.String? = builder.actionPlanTitle
    /**
     * The Amazon Resource Name (ARN) of the control.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The data mapping sources for the control.
     */
    public val controlMappingSources: List<ControlMappingSource>? = builder.controlMappingSources
    /**
     * The data source types that determine where Audit Manager collects evidence from for the control.
     */
    public val controlSources: kotlin.String? = builder.controlSources
    /**
     * Specifies when the control was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The IAM user or role that created the control.
     */
    public val createdBy: kotlin.String? = builder.createdBy
    /**
     * The description of the control.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The unique identifier for the control.
     */
    public val id: kotlin.String? = builder.id
    /**
     * Specifies when the control was most recently updated.
     */
    public val lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedAt
    /**
     * The IAM user or role that most recently updated the control.
     */
    public val lastUpdatedBy: kotlin.String? = builder.lastUpdatedBy
    /**
     * The name of the control.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The tags associated with the control.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The steps that you should follow to determine if the control has been satisfied.
     */
    public val testingInformation: kotlin.String? = builder.testingInformation
    /**
     * The type of control, such as a custom control or a standard control.
     */
    public val type: aws.sdk.kotlin.services.auditmanager.model.ControlType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.auditmanager.model.Control = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Control(")
        append("actionPlanInstructions=$actionPlanInstructions,")
        append("actionPlanTitle=$actionPlanTitle,")
        append("arn=$arn,")
        append("controlMappingSources=$controlMappingSources,")
        append("controlSources=$controlSources,")
        append("createdAt=$createdAt,")
        append("createdBy=$createdBy,")
        append("description=$description,")
        append("id=$id,")
        append("lastUpdatedAt=$lastUpdatedAt,")
        append("lastUpdatedBy=$lastUpdatedBy,")
        append("name=$name,")
        append("tags=$tags,")
        append("testingInformation=$testingInformation,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = actionPlanInstructions?.hashCode() ?: 0
        result = 31 * result + (actionPlanTitle?.hashCode() ?: 0)
        result = 31 * result + (arn?.hashCode() ?: 0)
        result = 31 * result + (controlMappingSources?.hashCode() ?: 0)
        result = 31 * result + (controlSources?.hashCode() ?: 0)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (createdBy?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedAt?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedBy?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (testingInformation?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Control

        if (actionPlanInstructions != other.actionPlanInstructions) return false
        if (actionPlanTitle != other.actionPlanTitle) return false
        if (arn != other.arn) return false
        if (controlMappingSources != other.controlMappingSources) return false
        if (controlSources != other.controlSources) return false
        if (createdAt != other.createdAt) return false
        if (createdBy != other.createdBy) return false
        if (description != other.description) return false
        if (id != other.id) return false
        if (lastUpdatedAt != other.lastUpdatedAt) return false
        if (lastUpdatedBy != other.lastUpdatedBy) return false
        if (name != other.name) return false
        if (tags != other.tags) return false
        if (testingInformation != other.testingInformation) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.auditmanager.model.Control = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The recommended actions to carry out if the control isn't fulfilled.
         */
        public var actionPlanInstructions: kotlin.String? = null
        /**
         * The title of the action plan for remediating the control.
         */
        public var actionPlanTitle: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the control.
         */
        public var arn: kotlin.String? = null
        /**
         * The data mapping sources for the control.
         */
        public var controlMappingSources: List<ControlMappingSource>? = null
        /**
         * The data source types that determine where Audit Manager collects evidence from for the control.
         */
        public var controlSources: kotlin.String? = null
        /**
         * Specifies when the control was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The IAM user or role that created the control.
         */
        public var createdBy: kotlin.String? = null
        /**
         * The description of the control.
         */
        public var description: kotlin.String? = null
        /**
         * The unique identifier for the control.
         */
        public var id: kotlin.String? = null
        /**
         * Specifies when the control was most recently updated.
         */
        public var lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The IAM user or role that most recently updated the control.
         */
        public var lastUpdatedBy: kotlin.String? = null
        /**
         * The name of the control.
         */
        public var name: kotlin.String? = null
        /**
         * The tags associated with the control.
         */
        public var tags: Map<String, String>? = null
        /**
         * The steps that you should follow to determine if the control has been satisfied.
         */
        public var testingInformation: kotlin.String? = null
        /**
         * The type of control, such as a custom control or a standard control.
         */
        public var type: aws.sdk.kotlin.services.auditmanager.model.ControlType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.auditmanager.model.Control) : this() {
            this.actionPlanInstructions = x.actionPlanInstructions
            this.actionPlanTitle = x.actionPlanTitle
            this.arn = x.arn
            this.controlMappingSources = x.controlMappingSources
            this.controlSources = x.controlSources
            this.createdAt = x.createdAt
            this.createdBy = x.createdBy
            this.description = x.description
            this.id = x.id
            this.lastUpdatedAt = x.lastUpdatedAt
            this.lastUpdatedBy = x.lastUpdatedBy
            this.name = x.name
            this.tags = x.tags
            this.testingInformation = x.testingInformation
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.auditmanager.model.Control = Control(this)
    }
}
