// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.auditmanager.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A summary of the latest analytics data for a specific control domain.
 *
 * Control domain insights are grouped by control domain, and ranked by the highest total count of non-compliant evidence.
 */
public class ControlDomainInsights private constructor(builder: Builder) {
    /**
     * The number of controls in the control domain that collected non-compliant evidence on the `lastUpdated` date.
     */
    public val controlsCountByNoncompliantEvidence: kotlin.Int? = builder.controlsCountByNoncompliantEvidence
    /**
     * A breakdown of the compliance check status for the evidence that’s associated with the control domain.
     */
    public val evidenceInsights: aws.sdk.kotlin.services.auditmanager.model.EvidenceInsights? = builder.evidenceInsights
    /**
     * The unique identifier for the control domain.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The time when the control domain insights were last updated.
     */
    public val lastUpdated: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdated
    /**
     * The name of the control domain.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The total number of controls in the control domain.
     */
    public val totalControlsCount: kotlin.Int? = builder.totalControlsCount

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.auditmanager.model.ControlDomainInsights = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ControlDomainInsights(")
        append("controlsCountByNoncompliantEvidence=$controlsCountByNoncompliantEvidence,")
        append("evidenceInsights=$evidenceInsights,")
        append("id=$id,")
        append("lastUpdated=$lastUpdated,")
        append("name=$name,")
        append("totalControlsCount=$totalControlsCount)")
    }

    override fun hashCode(): kotlin.Int {
        var result = controlsCountByNoncompliantEvidence ?: 0
        result = 31 * result + (evidenceInsights?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (lastUpdated?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (totalControlsCount ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ControlDomainInsights

        if (controlsCountByNoncompliantEvidence != other.controlsCountByNoncompliantEvidence) return false
        if (evidenceInsights != other.evidenceInsights) return false
        if (id != other.id) return false
        if (lastUpdated != other.lastUpdated) return false
        if (name != other.name) return false
        if (totalControlsCount != other.totalControlsCount) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.auditmanager.model.ControlDomainInsights = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The number of controls in the control domain that collected non-compliant evidence on the `lastUpdated` date.
         */
        public var controlsCountByNoncompliantEvidence: kotlin.Int? = null
        /**
         * A breakdown of the compliance check status for the evidence that’s associated with the control domain.
         */
        public var evidenceInsights: aws.sdk.kotlin.services.auditmanager.model.EvidenceInsights? = null
        /**
         * The unique identifier for the control domain.
         */
        public var id: kotlin.String? = null
        /**
         * The time when the control domain insights were last updated.
         */
        public var lastUpdated: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the control domain.
         */
        public var name: kotlin.String? = null
        /**
         * The total number of controls in the control domain.
         */
        public var totalControlsCount: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.auditmanager.model.ControlDomainInsights) : this() {
            this.controlsCountByNoncompliantEvidence = x.controlsCountByNoncompliantEvidence
            this.evidenceInsights = x.evidenceInsights
            this.id = x.id
            this.lastUpdated = x.lastUpdated
            this.name = x.name
            this.totalControlsCount = x.totalControlsCount
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.auditmanager.model.ControlDomainInsights = ControlDomainInsights(this)

        /**
         * construct an [aws.sdk.kotlin.services.auditmanager.model.EvidenceInsights] inside the given [block]
         */
        public fun evidenceInsights(block: aws.sdk.kotlin.services.auditmanager.model.EvidenceInsights.Builder.() -> kotlin.Unit) {
            this.evidenceInsights = aws.sdk.kotlin.services.auditmanager.model.EvidenceInsights.invoke(block)
        }
    }
}
