// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.auditmanager.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A summary of the latest analytics data for a specific control in a specific active assessment.
 *
 * Control insights are grouped by control domain, and ranked by the highest total count of non-compliant evidence.
 */
public class ControlInsightsMetadataByAssessmentItem private constructor(builder: Builder) {
    /**
     * The name of the control set that the assessment control belongs to.
     */
    public val controlSetName: kotlin.String? = builder.controlSetName
    /**
     * A breakdown of the compliance check status for the evidence that’s associated with the assessment control.
     */
    public val evidenceInsights: aws.sdk.kotlin.services.auditmanager.model.EvidenceInsights? = builder.evidenceInsights
    /**
     * The unique identifier for the assessment control.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The time when the assessment control insights were last updated.
     */
    public val lastUpdated: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdated
    /**
     * The name of the assessment control.
     */
    public val name: kotlin.String? = builder.name

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.auditmanager.model.ControlInsightsMetadataByAssessmentItem = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ControlInsightsMetadataByAssessmentItem(")
        append("controlSetName=$controlSetName,")
        append("evidenceInsights=$evidenceInsights,")
        append("id=$id,")
        append("lastUpdated=$lastUpdated,")
        append("name=$name)")
    }

    override fun hashCode(): kotlin.Int {
        var result = controlSetName?.hashCode() ?: 0
        result = 31 * result + (evidenceInsights?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (lastUpdated?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ControlInsightsMetadataByAssessmentItem

        if (controlSetName != other.controlSetName) return false
        if (evidenceInsights != other.evidenceInsights) return false
        if (id != other.id) return false
        if (lastUpdated != other.lastUpdated) return false
        if (name != other.name) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.auditmanager.model.ControlInsightsMetadataByAssessmentItem = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the control set that the assessment control belongs to.
         */
        public var controlSetName: kotlin.String? = null
        /**
         * A breakdown of the compliance check status for the evidence that’s associated with the assessment control.
         */
        public var evidenceInsights: aws.sdk.kotlin.services.auditmanager.model.EvidenceInsights? = null
        /**
         * The unique identifier for the assessment control.
         */
        public var id: kotlin.String? = null
        /**
         * The time when the assessment control insights were last updated.
         */
        public var lastUpdated: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the assessment control.
         */
        public var name: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.auditmanager.model.ControlInsightsMetadataByAssessmentItem) : this() {
            this.controlSetName = x.controlSetName
            this.evidenceInsights = x.evidenceInsights
            this.id = x.id
            this.lastUpdated = x.lastUpdated
            this.name = x.name
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.auditmanager.model.ControlInsightsMetadataByAssessmentItem = ControlInsightsMetadataByAssessmentItem(this)

        /**
         * construct an [aws.sdk.kotlin.services.auditmanager.model.EvidenceInsights] inside the given [block]
         */
        public fun evidenceInsights(block: aws.sdk.kotlin.services.auditmanager.model.EvidenceInsights.Builder.() -> kotlin.Unit) {
            this.evidenceInsights = aws.sdk.kotlin.services.auditmanager.model.EvidenceInsights.invoke(block)
        }
    }
}
