// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.auditmanager.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A record that contains the information needed to demonstrate compliance with the requirements specified by a control. Examples of evidence include change activity triggered by a user, or a system configuration snapshot.
 */
public class Evidence private constructor(builder: Builder) {
    /**
     * Specifies whether the evidence is included in the assessment report.
     */
    public val assessmentReportSelection: kotlin.String? = builder.assessmentReportSelection
    /**
     * The names and values that are used by the evidence event. This includes an attribute name (such as `allowUsersToChangePassword`) and value (such as `true` or `false`).
     */
    public val attributes: Map<String, String>? = builder.attributes
    /**
     * The identifier for the Amazon Web Services account.
     */
    public val awsAccountId: kotlin.String? = builder.awsAccountId
    /**
     * The Amazon Web Services account that the evidence is collected from, and its organization path.
     */
    public val awsOrganization: kotlin.String? = builder.awsOrganization
    /**
     * The evaluation status for automated evidence that falls under the compliance check category.
     * + Audit Manager classes evidence as non-compliant if Security Hub reports a *Fail* result, or if Config reports a *Non-compliant* result.
     * + Audit Manager classes evidence as compliant if Security Hub reports a *Pass* result, or if Config reports a *Compliant* result.
     * + If a compliance check isn't available or applicable, then no compliance evaluation can be made for that evidence. This is the case if the evidence uses Config or Security Hub as the underlying data source type, but those services aren't enabled. This is also the case if the evidence uses an underlying data source type that doesn't support compliance checks (such as manual evidence, Amazon Web Services API calls, or CloudTrail).
     */
    public val complianceCheck: kotlin.String? = builder.complianceCheck
    /**
     * The data source where the evidence was collected from.
     */
    public val dataSource: kotlin.String? = builder.dataSource
    /**
     * The name of the evidence event.
     */
    public val eventName: kotlin.String? = builder.eventName
    /**
     * The Amazon Web Service that the evidence is collected from.
     */
    public val eventSource: kotlin.String? = builder.eventSource
    /**
     * The identifier for the Amazon Web Services account.
     */
    public val evidenceAwsAccountId: kotlin.String? = builder.evidenceAwsAccountId
    /**
     * The type of automated evidence.
     */
    public val evidenceByType: kotlin.String? = builder.evidenceByType
    /**
     * The identifier for the folder that the evidence is stored in.
     */
    public val evidenceFolderId: kotlin.String? = builder.evidenceFolderId
    /**
     * The unique identifier for the IAM user or role that's associated with the evidence.
     */
    public val iamId: kotlin.String? = builder.iamId
    /**
     * The identifier for the evidence.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The list of resources that are assessed to generate the evidence.
     */
    public val resourcesIncluded: List<Resource>? = builder.resourcesIncluded
    /**
     * The timestamp that represents when the evidence was collected.
     */
    public val time: aws.smithy.kotlin.runtime.time.Instant? = builder.time

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.auditmanager.model.Evidence = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Evidence(")
        append("assessmentReportSelection=$assessmentReportSelection,")
        append("attributes=$attributes,")
        append("awsAccountId=$awsAccountId,")
        append("awsOrganization=$awsOrganization,")
        append("complianceCheck=$complianceCheck,")
        append("dataSource=$dataSource,")
        append("eventName=$eventName,")
        append("eventSource=$eventSource,")
        append("evidenceAwsAccountId=$evidenceAwsAccountId,")
        append("evidenceByType=$evidenceByType,")
        append("evidenceFolderId=$evidenceFolderId,")
        append("iamId=$iamId,")
        append("id=$id,")
        append("resourcesIncluded=$resourcesIncluded,")
        append("time=$time)")
    }

    override fun hashCode(): kotlin.Int {
        var result = assessmentReportSelection?.hashCode() ?: 0
        result = 31 * result + (attributes?.hashCode() ?: 0)
        result = 31 * result + (awsAccountId?.hashCode() ?: 0)
        result = 31 * result + (awsOrganization?.hashCode() ?: 0)
        result = 31 * result + (complianceCheck?.hashCode() ?: 0)
        result = 31 * result + (dataSource?.hashCode() ?: 0)
        result = 31 * result + (eventName?.hashCode() ?: 0)
        result = 31 * result + (eventSource?.hashCode() ?: 0)
        result = 31 * result + (evidenceAwsAccountId?.hashCode() ?: 0)
        result = 31 * result + (evidenceByType?.hashCode() ?: 0)
        result = 31 * result + (evidenceFolderId?.hashCode() ?: 0)
        result = 31 * result + (iamId?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (resourcesIncluded?.hashCode() ?: 0)
        result = 31 * result + (time?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Evidence

        if (assessmentReportSelection != other.assessmentReportSelection) return false
        if (attributes != other.attributes) return false
        if (awsAccountId != other.awsAccountId) return false
        if (awsOrganization != other.awsOrganization) return false
        if (complianceCheck != other.complianceCheck) return false
        if (dataSource != other.dataSource) return false
        if (eventName != other.eventName) return false
        if (eventSource != other.eventSource) return false
        if (evidenceAwsAccountId != other.evidenceAwsAccountId) return false
        if (evidenceByType != other.evidenceByType) return false
        if (evidenceFolderId != other.evidenceFolderId) return false
        if (iamId != other.iamId) return false
        if (id != other.id) return false
        if (resourcesIncluded != other.resourcesIncluded) return false
        if (time != other.time) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.auditmanager.model.Evidence = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies whether the evidence is included in the assessment report.
         */
        public var assessmentReportSelection: kotlin.String? = null
        /**
         * The names and values that are used by the evidence event. This includes an attribute name (such as `allowUsersToChangePassword`) and value (such as `true` or `false`).
         */
        public var attributes: Map<String, String>? = null
        /**
         * The identifier for the Amazon Web Services account.
         */
        public var awsAccountId: kotlin.String? = null
        /**
         * The Amazon Web Services account that the evidence is collected from, and its organization path.
         */
        public var awsOrganization: kotlin.String? = null
        /**
         * The evaluation status for automated evidence that falls under the compliance check category.
         * + Audit Manager classes evidence as non-compliant if Security Hub reports a *Fail* result, or if Config reports a *Non-compliant* result.
         * + Audit Manager classes evidence as compliant if Security Hub reports a *Pass* result, or if Config reports a *Compliant* result.
         * + If a compliance check isn't available or applicable, then no compliance evaluation can be made for that evidence. This is the case if the evidence uses Config or Security Hub as the underlying data source type, but those services aren't enabled. This is also the case if the evidence uses an underlying data source type that doesn't support compliance checks (such as manual evidence, Amazon Web Services API calls, or CloudTrail).
         */
        public var complianceCheck: kotlin.String? = null
        /**
         * The data source where the evidence was collected from.
         */
        public var dataSource: kotlin.String? = null
        /**
         * The name of the evidence event.
         */
        public var eventName: kotlin.String? = null
        /**
         * The Amazon Web Service that the evidence is collected from.
         */
        public var eventSource: kotlin.String? = null
        /**
         * The identifier for the Amazon Web Services account.
         */
        public var evidenceAwsAccountId: kotlin.String? = null
        /**
         * The type of automated evidence.
         */
        public var evidenceByType: kotlin.String? = null
        /**
         * The identifier for the folder that the evidence is stored in.
         */
        public var evidenceFolderId: kotlin.String? = null
        /**
         * The unique identifier for the IAM user or role that's associated with the evidence.
         */
        public var iamId: kotlin.String? = null
        /**
         * The identifier for the evidence.
         */
        public var id: kotlin.String? = null
        /**
         * The list of resources that are assessed to generate the evidence.
         */
        public var resourcesIncluded: List<Resource>? = null
        /**
         * The timestamp that represents when the evidence was collected.
         */
        public var time: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.auditmanager.model.Evidence) : this() {
            this.assessmentReportSelection = x.assessmentReportSelection
            this.attributes = x.attributes
            this.awsAccountId = x.awsAccountId
            this.awsOrganization = x.awsOrganization
            this.complianceCheck = x.complianceCheck
            this.dataSource = x.dataSource
            this.eventName = x.eventName
            this.eventSource = x.eventSource
            this.evidenceAwsAccountId = x.evidenceAwsAccountId
            this.evidenceByType = x.evidenceByType
            this.evidenceFolderId = x.evidenceFolderId
            this.iamId = x.iamId
            this.id = x.id
            this.resourcesIncluded = x.resourcesIncluded
            this.time = x.time
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.auditmanager.model.Evidence = Evidence(this)
    }
}
