// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.auditmanager.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The file that's used to structure and automate Audit Manager assessments for a given compliance standard.
 */
public class Framework private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the framework.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The compliance type that the new custom framework supports, such as CIS or HIPAA.
     */
    public val complianceType: kotlin.String? = builder.complianceType
    /**
     * The control sets that are associated with the framework.
     */
    public val controlSets: List<ControlSet>? = builder.controlSets
    /**
     * The sources that Audit Manager collects evidence from for the control.
     */
    public val controlSources: kotlin.String? = builder.controlSources
    /**
     * Specifies when the framework was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The IAM user or role that created the framework.
     */
    public val createdBy: kotlin.String? = builder.createdBy
    /**
     * The description of the framework.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The unique identifier for the framework.
     */
    public val id: kotlin.String? = builder.id
    /**
     * Specifies when the framework was most recently updated.
     */
    public val lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedAt
    /**
     * The IAM user or role that most recently updated the framework.
     */
    public val lastUpdatedBy: kotlin.String? = builder.lastUpdatedBy
    /**
     * The logo that's associated with the framework.
     */
    public val logo: kotlin.String? = builder.logo
    /**
     * The name of the framework.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The tags that are associated with the framework.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The framework type, such as a custom framework or a standard framework.
     */
    public val type: aws.sdk.kotlin.services.auditmanager.model.FrameworkType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.auditmanager.model.Framework = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Framework(")
        append("arn=$arn,")
        append("complianceType=$complianceType,")
        append("controlSets=$controlSets,")
        append("controlSources=$controlSources,")
        append("createdAt=$createdAt,")
        append("createdBy=$createdBy,")
        append("description=$description,")
        append("id=$id,")
        append("lastUpdatedAt=$lastUpdatedAt,")
        append("lastUpdatedBy=$lastUpdatedBy,")
        append("logo=$logo,")
        append("name=$name,")
        append("tags=$tags,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (complianceType?.hashCode() ?: 0)
        result = 31 * result + (controlSets?.hashCode() ?: 0)
        result = 31 * result + (controlSources?.hashCode() ?: 0)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (createdBy?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedAt?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedBy?.hashCode() ?: 0)
        result = 31 * result + (logo?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Framework

        if (arn != other.arn) return false
        if (complianceType != other.complianceType) return false
        if (controlSets != other.controlSets) return false
        if (controlSources != other.controlSources) return false
        if (createdAt != other.createdAt) return false
        if (createdBy != other.createdBy) return false
        if (description != other.description) return false
        if (id != other.id) return false
        if (lastUpdatedAt != other.lastUpdatedAt) return false
        if (lastUpdatedBy != other.lastUpdatedBy) return false
        if (logo != other.logo) return false
        if (name != other.name) return false
        if (tags != other.tags) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.auditmanager.model.Framework = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the framework.
         */
        public var arn: kotlin.String? = null
        /**
         * The compliance type that the new custom framework supports, such as CIS or HIPAA.
         */
        public var complianceType: kotlin.String? = null
        /**
         * The control sets that are associated with the framework.
         */
        public var controlSets: List<ControlSet>? = null
        /**
         * The sources that Audit Manager collects evidence from for the control.
         */
        public var controlSources: kotlin.String? = null
        /**
         * Specifies when the framework was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The IAM user or role that created the framework.
         */
        public var createdBy: kotlin.String? = null
        /**
         * The description of the framework.
         */
        public var description: kotlin.String? = null
        /**
         * The unique identifier for the framework.
         */
        public var id: kotlin.String? = null
        /**
         * Specifies when the framework was most recently updated.
         */
        public var lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The IAM user or role that most recently updated the framework.
         */
        public var lastUpdatedBy: kotlin.String? = null
        /**
         * The logo that's associated with the framework.
         */
        public var logo: kotlin.String? = null
        /**
         * The name of the framework.
         */
        public var name: kotlin.String? = null
        /**
         * The tags that are associated with the framework.
         */
        public var tags: Map<String, String>? = null
        /**
         * The framework type, such as a custom framework or a standard framework.
         */
        public var type: aws.sdk.kotlin.services.auditmanager.model.FrameworkType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.auditmanager.model.Framework) : this() {
            this.arn = x.arn
            this.complianceType = x.complianceType
            this.controlSets = x.controlSets
            this.controlSources = x.controlSources
            this.createdAt = x.createdAt
            this.createdBy = x.createdBy
            this.description = x.description
            this.id = x.id
            this.lastUpdatedAt = x.lastUpdatedAt
            this.lastUpdatedBy = x.lastUpdatedBy
            this.logo = x.logo
            this.name = x.name
            this.tags = x.tags
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.auditmanager.model.Framework = Framework(this)
    }
}
