// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.auditmanager.model



/**
 * A system asset that's evaluated in an Audit Manager assessment.
 */
public class Resource private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) for the resource.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The evaluation status for a resource that was assessed when collecting compliance check evidence.
     * + Audit Manager classes the resource as non-compliant if Security Hub reports a *Fail* result, or if Config reports a *Non-compliant* result.
     * + Audit Manager classes the resource as compliant if Security Hub reports a *Pass* result, or if Config reports a *Compliant* result.
     * + If a compliance check isn't available or applicable, then no compliance evaluation can be made for that resource. This is the case if a resource assessment uses Config or Security Hub as the underlying data source type, but those services aren't enabled. This is also the case if the resource assessment uses an underlying data source type that doesn't support compliance checks (such as manual evidence, Amazon Web Services API calls, or CloudTrail).
     */
    public val complianceCheck: kotlin.String? = builder.complianceCheck
    /**
     * The value of the resource.
     */
    public val value: kotlin.String? = builder.value

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.auditmanager.model.Resource = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Resource(")
        append("arn=$arn,")
        append("complianceCheck=$complianceCheck,")
        append("value=$value)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (complianceCheck?.hashCode() ?: 0)
        result = 31 * result + (value?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Resource

        if (arn != other.arn) return false
        if (complianceCheck != other.complianceCheck) return false
        if (value != other.value) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.auditmanager.model.Resource = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) for the resource.
         */
        public var arn: kotlin.String? = null
        /**
         * The evaluation status for a resource that was assessed when collecting compliance check evidence.
         * + Audit Manager classes the resource as non-compliant if Security Hub reports a *Fail* result, or if Config reports a *Non-compliant* result.
         * + Audit Manager classes the resource as compliant if Security Hub reports a *Pass* result, or if Config reports a *Compliant* result.
         * + If a compliance check isn't available or applicable, then no compliance evaluation can be made for that resource. This is the case if a resource assessment uses Config or Security Hub as the underlying data source type, but those services aren't enabled. This is also the case if the resource assessment uses an underlying data source type that doesn't support compliance checks (such as manual evidence, Amazon Web Services API calls, or CloudTrail).
         */
        public var complianceCheck: kotlin.String? = null
        /**
         * The value of the resource.
         */
        public var value: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.auditmanager.model.Resource) : this() {
            this.arn = x.arn
            this.complianceCheck = x.complianceCheck
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.auditmanager.model.Resource = Resource(this)
    }
}
