// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.auditmanager.model



/**
 * The keyword to search for in CloudTrail logs, Config rules, Security Hub checks, and Amazon Web Services API names.
 *
 *  To learn more about the supported keywords that you can use when mapping a control data source, see the following pages in the *Audit Manager User Guide*:
 * + [Config rules supported by Audit Manager](https://docs.aws.amazon.com/audit-manager/latest/userguide/control-data-sources-ash.html)
 * + [Security Hub controls supported by Audit Manager](https://docs.aws.amazon.com/audit-manager/latest/userguide/control-data-sources-config.html)
 * + [API calls supported by Audit Manager](https://docs.aws.amazon.com/audit-manager/latest/userguide/control-data-sources-api.html)
 * + [CloudTrail event names supported by Audit Manager](https://docs.aws.amazon.com/audit-manager/latest/userguide/control-data-sources-cloudtrail.html)
 */
public class SourceKeyword private constructor(builder: Builder) {
    /**
     * The input method for the keyword.
     */
    public val keywordInputType: aws.sdk.kotlin.services.auditmanager.model.KeywordInputType? = builder.keywordInputType
    /**
     * The value of the keyword that's used when mapping a control data source. For example, this can be a CloudTrail event name, a rule name for Config, a Security Hub control, or the name of an Amazon Web Services API call.
     *
     * If you’re mapping a data source to a rule in Config, the `keywordValue` that you specify depends on the type of rule:
     * + For [managed rules](https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_use-managed-rules.html), you can use the rule identifier as the `keywordValue`. You can find the rule identifier from the [list of Config managed rules](https://docs.aws.amazon.com/config/latest/developerguide/managed-rules-by-aws-config.html).
     *    + Managed rule name: [s3-bucket-acl-prohibited](https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-acl-prohibited.html)`keywordValue`: `S3_BUCKET_ACL_PROHIBITED`
     * + For [custom rules](https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_develop-rules.html), you form the `keywordValue` by adding the `Custom_` prefix to the rule name. This prefix distinguishes the rule from a managed rule.
     *    + Custom rule name: my-custom-config-rule`keywordValue`: `Custom_my-custom-config-rule`
     * + For [service-linked rules](https://docs.aws.amazon.com/config/latest/developerguide/service-linked-awsconfig-rules.html), you form the `keywordValue` by adding the `Custom_` prefix to the rule name. In addition, you remove the suffix ID that appears at the end of the rule name.
     *    + Service-linked rule name: CustomRuleForAccount-conformance-pack-szsm1uv0w`keywordValue`: `Custom_CustomRuleForAccount-conformance-pack`
     *    + Service-linked rule name: OrgConfigRule-s3-bucket-versioning-enabled-dbgzf8ba`keywordValue`: `Custom_OrgConfigRule-s3-bucket-versioning-enabled`
     */
    public val keywordValue: kotlin.String? = builder.keywordValue

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.auditmanager.model.SourceKeyword = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SourceKeyword(")
        append("keywordInputType=$keywordInputType,")
        append("keywordValue=$keywordValue)")
    }

    override fun hashCode(): kotlin.Int {
        var result = keywordInputType?.hashCode() ?: 0
        result = 31 * result + (keywordValue?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SourceKeyword

        if (keywordInputType != other.keywordInputType) return false
        if (keywordValue != other.keywordValue) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.auditmanager.model.SourceKeyword = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The input method for the keyword.
         */
        public var keywordInputType: aws.sdk.kotlin.services.auditmanager.model.KeywordInputType? = null
        /**
         * The value of the keyword that's used when mapping a control data source. For example, this can be a CloudTrail event name, a rule name for Config, a Security Hub control, or the name of an Amazon Web Services API call.
         *
         * If you’re mapping a data source to a rule in Config, the `keywordValue` that you specify depends on the type of rule:
         * + For [managed rules](https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_use-managed-rules.html), you can use the rule identifier as the `keywordValue`. You can find the rule identifier from the [list of Config managed rules](https://docs.aws.amazon.com/config/latest/developerguide/managed-rules-by-aws-config.html).
         *    + Managed rule name: [s3-bucket-acl-prohibited](https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-acl-prohibited.html)`keywordValue`: `S3_BUCKET_ACL_PROHIBITED`
         * + For [custom rules](https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_develop-rules.html), you form the `keywordValue` by adding the `Custom_` prefix to the rule name. This prefix distinguishes the rule from a managed rule.
         *    + Custom rule name: my-custom-config-rule`keywordValue`: `Custom_my-custom-config-rule`
         * + For [service-linked rules](https://docs.aws.amazon.com/config/latest/developerguide/service-linked-awsconfig-rules.html), you form the `keywordValue` by adding the `Custom_` prefix to the rule name. In addition, you remove the suffix ID that appears at the end of the rule name.
         *    + Service-linked rule name: CustomRuleForAccount-conformance-pack-szsm1uv0w`keywordValue`: `Custom_CustomRuleForAccount-conformance-pack`
         *    + Service-linked rule name: OrgConfigRule-s3-bucket-versioning-enabled-dbgzf8ba`keywordValue`: `Custom_OrgConfigRule-s3-bucket-versioning-enabled`
         */
        public var keywordValue: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.auditmanager.model.SourceKeyword) : this() {
            this.keywordInputType = x.keywordInputType
            this.keywordValue = x.keywordValue
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.auditmanager.model.SourceKeyword = SourceKeyword(this)
    }
}
