// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.auditmanager.transform

import aws.sdk.kotlin.services.auditmanager.model.ControlStatus
import aws.sdk.kotlin.services.auditmanager.model.UpdateAssessmentControlRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateAssessmentControlOperationSerializer: HttpSerialize<UpdateAssessmentControlRequest> {
    override suspend fun serialize(context: ExecutionContext, input: UpdateAssessmentControlRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            val pathSegments = listOf<String>(
                "assessments",
                "${input.assessmentId}".encodeLabel(),
                "controlSets",
                "${input.controlSetId}".encodeLabel(),
                "controls",
                "${input.controlId}".encodeLabel(),
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeUpdateAssessmentControlOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateAssessmentControlOperationBody(context: ExecutionContext, input: UpdateAssessmentControlRequest): ByteArray {
    val serializer = JsonSerializer()
    val COMMENTBODY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("commentBody"))
    val CONTROLSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("controlStatus"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(COMMENTBODY_DESCRIPTOR)
        field(CONTROLSTATUS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.commentBody?.let { field(COMMENTBODY_DESCRIPTOR, it) }
        input.controlStatus?.let { field(CONTROLSTATUS_DESCRIPTOR, it.value) }
    }
    return serializer.toByteArray()
}
