// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.auditmanager.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.auditmanager.model.AuditManagerException
import aws.sdk.kotlin.services.auditmanager.model.ValidateAssessmentReportIntegrityResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class ValidateAssessmentReportIntegrityOperationDeserializer: HttpDeserialize<ValidateAssessmentReportIntegrityResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ValidateAssessmentReportIntegrityResponse {
        if (!response.status.isSuccess()) {
            throwValidateAssessmentReportIntegrityError(context, response)
        }
        val builder = ValidateAssessmentReportIntegrityResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeValidateAssessmentReportIntegrityOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwValidateAssessmentReportIntegrityError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw AuditManagerException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> AuditManagerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeValidateAssessmentReportIntegrityOperationBody(builder: ValidateAssessmentReportIntegrityResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val SIGNATUREALGORITHM_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("signatureAlgorithm"))
    val SIGNATUREDATETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("signatureDateTime"))
    val SIGNATUREKEYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("signatureKeyId"))
    val SIGNATUREVALID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("signatureValid"))
    val VALIDATIONERRORS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("validationErrors"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(SIGNATUREALGORITHM_DESCRIPTOR)
        field(SIGNATUREDATETIME_DESCRIPTOR)
        field(SIGNATUREKEYID_DESCRIPTOR)
        field(SIGNATUREVALID_DESCRIPTOR)
        field(VALIDATIONERRORS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                SIGNATUREALGORITHM_DESCRIPTOR.index -> builder.signatureAlgorithm = deserializeString()
                SIGNATUREDATETIME_DESCRIPTOR.index -> builder.signatureDateTime = deserializeString()
                SIGNATUREKEYID_DESCRIPTOR.index -> builder.signatureKeyId = deserializeString()
                SIGNATUREVALID_DESCRIPTOR.index -> builder.signatureValid = deserializeBoolean()
                VALIDATIONERRORS_DESCRIPTOR.index -> builder.validationErrors =
                    deserializer.deserializeList(VALIDATIONERRORS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
