// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.runtime.auth.credentials.internal.sts.endpoints

import aws.sdk.kotlin.runtime.auth.credentials.internal.sts.endpoints.internal.partition
import aws.sdk.kotlin.runtime.endpoint.AuthScheme
import aws.sdk.kotlin.runtime.endpoint.AuthSchemesAttributeKey
import aws.smithy.kotlin.runtime.http.Url
import aws.smithy.kotlin.runtime.http.endpoints.Endpoint
import aws.smithy.kotlin.runtime.http.endpoints.EndpointProviderException
import aws.smithy.kotlin.runtime.http.endpoints.functions.parseUrl
import aws.smithy.kotlin.runtime.util.Attributes

/**
 * The default endpoint provider as specified by the service model.
 */
public class DefaultEndpointProvider: EndpointProvider {
    public override suspend fun resolveEndpoint(params: EndpointParameters): Endpoint {
        run {
            val partitionResult = partition(params.region)
            if (
                partitionResult != null
            ) {
                if (
                    params.useGlobalEndpoint == true &&
                    params.useFips == false &&
                    params.useDualStack == false &&
                    !(params.endpoint != null)
                ) {
                    if (
                        params.region == "ap-northeast-1"
                    ) {
                        return Endpoint(
                            Url.parse("https://sts.amazonaws.com"),
                            attributes = Attributes().apply {
                                set(
                                    AuthSchemesAttributeKey,
                                    listOf(
                                        AuthScheme.SigV4(
                                            signingName = "sts",
                                            disableDoubleEncoding = false,
                                            signingRegion = "us-east-1",
                                        ),
                                    ),
                                )
                            },
                        )
                    }
                    if (
                        params.region == "ap-south-1"
                    ) {
                        return Endpoint(
                            Url.parse("https://sts.amazonaws.com"),
                            attributes = Attributes().apply {
                                set(
                                    AuthSchemesAttributeKey,
                                    listOf(
                                        AuthScheme.SigV4(
                                            signingName = "sts",
                                            disableDoubleEncoding = false,
                                            signingRegion = "us-east-1",
                                        ),
                                    ),
                                )
                            },
                        )
                    }
                    if (
                        params.region == "ap-southeast-1"
                    ) {
                        return Endpoint(
                            Url.parse("https://sts.amazonaws.com"),
                            attributes = Attributes().apply {
                                set(
                                    AuthSchemesAttributeKey,
                                    listOf(
                                        AuthScheme.SigV4(
                                            signingName = "sts",
                                            disableDoubleEncoding = false,
                                            signingRegion = "us-east-1",
                                        ),
                                    ),
                                )
                            },
                        )
                    }
                    if (
                        params.region == "ap-southeast-2"
                    ) {
                        return Endpoint(
                            Url.parse("https://sts.amazonaws.com"),
                            attributes = Attributes().apply {
                                set(
                                    AuthSchemesAttributeKey,
                                    listOf(
                                        AuthScheme.SigV4(
                                            signingName = "sts",
                                            disableDoubleEncoding = false,
                                            signingRegion = "us-east-1",
                                        ),
                                    ),
                                )
                            },
                        )
                    }
                    if (
                        params.region == "aws-global"
                    ) {
                        return Endpoint(
                            Url.parse("https://sts.amazonaws.com"),
                            attributes = Attributes().apply {
                                set(
                                    AuthSchemesAttributeKey,
                                    listOf(
                                        AuthScheme.SigV4(
                                            signingName = "sts",
                                            disableDoubleEncoding = false,
                                            signingRegion = "us-east-1",
                                        ),
                                    ),
                                )
                            },
                        )
                    }
                    if (
                        params.region == "ca-central-1"
                    ) {
                        return Endpoint(
                            Url.parse("https://sts.amazonaws.com"),
                            attributes = Attributes().apply {
                                set(
                                    AuthSchemesAttributeKey,
                                    listOf(
                                        AuthScheme.SigV4(
                                            signingName = "sts",
                                            disableDoubleEncoding = false,
                                            signingRegion = "us-east-1",
                                        ),
                                    ),
                                )
                            },
                        )
                    }
                    if (
                        params.region == "eu-central-1"
                    ) {
                        return Endpoint(
                            Url.parse("https://sts.amazonaws.com"),
                            attributes = Attributes().apply {
                                set(
                                    AuthSchemesAttributeKey,
                                    listOf(
                                        AuthScheme.SigV4(
                                            signingName = "sts",
                                            disableDoubleEncoding = false,
                                            signingRegion = "us-east-1",
                                        ),
                                    ),
                                )
                            },
                        )
                    }
                    if (
                        params.region == "eu-north-1"
                    ) {
                        return Endpoint(
                            Url.parse("https://sts.amazonaws.com"),
                            attributes = Attributes().apply {
                                set(
                                    AuthSchemesAttributeKey,
                                    listOf(
                                        AuthScheme.SigV4(
                                            signingName = "sts",
                                            disableDoubleEncoding = false,
                                            signingRegion = "us-east-1",
                                        ),
                                    ),
                                )
                            },
                        )
                    }
                    if (
                        params.region == "eu-west-1"
                    ) {
                        return Endpoint(
                            Url.parse("https://sts.amazonaws.com"),
                            attributes = Attributes().apply {
                                set(
                                    AuthSchemesAttributeKey,
                                    listOf(
                                        AuthScheme.SigV4(
                                            signingName = "sts",
                                            disableDoubleEncoding = false,
                                            signingRegion = "us-east-1",
                                        ),
                                    ),
                                )
                            },
                        )
                    }
                    if (
                        params.region == "eu-west-2"
                    ) {
                        return Endpoint(
                            Url.parse("https://sts.amazonaws.com"),
                            attributes = Attributes().apply {
                                set(
                                    AuthSchemesAttributeKey,
                                    listOf(
                                        AuthScheme.SigV4(
                                            signingName = "sts",
                                            disableDoubleEncoding = false,
                                            signingRegion = "us-east-1",
                                        ),
                                    ),
                                )
                            },
                        )
                    }
                    if (
                        params.region == "eu-west-3"
                    ) {
                        return Endpoint(
                            Url.parse("https://sts.amazonaws.com"),
                            attributes = Attributes().apply {
                                set(
                                    AuthSchemesAttributeKey,
                                    listOf(
                                        AuthScheme.SigV4(
                                            signingName = "sts",
                                            disableDoubleEncoding = false,
                                            signingRegion = "us-east-1",
                                        ),
                                    ),
                                )
                            },
                        )
                    }
                    if (
                        params.region == "sa-east-1"
                    ) {
                        return Endpoint(
                            Url.parse("https://sts.amazonaws.com"),
                            attributes = Attributes().apply {
                                set(
                                    AuthSchemesAttributeKey,
                                    listOf(
                                        AuthScheme.SigV4(
                                            signingName = "sts",
                                            disableDoubleEncoding = false,
                                            signingRegion = "us-east-1",
                                        ),
                                    ),
                                )
                            },
                        )
                    }
                    if (
                        params.region == "us-east-1"
                    ) {
                        return Endpoint(
                            Url.parse("https://sts.amazonaws.com"),
                            attributes = Attributes().apply {
                                set(
                                    AuthSchemesAttributeKey,
                                    listOf(
                                        AuthScheme.SigV4(
                                            signingName = "sts",
                                            disableDoubleEncoding = false,
                                            signingRegion = "us-east-1",
                                        ),
                                    ),
                                )
                            },
                        )
                    }
                    if (
                        params.region == "us-east-2"
                    ) {
                        return Endpoint(
                            Url.parse("https://sts.amazonaws.com"),
                            attributes = Attributes().apply {
                                set(
                                    AuthSchemesAttributeKey,
                                    listOf(
                                        AuthScheme.SigV4(
                                            signingName = "sts",
                                            disableDoubleEncoding = false,
                                            signingRegion = "us-east-1",
                                        ),
                                    ),
                                )
                            },
                        )
                    }
                    if (
                        params.region == "us-west-1"
                    ) {
                        return Endpoint(
                            Url.parse("https://sts.amazonaws.com"),
                            attributes = Attributes().apply {
                                set(
                                    AuthSchemesAttributeKey,
                                    listOf(
                                        AuthScheme.SigV4(
                                            signingName = "sts",
                                            disableDoubleEncoding = false,
                                            signingRegion = "us-east-1",
                                        ),
                                    ),
                                )
                            },
                        )
                    }
                    if (
                        params.region == "us-west-2"
                    ) {
                        return Endpoint(
                            Url.parse("https://sts.amazonaws.com"),
                            attributes = Attributes().apply {
                                set(
                                    AuthSchemesAttributeKey,
                                    listOf(
                                        AuthScheme.SigV4(
                                            signingName = "sts",
                                            disableDoubleEncoding = false,
                                            signingRegion = "us-east-1",
                                        ),
                                    ),
                                )
                            },
                        )
                    }
                    return Endpoint(
                        Url.parse("https://sts.${params.region}.${partitionResult?.dnsSuffix}"),
                        attributes = Attributes().apply {
                            set(
                                AuthSchemesAttributeKey,
                                listOf(
                                    AuthScheme.SigV4(
                                        signingName = "sts",
                                        disableDoubleEncoding = false,
                                        signingRegion = "${params.region}",
                                    ),
                                ),
                            )
                        },
                    )
                }
                run {
                    val url = parseUrl(params.endpoint)
                    if (
                        url != null &&
                        params.endpoint != null
                    ) {
                        if (
                            params.useFips == true
                        ) {
                            throw EndpointProviderException("Invalid Configuration: FIPS and custom endpoint are not supported")
                        }
                        if (
                            params.useDualStack == true
                        ) {
                            throw EndpointProviderException("Invalid Configuration: Dualstack and custom endpoint are not supported")
                        }
                        return Endpoint(
                            Url.parse(params.endpoint),
                        )
                    }
                }
                if (
                    params.useFips == true &&
                    params.useDualStack == true
                ) {
                    if (
                        true == partitionResult?.supportsFIPS &&
                        true == partitionResult?.supportsDualStack
                    ) {
                        return Endpoint(
                            Url.parse("https://sts-fips.${params.region}.${partitionResult?.dualStackDnsSuffix}"),
                        )
                    }
                    throw EndpointProviderException("FIPS and DualStack are enabled, but this partition does not support one or both")
                }
                if (
                    params.useFips == true
                ) {
                    if (
                        true == partitionResult?.supportsFIPS
                    ) {
                        if (
                            "aws-us-gov" == partitionResult?.name
                        ) {
                            return Endpoint(
                                Url.parse("https://sts.${params.region}.${partitionResult?.dnsSuffix}"),
                            )
                        }
                        return Endpoint(
                            Url.parse("https://sts-fips.${params.region}.${partitionResult?.dnsSuffix}"),
                        )
                    }
                    throw EndpointProviderException("FIPS is enabled but this partition does not support FIPS")
                }
                if (
                    params.useDualStack == true
                ) {
                    if (
                        true == partitionResult?.supportsDualStack
                    ) {
                        return Endpoint(
                            Url.parse("https://sts.${params.region}.${partitionResult?.dualStackDnsSuffix}"),
                        )
                    }
                    throw EndpointProviderException("DualStack is enabled but this partition does not support DualStack")
                }
                if (
                    params.region == "aws-global"
                ) {
                    return Endpoint(
                        Url.parse("https://sts.amazonaws.com"),
                        attributes = Attributes().apply {
                            set(
                                AuthSchemesAttributeKey,
                                listOf(
                                    AuthScheme.SigV4(
                                        signingName = "sts",
                                        disableDoubleEncoding = false,
                                        signingRegion = "us-east-1",
                                    ),
                                ),
                            )
                        },
                    )
                }
                return Endpoint(
                    Url.parse("https://sts.${params.region}.${partitionResult?.dnsSuffix}"),
                )
            }
        }

        throw EndpointProviderException("endpoint rules were exhausted without a match")
    }
}
