// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.runtime.auth.credentials.internal.sso.model



/**
 * Provides information about the role credentials that are assigned to the user.
 */
class RoleCredentials private constructor(builder: Builder) {
    /**
     * The identifier used for the temporary security credentials. For more information, see [Using Temporary Security Credentials to Request Access to AWS Resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_use-resources.html) in the *AWS IAM User Guide*.
     */
    val accessKeyId: kotlin.String? = builder.accessKeyId
    /**
     * The date on which temporary security credentials expire.
     */
    val expiration: kotlin.Long = builder.expiration
    /**
     * The key that is used to sign the request. For more information, see [Using Temporary Security Credentials to Request Access to AWS Resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_use-resources.html) in the *AWS IAM User Guide*.
     */
    val secretAccessKey: kotlin.String? = builder.secretAccessKey
    /**
     * The token used for temporary credentials. For more information, see [Using Temporary Security Credentials to Request Access to AWS Resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_use-resources.html) in the *AWS IAM User Guide*.
     */
    val sessionToken: kotlin.String? = builder.sessionToken

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.runtime.auth.credentials.internal.sso.model.RoleCredentials = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RoleCredentials(")
        append("accessKeyId=$accessKeyId,")
        append("expiration=$expiration,")
        append("secretAccessKey=*** Sensitive Data Redacted ***,")
        append("sessionToken=*** Sensitive Data Redacted ***)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessKeyId?.hashCode() ?: 0
        result = 31 * result + (expiration.hashCode())
        result = 31 * result + (secretAccessKey?.hashCode() ?: 0)
        result = 31 * result + (sessionToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RoleCredentials

        if (accessKeyId != other.accessKeyId) return false
        if (expiration != other.expiration) return false
        if (secretAccessKey != other.secretAccessKey) return false
        if (sessionToken != other.sessionToken) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.runtime.auth.credentials.internal.sso.model.RoleCredentials = Builder(this).apply(block).build()

    class Builder {
        /**
         * The identifier used for the temporary security credentials. For more information, see [Using Temporary Security Credentials to Request Access to AWS Resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_use-resources.html) in the *AWS IAM User Guide*.
         */
        var accessKeyId: kotlin.String? = null
        /**
         * The date on which temporary security credentials expire.
         */
        var expiration: kotlin.Long = 0L
        /**
         * The key that is used to sign the request. For more information, see [Using Temporary Security Credentials to Request Access to AWS Resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_use-resources.html) in the *AWS IAM User Guide*.
         */
        var secretAccessKey: kotlin.String? = null
        /**
         * The token used for temporary credentials. For more information, see [Using Temporary Security Credentials to Request Access to AWS Resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_use-resources.html) in the *AWS IAM User Guide*.
         */
        var sessionToken: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.runtime.auth.credentials.internal.sso.model.RoleCredentials) : this() {
            this.accessKeyId = x.accessKeyId
            this.expiration = x.expiration
            this.secretAccessKey = x.secretAccessKey
            this.sessionToken = x.sessionToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.runtime.auth.credentials.internal.sso.model.RoleCredentials = RoleCredentials(this)
    }
}
