/*
 * Decompiled with CFR 0.152.
 */
package aws.sdk.kotlin.runtime.endpoint.internal;

import aws.sdk.kotlin.runtime.InternalSdkApi;
import aws.sdk.kotlin.runtime.endpoint.AwsEndpoint;
import aws.sdk.kotlin.runtime.endpoint.CredentialScope;
import aws.sdk.kotlin.runtime.endpoint.internal.EndpointDefinition;
import aws.sdk.kotlin.runtime.endpoint.internal.Partition;
import aws.smithy.kotlin.runtime.http.Protocol;
import aws.smithy.kotlin.runtime.http.Url;
import aws.smithy.kotlin.runtime.http.operation.Endpoint;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u001a,\u0010\u0006\u001a\u00020\u00012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00010\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00010\u00042\u0006\u0010\t\u001a\u00020\u0001H\u0002\u001a\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u000bH\u0002\u001a \u0010\r\u001a\u0004\u0018\u00010\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u00042\u0006\u0010\u0011\u001a\u00020\u0001H\u0007\u001a\u0014\u0010\u0012\u001a\u00020\u0013*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0001H\u0000\u001a\u0014\u0010\u0014\u001a\u00020\u000b*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0001H\u0002\u001a\u001c\u0010\u0015\u001a\u00020\u000e*\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u000bH\u0000\u001a\u0014\u0010\r\u001a\u00020\u000e*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0001H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"defaultProtocol", "", "defaultSigner", "protocolPriority", "", "signerPriority", "getByPriority", "from", "priority", "default", "mergeDefinitions", "Laws/sdk/kotlin/runtime/endpoint/internal/EndpointDefinition;", "into", "resolveEndpoint", "Laws/sdk/kotlin/runtime/endpoint/AwsEndpoint;", "partitions", "Laws/sdk/kotlin/runtime/endpoint/internal/Partition;", "region", "canResolveEndpoint", "", "endpointDefinitionForRegion", "resolve", "defaults", "aws-endpoint"})
public final class PartitionKt {
    @NotNull
    private static final String defaultProtocol = "https";
    @NotNull
    private static final String defaultSigner = "v4";
    @NotNull
    private static final List<String> protocolPriority;
    @NotNull
    private static final List<String> signerPriority;

    public static final boolean canResolveEndpoint(@NotNull Partition $this$canResolveEndpoint, @NotNull String region) {
        Intrinsics.checkNotNullParameter((Object)$this$canResolveEndpoint, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)region, (String)"region");
        return $this$canResolveEndpoint.getEndpoints().containsKey(region) || $this$canResolveEndpoint.getRegionRegex().matches((CharSequence)region);
    }

    @NotNull
    public static final AwsEndpoint resolveEndpoint(@NotNull Partition $this$resolveEndpoint, @NotNull String region) {
        Intrinsics.checkNotNullParameter((Object)$this$resolveEndpoint, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)region, (String)"region");
        String resolvedRegion = ((CharSequence)region).length() == 0 && ((CharSequence)$this$resolveEndpoint.getPartitionEndpoint()).length() > 0 ? $this$resolveEndpoint.getPartitionEndpoint() : region;
        EndpointDefinition endpointDefinition = PartitionKt.endpointDefinitionForRegion($this$resolveEndpoint, resolvedRegion);
        return PartitionKt.resolve(endpointDefinition, region, $this$resolveEndpoint.getDefaults());
    }

    private static final EndpointDefinition endpointDefinitionForRegion(Partition $this$endpointDefinitionForRegion, String region) {
        EndpointDefinition match = $this$endpointDefinitionForRegion.getEndpoints().containsKey(region) ? $this$endpointDefinitionForRegion.getEndpoints().get(region) : (!$this$endpointDefinitionForRegion.isRegionalized() ? $this$endpointDefinitionForRegion.getEndpoints().get($this$endpointDefinitionForRegion.getPartitionEndpoint()) : null);
        EndpointDefinition endpointDefinition = match;
        if (endpointDefinition == null) {
            endpointDefinition = new EndpointDefinition(null, null, null, null, 15, null);
        }
        return endpointDefinition;
    }

    @NotNull
    public static final AwsEndpoint resolve(@NotNull EndpointDefinition $this$resolve, @NotNull String region, @NotNull EndpointDefinition defaults) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$resolve, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)region, (String)"region");
        Intrinsics.checkNotNullParameter((Object)defaults, (String)"defaults");
        EndpointDefinition merged = PartitionKt.mergeDefinitions($this$resolve, defaults);
        if (merged.getHostname() == null) {
            boolean $i$a$-checkNotNull-PartitionKt$resolve$22 = false;
            String $i$a$-checkNotNull-PartitionKt$resolve$22 = "EndpointDefinition.hostname cannot be null at this point";
            throw new IllegalStateException($i$a$-checkNotNull-PartitionKt$resolve$22.toString());
        }
        String hostname = StringsKt.replace$default((String)merged.getHostname(), (String)"{region}", (String)region, (boolean)false, (int)4, null);
        String protocol = PartitionKt.getByPriority(merged.getProtocols(), protocolPriority, defaultProtocol);
        CredentialScope credentialScope = merged.getCredentialScope();
        String signingName = credentialScope == null ? null : credentialScope.getService();
        CredentialScope credentialScope2 = merged.getCredentialScope();
        if (credentialScope2 == null) {
            string = region;
        } else {
            string = credentialScope2.getRegion();
            if (string == null) {
                string = region;
            }
        }
        String signingRegion = string;
        Url uri = new Url(Protocol.Companion.parse(protocol), hostname, 0, null, null, null, null, false, false, 508, null);
        CredentialScope scope = new CredentialScope(signingRegion, signingName);
        return new AwsEndpoint(new Endpoint(uri, false, 2, null), scope);
    }

    private static final EndpointDefinition mergeDefinitions(EndpointDefinition into, EndpointDefinition from) {
        String string = into.getHostname();
        if (string == null) {
            string = from.getHostname();
        }
        String hostname = string;
        List<String> protocols = !((Collection)into.getProtocols()).isEmpty() ? into.getProtocols() : from.getProtocols();
        CredentialScope credentialScope = into.getCredentialScope();
        String string2 = credentialScope == null ? null : credentialScope.getRegion();
        if (string2 == null) {
            CredentialScope credentialScope2 = from.getCredentialScope();
            string2 = credentialScope2 == null ? null : credentialScope2.getRegion();
        }
        CredentialScope credentialScope3 = into.getCredentialScope();
        String string3 = credentialScope3 == null ? null : credentialScope3.getService();
        if (string3 == null) {
            CredentialScope credentialScope4 = from.getCredentialScope();
            string3 = credentialScope4 == null ? null : credentialScope4.getService();
        }
        CredentialScope credentialScope5 = new CredentialScope(string2, string3);
        List<String> signatureVersions = !((Collection)into.getSignatureVersions()).isEmpty() ? into.getSignatureVersions() : from.getSignatureVersions();
        return new EndpointDefinition(hostname, protocols, credentialScope5, signatureVersions);
    }

    private static final String getByPriority(List<String> from, List<String> priority, String string) {
        if (from.isEmpty()) {
            return string;
        }
        for (String p : priority) {
            String candidate;
            Object v0;
            block3: {
                for (Object t : (Iterable)from) {
                    String it = (String)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it, (Object)p)) continue;
                    v0 = t;
                    break block3;
                }
                v0 = null;
            }
            if ((candidate = (String)v0) == null) continue;
            return candidate;
        }
        return string;
    }

    @InternalSdkApi
    @Nullable
    public static final AwsEndpoint resolveEndpoint(@NotNull List<Partition> partitions, @NotNull String region) {
        Partition partition;
        Object v0;
        block3: {
            Intrinsics.checkNotNullParameter(partitions, (String)"partitions");
            Intrinsics.checkNotNullParameter((Object)region, (String)"region");
            if (partitions.isEmpty()) {
                return null;
            }
            Iterable $this$firstOrNull$iv = partitions;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Partition it = (Partition)element$iv;
                boolean bl = false;
                if (!PartitionKt.canResolveEndpoint(it, region)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        if ((partition = (Partition)v0) == null) {
            partition = partitions.get(0);
        }
        Partition candidate = partition;
        return PartitionKt.resolveEndpoint(candidate, region);
    }

    static {
        Object[] objectArray = new String[]{defaultProtocol, "http"};
        protocolPriority = CollectionsKt.listOf((Object[])objectArray);
        signerPriority = CollectionsKt.listOf((Object)defaultSigner);
    }
}

