// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains metadata about a backup plan.
 */
class BackupPlansListMember private constructor(builder: Builder) {
    /**
     * Contains a list of `BackupOptions` for a resource type.
     */
    val advancedBackupSettings: List<AdvancedBackupSetting>? = builder.advancedBackupSettings
    /**
     * An Amazon Resource Name (ARN) that uniquely identifies a backup plan; for example, `arn:aws:backup:us-east-1:123456789012:plan:8F81F553-3A74-4A3F-B93D-B3360DC80C50`.
     */
    val backupPlanArn: kotlin.String? = builder.backupPlanArn
    /**
     * Uniquely identifies a backup plan.
     */
    val backupPlanId: kotlin.String? = builder.backupPlanId
    /**
     * The display name of a saved backup plan.
     */
    val backupPlanName: kotlin.String? = builder.backupPlanName
    /**
     * The date and time a resource backup plan is created, in Unix format and Coordinated Universal Time (UTC). The value of `CreationDate` is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    val creationDate: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDate
    /**
     * A unique string that identifies the request and allows failed requests to be retried without the risk of running the operation twice. This parameter is optional.
     *
     * If used, this parameter must contain 1 to 50 alphanumeric or '-_.' characters.
     */
    val creatorRequestId: kotlin.String? = builder.creatorRequestId
    /**
     * The date and time a backup plan is deleted, in Unix format and Coordinated Universal Time (UTC). The value of `DeletionDate` is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    val deletionDate: aws.smithy.kotlin.runtime.time.Instant? = builder.deletionDate
    /**
     * The last time a job to back up resources was run with this rule. A date and time, in Unix format and Coordinated Universal Time (UTC). The value of `LastExecutionDate` is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    val lastExecutionDate: aws.smithy.kotlin.runtime.time.Instant? = builder.lastExecutionDate
    /**
     * Unique, randomly generated, Unicode, UTF-8 encoded strings that are at most 1,024 bytes long. Version IDs cannot be edited.
     */
    val versionId: kotlin.String? = builder.versionId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.backup.model.BackupPlansListMember = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BackupPlansListMember(")
        append("advancedBackupSettings=$advancedBackupSettings,")
        append("backupPlanArn=$backupPlanArn,")
        append("backupPlanId=$backupPlanId,")
        append("backupPlanName=$backupPlanName,")
        append("creationDate=$creationDate,")
        append("creatorRequestId=$creatorRequestId,")
        append("deletionDate=$deletionDate,")
        append("lastExecutionDate=$lastExecutionDate,")
        append("versionId=$versionId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = advancedBackupSettings?.hashCode() ?: 0
        result = 31 * result + (backupPlanArn?.hashCode() ?: 0)
        result = 31 * result + (backupPlanId?.hashCode() ?: 0)
        result = 31 * result + (backupPlanName?.hashCode() ?: 0)
        result = 31 * result + (creationDate?.hashCode() ?: 0)
        result = 31 * result + (creatorRequestId?.hashCode() ?: 0)
        result = 31 * result + (deletionDate?.hashCode() ?: 0)
        result = 31 * result + (lastExecutionDate?.hashCode() ?: 0)
        result = 31 * result + (versionId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BackupPlansListMember

        if (advancedBackupSettings != other.advancedBackupSettings) return false
        if (backupPlanArn != other.backupPlanArn) return false
        if (backupPlanId != other.backupPlanId) return false
        if (backupPlanName != other.backupPlanName) return false
        if (creationDate != other.creationDate) return false
        if (creatorRequestId != other.creatorRequestId) return false
        if (deletionDate != other.deletionDate) return false
        if (lastExecutionDate != other.lastExecutionDate) return false
        if (versionId != other.versionId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.backup.model.BackupPlansListMember = Builder(this).apply(block).build()

    class Builder {
        /**
         * Contains a list of `BackupOptions` for a resource type.
         */
        var advancedBackupSettings: List<AdvancedBackupSetting>? = null
        /**
         * An Amazon Resource Name (ARN) that uniquely identifies a backup plan; for example, `arn:aws:backup:us-east-1:123456789012:plan:8F81F553-3A74-4A3F-B93D-B3360DC80C50`.
         */
        var backupPlanArn: kotlin.String? = null
        /**
         * Uniquely identifies a backup plan.
         */
        var backupPlanId: kotlin.String? = null
        /**
         * The display name of a saved backup plan.
         */
        var backupPlanName: kotlin.String? = null
        /**
         * The date and time a resource backup plan is created, in Unix format and Coordinated Universal Time (UTC). The value of `CreationDate` is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         */
        var creationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A unique string that identifies the request and allows failed requests to be retried without the risk of running the operation twice. This parameter is optional.
         *
         * If used, this parameter must contain 1 to 50 alphanumeric or '-_.' characters.
         */
        var creatorRequestId: kotlin.String? = null
        /**
         * The date and time a backup plan is deleted, in Unix format and Coordinated Universal Time (UTC). The value of `DeletionDate` is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         */
        var deletionDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The last time a job to back up resources was run with this rule. A date and time, in Unix format and Coordinated Universal Time (UTC). The value of `LastExecutionDate` is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         */
        var lastExecutionDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Unique, randomly generated, Unicode, UTF-8 encoded strings that are at most 1,024 bytes long. Version IDs cannot be edited.
         */
        var versionId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.backup.model.BackupPlansListMember) : this() {
            this.advancedBackupSettings = x.advancedBackupSettings
            this.backupPlanArn = x.backupPlanArn
            this.backupPlanId = x.backupPlanId
            this.backupPlanName = x.backupPlanName
            this.creationDate = x.creationDate
            this.creatorRequestId = x.creatorRequestId
            this.deletionDate = x.deletionDate
            this.lastExecutionDate = x.lastExecutionDate
            this.versionId = x.versionId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.backup.model.BackupPlansListMember = BackupPlansListMember(this)
    }
}
