// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains `DeleteAt` and `MoveToColdStorageAt` timestamps, which are used to specify a lifecycle for a recovery point.
 *
 * The lifecycle defines when a protected resource is transitioned to cold storage and when it expires. Backup transitions and expires backups automatically according to the lifecycle that you define.
 *
 * Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days. Therefore, the “retention” setting must be 90 days greater than the “transition to cold after days” setting. The “transition to cold after days” setting cannot be changed after a backup has been transitioned to cold.
 *
 * Only resource types that support full Backup management can transition their backups to cold storage. Those resource types are listed in the "Full Backup management" section of the [ Feature availability by resource](https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html#features-by-resource) table. Backup ignores this expression for other resource types.
 */
class CalculatedLifecycle private constructor(builder: Builder) {
    /**
     * A timestamp that specifies when to delete a recovery point.
     */
    val deleteAt: aws.smithy.kotlin.runtime.time.Instant? = builder.deleteAt
    /**
     * A timestamp that specifies when to transition a recovery point to cold storage.
     */
    val moveToColdStorageAt: aws.smithy.kotlin.runtime.time.Instant? = builder.moveToColdStorageAt

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.backup.model.CalculatedLifecycle = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CalculatedLifecycle(")
        append("deleteAt=$deleteAt,")
        append("moveToColdStorageAt=$moveToColdStorageAt)")
    }

    override fun hashCode(): kotlin.Int {
        var result = deleteAt?.hashCode() ?: 0
        result = 31 * result + (moveToColdStorageAt?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CalculatedLifecycle

        if (deleteAt != other.deleteAt) return false
        if (moveToColdStorageAt != other.moveToColdStorageAt) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.backup.model.CalculatedLifecycle = Builder(this).apply(block).build()

    class Builder {
        /**
         * A timestamp that specifies when to delete a recovery point.
         */
        var deleteAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A timestamp that specifies when to transition a recovery point to cold storage.
         */
        var moveToColdStorageAt: aws.smithy.kotlin.runtime.time.Instant? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.backup.model.CalculatedLifecycle) : this() {
            this.deleteAt = x.deleteAt
            this.moveToColdStorageAt = x.moveToColdStorageAt
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.backup.model.CalculatedLifecycle = CalculatedLifecycle(this)
    }
}
