// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.model

import aws.smithy.kotlin.runtime.time.Instant

class ListBackupJobsRequest private constructor(builder: Builder) {
    /**
     * The account ID to list the jobs from. Returns only backup jobs associated with the specified account ID.
     *
     * If used from an Organizations management account, passing `*` returns all jobs across the organization.
     */
    val byAccountId: kotlin.String? = builder.byAccountId
    /**
     * Returns only backup jobs that will be stored in the specified backup vault. Backup vaults are identified by names that are unique to the account used to create them and the Amazon Web Services Region where they are created. They consist of lowercase letters, numbers, and hyphens.
     */
    val byBackupVaultName: kotlin.String? = builder.byBackupVaultName
    /**
     * Returns only backup jobs completed after a date expressed in Unix format and Coordinated Universal Time (UTC).
     */
    val byCompleteAfter: aws.smithy.kotlin.runtime.time.Instant? = builder.byCompleteAfter
    /**
     * Returns only backup jobs completed before a date expressed in Unix format and Coordinated Universal Time (UTC).
     */
    val byCompleteBefore: aws.smithy.kotlin.runtime.time.Instant? = builder.byCompleteBefore
    /**
     * Returns only backup jobs that were created after the specified date.
     */
    val byCreatedAfter: aws.smithy.kotlin.runtime.time.Instant? = builder.byCreatedAfter
    /**
     * Returns only backup jobs that were created before the specified date.
     */
    val byCreatedBefore: aws.smithy.kotlin.runtime.time.Instant? = builder.byCreatedBefore
    /**
     * Returns only backup jobs that match the specified resource Amazon Resource Name (ARN).
     */
    val byResourceArn: kotlin.String? = builder.byResourceArn
    /**
     * Returns only backup jobs for the specified resources:
     * + `Aurora` for Amazon Aurora
     * + `DocumentDB` for Amazon DocumentDB (with MongoDB compatibility)
     * + `DynamoDB` for Amazon DynamoDB
     * + `EBS` for Amazon Elastic Block Store
     * + `EC2` for Amazon Elastic Compute Cloud
     * + `EFS` for Amazon Elastic File System
     * + `FSx` for Amazon FSx
     * + `Neptune` for Amazon Neptune
     * + `RDS` for Amazon Relational Database Service
     * + `Storage Gateway` for Storage Gateway
     * + `S3` for Amazon S3
     * + `VirtualMachine` for virtual machines
     */
    val byResourceType: kotlin.String? = builder.byResourceType
    /**
     * Returns only backup jobs that are in the specified state.
     */
    val byState: aws.sdk.kotlin.services.backup.model.BackupJobState? = builder.byState
    /**
     * The maximum number of items to be returned.
     */
    val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The next item following a partial list of returned items. For example, if a request is made to return `maxResults` number of items, `NextToken` allows you to return more items in your list starting at the location pointed to by the next token.
     */
    val nextToken: kotlin.String? = builder.nextToken

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.backup.model.ListBackupJobsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListBackupJobsRequest(")
        append("byAccountId=$byAccountId,")
        append("byBackupVaultName=$byBackupVaultName,")
        append("byCompleteAfter=$byCompleteAfter,")
        append("byCompleteBefore=$byCompleteBefore,")
        append("byCreatedAfter=$byCreatedAfter,")
        append("byCreatedBefore=$byCreatedBefore,")
        append("byResourceArn=$byResourceArn,")
        append("byResourceType=$byResourceType,")
        append("byState=$byState,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken)")
    }

    override fun hashCode(): kotlin.Int {
        var result = byAccountId?.hashCode() ?: 0
        result = 31 * result + (byBackupVaultName?.hashCode() ?: 0)
        result = 31 * result + (byCompleteAfter?.hashCode() ?: 0)
        result = 31 * result + (byCompleteBefore?.hashCode() ?: 0)
        result = 31 * result + (byCreatedAfter?.hashCode() ?: 0)
        result = 31 * result + (byCreatedBefore?.hashCode() ?: 0)
        result = 31 * result + (byResourceArn?.hashCode() ?: 0)
        result = 31 * result + (byResourceType?.hashCode() ?: 0)
        result = 31 * result + (byState?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListBackupJobsRequest

        if (byAccountId != other.byAccountId) return false
        if (byBackupVaultName != other.byBackupVaultName) return false
        if (byCompleteAfter != other.byCompleteAfter) return false
        if (byCompleteBefore != other.byCompleteBefore) return false
        if (byCreatedAfter != other.byCreatedAfter) return false
        if (byCreatedBefore != other.byCreatedBefore) return false
        if (byResourceArn != other.byResourceArn) return false
        if (byResourceType != other.byResourceType) return false
        if (byState != other.byState) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.backup.model.ListBackupJobsRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The account ID to list the jobs from. Returns only backup jobs associated with the specified account ID.
         *
         * If used from an Organizations management account, passing `*` returns all jobs across the organization.
         */
        var byAccountId: kotlin.String? = null
        /**
         * Returns only backup jobs that will be stored in the specified backup vault. Backup vaults are identified by names that are unique to the account used to create them and the Amazon Web Services Region where they are created. They consist of lowercase letters, numbers, and hyphens.
         */
        var byBackupVaultName: kotlin.String? = null
        /**
         * Returns only backup jobs completed after a date expressed in Unix format and Coordinated Universal Time (UTC).
         */
        var byCompleteAfter: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Returns only backup jobs completed before a date expressed in Unix format and Coordinated Universal Time (UTC).
         */
        var byCompleteBefore: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Returns only backup jobs that were created after the specified date.
         */
        var byCreatedAfter: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Returns only backup jobs that were created before the specified date.
         */
        var byCreatedBefore: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Returns only backup jobs that match the specified resource Amazon Resource Name (ARN).
         */
        var byResourceArn: kotlin.String? = null
        /**
         * Returns only backup jobs for the specified resources:
         * + `Aurora` for Amazon Aurora
         * + `DocumentDB` for Amazon DocumentDB (with MongoDB compatibility)
         * + `DynamoDB` for Amazon DynamoDB
         * + `EBS` for Amazon Elastic Block Store
         * + `EC2` for Amazon Elastic Compute Cloud
         * + `EFS` for Amazon Elastic File System
         * + `FSx` for Amazon FSx
         * + `Neptune` for Amazon Neptune
         * + `RDS` for Amazon Relational Database Service
         * + `Storage Gateway` for Storage Gateway
         * + `S3` for Amazon S3
         * + `VirtualMachine` for virtual machines
         */
        var byResourceType: kotlin.String? = null
        /**
         * Returns only backup jobs that are in the specified state.
         */
        var byState: aws.sdk.kotlin.services.backup.model.BackupJobState? = null
        /**
         * The maximum number of items to be returned.
         */
        var maxResults: kotlin.Int? = null
        /**
         * The next item following a partial list of returned items. For example, if a request is made to return `maxResults` number of items, `NextToken` allows you to return more items in your list starting at the location pointed to by the next token.
         */
        var nextToken: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.backup.model.ListBackupJobsRequest) : this() {
            this.byAccountId = x.byAccountId
            this.byBackupVaultName = x.byBackupVaultName
            this.byCompleteAfter = x.byCompleteAfter
            this.byCompleteBefore = x.byCompleteBefore
            this.byCreatedAfter = x.byCreatedAfter
            this.byCreatedBefore = x.byCreatedBefore
            this.byResourceArn = x.byResourceArn
            this.byResourceType = x.byResourceType
            this.byState = x.byState
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.backup.model.ListBackupJobsRequest = ListBackupJobsRequest(this)
    }
}
