// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.backup.model.BackupException
import aws.sdk.kotlin.services.backup.model.BackupJobState
import aws.sdk.kotlin.services.backup.model.DescribeBackupJobResponse
import aws.sdk.kotlin.services.backup.model.RecoveryPointCreator
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class DescribeBackupJobOperationDeserializer: HttpDeserialize<DescribeBackupJobResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeBackupJobResponse {
        if (!response.status.isSuccess()) {
            throwDescribeBackupJobError(context, response)
        }
        val builder = DescribeBackupJobResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeBackupJobOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeBackupJobError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw BackupException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DependencyFailureException" -> DependencyFailureExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidParameterValueException" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedResponse)
        "MissingParameterValueException" -> MissingParameterValueExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> BackupException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeBackupJobOperationBody(builder: DescribeBackupJobResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ACCOUNTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AccountId"))
    val BACKUPJOBID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("BackupJobId"))
    val BACKUPOPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("BackupOptions"))
    val BACKUPSIZEINBYTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("BackupSizeInBytes"))
    val BACKUPTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("BackupType"))
    val BACKUPVAULTARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("BackupVaultArn"))
    val BACKUPVAULTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("BackupVaultName"))
    val BYTESTRANSFERRED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("BytesTransferred"))
    val COMPLETIONDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CompletionDate"))
    val CREATEDBY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("CreatedBy"))
    val CREATIONDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationDate"))
    val EXPECTEDCOMPLETIONDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("ExpectedCompletionDate"))
    val IAMROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("IamRoleArn"))
    val PERCENTDONE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PercentDone"))
    val RECOVERYPOINTARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RecoveryPointArn"))
    val RESOURCEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ResourceArn"))
    val RESOURCETYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ResourceType"))
    val STARTBY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("StartBy"))
    val STATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("State"))
    val STATUSMESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("StatusMessage"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACCOUNTID_DESCRIPTOR)
        field(BACKUPJOBID_DESCRIPTOR)
        field(BACKUPOPTIONS_DESCRIPTOR)
        field(BACKUPSIZEINBYTES_DESCRIPTOR)
        field(BACKUPTYPE_DESCRIPTOR)
        field(BACKUPVAULTARN_DESCRIPTOR)
        field(BACKUPVAULTNAME_DESCRIPTOR)
        field(BYTESTRANSFERRED_DESCRIPTOR)
        field(COMPLETIONDATE_DESCRIPTOR)
        field(CREATEDBY_DESCRIPTOR)
        field(CREATIONDATE_DESCRIPTOR)
        field(EXPECTEDCOMPLETIONDATE_DESCRIPTOR)
        field(IAMROLEARN_DESCRIPTOR)
        field(PERCENTDONE_DESCRIPTOR)
        field(RECOVERYPOINTARN_DESCRIPTOR)
        field(RESOURCEARN_DESCRIPTOR)
        field(RESOURCETYPE_DESCRIPTOR)
        field(STARTBY_DESCRIPTOR)
        field(STATE_DESCRIPTOR)
        field(STATUSMESSAGE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ACCOUNTID_DESCRIPTOR.index -> builder.accountId = deserializeString()
                BACKUPJOBID_DESCRIPTOR.index -> builder.backupJobId = deserializeString()
                BACKUPOPTIONS_DESCRIPTOR.index -> builder.backupOptions =
                    deserializer.deserializeMap(BACKUPOPTIONS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                BACKUPSIZEINBYTES_DESCRIPTOR.index -> builder.backupSizeInBytes = deserializeLong()
                BACKUPTYPE_DESCRIPTOR.index -> builder.backupType = deserializeString()
                BACKUPVAULTARN_DESCRIPTOR.index -> builder.backupVaultArn = deserializeString()
                BACKUPVAULTNAME_DESCRIPTOR.index -> builder.backupVaultName = deserializeString()
                BYTESTRANSFERRED_DESCRIPTOR.index -> builder.bytesTransferred = deserializeLong()
                COMPLETIONDATE_DESCRIPTOR.index -> builder.completionDate = deserializeString().let { Instant.fromEpochSeconds(it) }
                CREATEDBY_DESCRIPTOR.index -> builder.createdBy = deserializeRecoveryPointCreatorDocument(deserializer)
                CREATIONDATE_DESCRIPTOR.index -> builder.creationDate = deserializeString().let { Instant.fromEpochSeconds(it) }
                EXPECTEDCOMPLETIONDATE_DESCRIPTOR.index -> builder.expectedCompletionDate = deserializeString().let { Instant.fromEpochSeconds(it) }
                IAMROLEARN_DESCRIPTOR.index -> builder.iamRoleArn = deserializeString()
                PERCENTDONE_DESCRIPTOR.index -> builder.percentDone = deserializeString()
                RECOVERYPOINTARN_DESCRIPTOR.index -> builder.recoveryPointArn = deserializeString()
                RESOURCEARN_DESCRIPTOR.index -> builder.resourceArn = deserializeString()
                RESOURCETYPE_DESCRIPTOR.index -> builder.resourceType = deserializeString()
                STARTBY_DESCRIPTOR.index -> builder.startBy = deserializeString().let { Instant.fromEpochSeconds(it) }
                STATE_DESCRIPTOR.index -> builder.state = deserializeString().let { BackupJobState.fromValue(it) }
                STATUSMESSAGE_DESCRIPTOR.index -> builder.statusMessage = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
