// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.backup.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.backup.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.config.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * # Backup
 * Backup is a unified backup service designed to protect Amazon Web Services services and their associated data. Backup simplifies the creation, migration, restoration, and deletion of backups, while also providing reporting and auditing.
 */
interface BackupClient : SdkClient {

    override val serviceName: String
        get() = "Backup"
    /**
     * BackupClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.Builder.() -> Unit): BackupClient {
            val config = Config.Builder().apply(block).build()
            return DefaultBackupClient(config)
        }

        operator fun invoke(config: Config): BackupClient = DefaultBackupClient(config)

        /**
         * Construct a [BackupClient] by resolving the configuration from the current environment.
         */
        suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): BackupClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultBackupClient(builder.build())
        }
    }

    class Config private constructor(builder: Builder): HttpClientConfig, IdempotencyTokenConfig, SdkClientConfig {
        val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val idempotencyTokenProvider: IdempotencyTokenProvider? = builder.idempotencyTokenProvider
        val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            var idempotencyTokenProvider: IdempotencyTokenProvider? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Creates a backup plan using a backup plan name and backup rules. A backup plan is a document that contains information that Backup uses to schedule tasks that create recovery points for resources.
     *
     * If you call `CreateBackupPlan` with a plan that already exists, you receive an `AlreadyExistsException` exception.
     */
    suspend fun createBackupPlan(input: CreateBackupPlanRequest): CreateBackupPlanResponse

    /**
     * Creates a backup plan using a backup plan name and backup rules. A backup plan is a document that contains information that Backup uses to schedule tasks that create recovery points for resources.
     *
     * If you call `CreateBackupPlan` with a plan that already exists, you receive an `AlreadyExistsException` exception.
     */
    suspend fun createBackupPlan(block: CreateBackupPlanRequest.Builder.() -> Unit) = createBackupPlan(CreateBackupPlanRequest.Builder().apply(block).build())

    /**
     * Creates a JSON document that specifies a set of resources to assign to a backup plan. For examples, see [Assigning resources programmatically](https://docs.aws.amazon.com/aws-backup/latest/devguide/assigning-resources.html#assigning-resources-json).
     */
    suspend fun createBackupSelection(input: CreateBackupSelectionRequest): CreateBackupSelectionResponse

    /**
     * Creates a JSON document that specifies a set of resources to assign to a backup plan. For examples, see [Assigning resources programmatically](https://docs.aws.amazon.com/aws-backup/latest/devguide/assigning-resources.html#assigning-resources-json).
     */
    suspend fun createBackupSelection(block: CreateBackupSelectionRequest.Builder.() -> Unit) = createBackupSelection(CreateBackupSelectionRequest.Builder().apply(block).build())

    /**
     * Creates a logical container where backups are stored. A `CreateBackupVault` request includes a name, optionally one or more resource tags, an encryption key, and a request ID.
     *
     * Do not include sensitive data, such as passport numbers, in the name of a backup vault.
     */
    suspend fun createBackupVault(input: CreateBackupVaultRequest): CreateBackupVaultResponse

    /**
     * Creates a logical container where backups are stored. A `CreateBackupVault` request includes a name, optionally one or more resource tags, an encryption key, and a request ID.
     *
     * Do not include sensitive data, such as passport numbers, in the name of a backup vault.
     */
    suspend fun createBackupVault(block: CreateBackupVaultRequest.Builder.() -> Unit) = createBackupVault(CreateBackupVaultRequest.Builder().apply(block).build())

    /**
     * Creates a framework with one or more controls. A framework is a collection of controls that you can use to evaluate your backup practices. By using pre-built customizable controls to define your policies, you can evaluate whether your backup practices comply with your policies and which resources are not yet in compliance.
     */
    suspend fun createFramework(input: CreateFrameworkRequest): CreateFrameworkResponse

    /**
     * Creates a framework with one or more controls. A framework is a collection of controls that you can use to evaluate your backup practices. By using pre-built customizable controls to define your policies, you can evaluate whether your backup practices comply with your policies and which resources are not yet in compliance.
     */
    suspend fun createFramework(block: CreateFrameworkRequest.Builder.() -> Unit) = createFramework(CreateFrameworkRequest.Builder().apply(block).build())

    /**
     * Creates a report plan. A report plan is a document that contains information about the contents of the report and where Backup will deliver it.
     *
     * If you call `CreateReportPlan` with a plan that already exists, you receive an `AlreadyExistsException` exception.
     */
    suspend fun createReportPlan(input: CreateReportPlanRequest): CreateReportPlanResponse

    /**
     * Creates a report plan. A report plan is a document that contains information about the contents of the report and where Backup will deliver it.
     *
     * If you call `CreateReportPlan` with a plan that already exists, you receive an `AlreadyExistsException` exception.
     */
    suspend fun createReportPlan(block: CreateReportPlanRequest.Builder.() -> Unit) = createReportPlan(CreateReportPlanRequest.Builder().apply(block).build())

    /**
     * Deletes a backup plan. A backup plan can only be deleted after all associated selections of resources have been deleted. Deleting a backup plan deletes the current version of a backup plan. Previous versions, if any, will still exist.
     */
    suspend fun deleteBackupPlan(input: DeleteBackupPlanRequest): DeleteBackupPlanResponse

    /**
     * Deletes a backup plan. A backup plan can only be deleted after all associated selections of resources have been deleted. Deleting a backup plan deletes the current version of a backup plan. Previous versions, if any, will still exist.
     */
    suspend fun deleteBackupPlan(block: DeleteBackupPlanRequest.Builder.() -> Unit) = deleteBackupPlan(DeleteBackupPlanRequest.Builder().apply(block).build())

    /**
     * Deletes the resource selection associated with a backup plan that is specified by the `SelectionId`.
     */
    suspend fun deleteBackupSelection(input: DeleteBackupSelectionRequest): DeleteBackupSelectionResponse

    /**
     * Deletes the resource selection associated with a backup plan that is specified by the `SelectionId`.
     */
    suspend fun deleteBackupSelection(block: DeleteBackupSelectionRequest.Builder.() -> Unit) = deleteBackupSelection(DeleteBackupSelectionRequest.Builder().apply(block).build())

    /**
     * Deletes the backup vault identified by its name. A vault can be deleted only if it is empty.
     */
    suspend fun deleteBackupVault(input: DeleteBackupVaultRequest): DeleteBackupVaultResponse

    /**
     * Deletes the backup vault identified by its name. A vault can be deleted only if it is empty.
     */
    suspend fun deleteBackupVault(block: DeleteBackupVaultRequest.Builder.() -> Unit) = deleteBackupVault(DeleteBackupVaultRequest.Builder().apply(block).build())

    /**
     * Deletes the policy document that manages permissions on a backup vault.
     */
    suspend fun deleteBackupVaultAccessPolicy(input: DeleteBackupVaultAccessPolicyRequest): DeleteBackupVaultAccessPolicyResponse

    /**
     * Deletes the policy document that manages permissions on a backup vault.
     */
    suspend fun deleteBackupVaultAccessPolicy(block: DeleteBackupVaultAccessPolicyRequest.Builder.() -> Unit) = deleteBackupVaultAccessPolicy(DeleteBackupVaultAccessPolicyRequest.Builder().apply(block).build())

    /**
     * Deletes Backup Vault Lock from a backup vault specified by a backup vault name.
     *
     * If the Vault Lock configuration is immutable, then you cannot delete Vault Lock using API operations, and you will receive an `InvalidRequestException` if you attempt to do so. For more information, see [Vault Lock](https://docs.aws.amazon.com/aws-backup/latest/devguide/vault-lock.html) in the *Backup Developer Guide*.
     */
    suspend fun deleteBackupVaultLockConfiguration(input: DeleteBackupVaultLockConfigurationRequest): DeleteBackupVaultLockConfigurationResponse

    /**
     * Deletes Backup Vault Lock from a backup vault specified by a backup vault name.
     *
     * If the Vault Lock configuration is immutable, then you cannot delete Vault Lock using API operations, and you will receive an `InvalidRequestException` if you attempt to do so. For more information, see [Vault Lock](https://docs.aws.amazon.com/aws-backup/latest/devguide/vault-lock.html) in the *Backup Developer Guide*.
     */
    suspend fun deleteBackupVaultLockConfiguration(block: DeleteBackupVaultLockConfigurationRequest.Builder.() -> Unit) = deleteBackupVaultLockConfiguration(DeleteBackupVaultLockConfigurationRequest.Builder().apply(block).build())

    /**
     * Deletes event notifications for the specified backup vault.
     */
    suspend fun deleteBackupVaultNotifications(input: DeleteBackupVaultNotificationsRequest): DeleteBackupVaultNotificationsResponse

    /**
     * Deletes event notifications for the specified backup vault.
     */
    suspend fun deleteBackupVaultNotifications(block: DeleteBackupVaultNotificationsRequest.Builder.() -> Unit) = deleteBackupVaultNotifications(DeleteBackupVaultNotificationsRequest.Builder().apply(block).build())

    /**
     * Deletes the framework specified by a framework name.
     */
    suspend fun deleteFramework(input: DeleteFrameworkRequest): DeleteFrameworkResponse

    /**
     * Deletes the framework specified by a framework name.
     */
    suspend fun deleteFramework(block: DeleteFrameworkRequest.Builder.() -> Unit) = deleteFramework(DeleteFrameworkRequest.Builder().apply(block).build())

    /**
     * Deletes the recovery point specified by a recovery point ID.
     *
     * If the recovery point ID belongs to a continuous backup, calling this endpoint deletes the existing continuous backup and stops future continuous backup.
     */
    suspend fun deleteRecoveryPoint(input: DeleteRecoveryPointRequest): DeleteRecoveryPointResponse

    /**
     * Deletes the recovery point specified by a recovery point ID.
     *
     * If the recovery point ID belongs to a continuous backup, calling this endpoint deletes the existing continuous backup and stops future continuous backup.
     */
    suspend fun deleteRecoveryPoint(block: DeleteRecoveryPointRequest.Builder.() -> Unit) = deleteRecoveryPoint(DeleteRecoveryPointRequest.Builder().apply(block).build())

    /**
     * Deletes the report plan specified by a report plan name.
     */
    suspend fun deleteReportPlan(input: DeleteReportPlanRequest): DeleteReportPlanResponse

    /**
     * Deletes the report plan specified by a report plan name.
     */
    suspend fun deleteReportPlan(block: DeleteReportPlanRequest.Builder.() -> Unit) = deleteReportPlan(DeleteReportPlanRequest.Builder().apply(block).build())

    /**
     * Returns backup job details for the specified `BackupJobId`.
     */
    suspend fun describeBackupJob(input: DescribeBackupJobRequest): DescribeBackupJobResponse

    /**
     * Returns backup job details for the specified `BackupJobId`.
     */
    suspend fun describeBackupJob(block: DescribeBackupJobRequest.Builder.() -> Unit) = describeBackupJob(DescribeBackupJobRequest.Builder().apply(block).build())

    /**
     * Returns metadata about a backup vault specified by its name.
     */
    suspend fun describeBackupVault(input: DescribeBackupVaultRequest): DescribeBackupVaultResponse

    /**
     * Returns metadata about a backup vault specified by its name.
     */
    suspend fun describeBackupVault(block: DescribeBackupVaultRequest.Builder.() -> Unit) = describeBackupVault(DescribeBackupVaultRequest.Builder().apply(block).build())

    /**
     * Returns metadata associated with creating a copy of a resource.
     */
    suspend fun describeCopyJob(input: DescribeCopyJobRequest): DescribeCopyJobResponse

    /**
     * Returns metadata associated with creating a copy of a resource.
     */
    suspend fun describeCopyJob(block: DescribeCopyJobRequest.Builder.() -> Unit) = describeCopyJob(DescribeCopyJobRequest.Builder().apply(block).build())

    /**
     * Returns the framework details for the specified `FrameworkName`.
     */
    suspend fun describeFramework(input: DescribeFrameworkRequest): DescribeFrameworkResponse

    /**
     * Returns the framework details for the specified `FrameworkName`.
     */
    suspend fun describeFramework(block: DescribeFrameworkRequest.Builder.() -> Unit) = describeFramework(DescribeFrameworkRequest.Builder().apply(block).build())

    /**
     * Describes whether the Amazon Web Services account is opted in to cross-account backup. Returns an error if the account is not a member of an Organizations organization. Example: `describe-global-settings --region us-west-2`
     */
    suspend fun describeGlobalSettings(input: DescribeGlobalSettingsRequest = DescribeGlobalSettingsRequest {}): DescribeGlobalSettingsResponse

    /**
     * Describes whether the Amazon Web Services account is opted in to cross-account backup. Returns an error if the account is not a member of an Organizations organization. Example: `describe-global-settings --region us-west-2`
     */
    suspend fun describeGlobalSettings(block: DescribeGlobalSettingsRequest.Builder.() -> Unit) = describeGlobalSettings(DescribeGlobalSettingsRequest.Builder().apply(block).build())

    /**
     * Returns information about a saved resource, including the last time it was backed up, its Amazon Resource Name (ARN), and the Amazon Web Services service type of the saved resource.
     */
    suspend fun describeProtectedResource(input: DescribeProtectedResourceRequest): DescribeProtectedResourceResponse

    /**
     * Returns information about a saved resource, including the last time it was backed up, its Amazon Resource Name (ARN), and the Amazon Web Services service type of the saved resource.
     */
    suspend fun describeProtectedResource(block: DescribeProtectedResourceRequest.Builder.() -> Unit) = describeProtectedResource(DescribeProtectedResourceRequest.Builder().apply(block).build())

    /**
     * Returns metadata associated with a recovery point, including ID, status, encryption, and lifecycle.
     */
    suspend fun describeRecoveryPoint(input: DescribeRecoveryPointRequest): DescribeRecoveryPointResponse

    /**
     * Returns metadata associated with a recovery point, including ID, status, encryption, and lifecycle.
     */
    suspend fun describeRecoveryPoint(block: DescribeRecoveryPointRequest.Builder.() -> Unit) = describeRecoveryPoint(DescribeRecoveryPointRequest.Builder().apply(block).build())

    /**
     * Returns the current service opt-in settings for the Region. If service opt-in is enabled for a service, Backup tries to protect that service's resources in this Region, when the resource is included in an on-demand backup or scheduled backup plan. Otherwise, Backup does not try to protect that service's resources in this Region.
     */
    suspend fun describeRegionSettings(input: DescribeRegionSettingsRequest = DescribeRegionSettingsRequest {}): DescribeRegionSettingsResponse

    /**
     * Returns the current service opt-in settings for the Region. If service opt-in is enabled for a service, Backup tries to protect that service's resources in this Region, when the resource is included in an on-demand backup or scheduled backup plan. Otherwise, Backup does not try to protect that service's resources in this Region.
     */
    suspend fun describeRegionSettings(block: DescribeRegionSettingsRequest.Builder.() -> Unit) = describeRegionSettings(DescribeRegionSettingsRequest.Builder().apply(block).build())

    /**
     * Returns the details associated with creating a report as specified by its `ReportJobId`.
     */
    suspend fun describeReportJob(input: DescribeReportJobRequest): DescribeReportJobResponse

    /**
     * Returns the details associated with creating a report as specified by its `ReportJobId`.
     */
    suspend fun describeReportJob(block: DescribeReportJobRequest.Builder.() -> Unit) = describeReportJob(DescribeReportJobRequest.Builder().apply(block).build())

    /**
     * Returns a list of all report plans for an Amazon Web Services account and Amazon Web Services Region.
     */
    suspend fun describeReportPlan(input: DescribeReportPlanRequest): DescribeReportPlanResponse

    /**
     * Returns a list of all report plans for an Amazon Web Services account and Amazon Web Services Region.
     */
    suspend fun describeReportPlan(block: DescribeReportPlanRequest.Builder.() -> Unit) = describeReportPlan(DescribeReportPlanRequest.Builder().apply(block).build())

    /**
     * Returns metadata associated with a restore job that is specified by a job ID.
     */
    suspend fun describeRestoreJob(input: DescribeRestoreJobRequest): DescribeRestoreJobResponse

    /**
     * Returns metadata associated with a restore job that is specified by a job ID.
     */
    suspend fun describeRestoreJob(block: DescribeRestoreJobRequest.Builder.() -> Unit) = describeRestoreJob(DescribeRestoreJobRequest.Builder().apply(block).build())

    /**
     * Deletes the specified continuous backup recovery point from Backup and releases control of that continuous backup to the source service, such as Amazon RDS. The source service will continue to create and retain continuous backups using the lifecycle that you specified in your original backup plan.
     *
     * Does not support snapshot backup recovery points.
     */
    suspend fun disassociateRecoveryPoint(input: DisassociateRecoveryPointRequest): DisassociateRecoveryPointResponse

    /**
     * Deletes the specified continuous backup recovery point from Backup and releases control of that continuous backup to the source service, such as Amazon RDS. The source service will continue to create and retain continuous backups using the lifecycle that you specified in your original backup plan.
     *
     * Does not support snapshot backup recovery points.
     */
    suspend fun disassociateRecoveryPoint(block: DisassociateRecoveryPointRequest.Builder.() -> Unit) = disassociateRecoveryPoint(DisassociateRecoveryPointRequest.Builder().apply(block).build())

    /**
     * Returns the backup plan that is specified by the plan ID as a backup template.
     */
    suspend fun exportBackupPlanTemplate(input: ExportBackupPlanTemplateRequest): ExportBackupPlanTemplateResponse

    /**
     * Returns the backup plan that is specified by the plan ID as a backup template.
     */
    suspend fun exportBackupPlanTemplate(block: ExportBackupPlanTemplateRequest.Builder.() -> Unit) = exportBackupPlanTemplate(ExportBackupPlanTemplateRequest.Builder().apply(block).build())

    /**
     * Returns `BackupPlan` details for the specified `BackupPlanId`. The details are the body of a backup plan in JSON format, in addition to plan metadata.
     */
    suspend fun getBackupPlan(input: GetBackupPlanRequest): GetBackupPlanResponse

    /**
     * Returns `BackupPlan` details for the specified `BackupPlanId`. The details are the body of a backup plan in JSON format, in addition to plan metadata.
     */
    suspend fun getBackupPlan(block: GetBackupPlanRequest.Builder.() -> Unit) = getBackupPlan(GetBackupPlanRequest.Builder().apply(block).build())

    /**
     * Returns a valid JSON document specifying a backup plan or an error.
     */
    suspend fun getBackupPlanFromJson(input: GetBackupPlanFromJsonRequest): GetBackupPlanFromJsonResponse

    /**
     * Returns a valid JSON document specifying a backup plan or an error.
     */
    suspend fun getBackupPlanFromJson(block: GetBackupPlanFromJsonRequest.Builder.() -> Unit) = getBackupPlanFromJson(GetBackupPlanFromJsonRequest.Builder().apply(block).build())

    /**
     * Returns the template specified by its `templateId` as a backup plan.
     */
    suspend fun getBackupPlanFromTemplate(input: GetBackupPlanFromTemplateRequest): GetBackupPlanFromTemplateResponse

    /**
     * Returns the template specified by its `templateId` as a backup plan.
     */
    suspend fun getBackupPlanFromTemplate(block: GetBackupPlanFromTemplateRequest.Builder.() -> Unit) = getBackupPlanFromTemplate(GetBackupPlanFromTemplateRequest.Builder().apply(block).build())

    /**
     * Returns selection metadata and a document in JSON format that specifies a list of resources that are associated with a backup plan.
     */
    suspend fun getBackupSelection(input: GetBackupSelectionRequest): GetBackupSelectionResponse

    /**
     * Returns selection metadata and a document in JSON format that specifies a list of resources that are associated with a backup plan.
     */
    suspend fun getBackupSelection(block: GetBackupSelectionRequest.Builder.() -> Unit) = getBackupSelection(GetBackupSelectionRequest.Builder().apply(block).build())

    /**
     * Returns the access policy document that is associated with the named backup vault.
     */
    suspend fun getBackupVaultAccessPolicy(input: GetBackupVaultAccessPolicyRequest): GetBackupVaultAccessPolicyResponse

    /**
     * Returns the access policy document that is associated with the named backup vault.
     */
    suspend fun getBackupVaultAccessPolicy(block: GetBackupVaultAccessPolicyRequest.Builder.() -> Unit) = getBackupVaultAccessPolicy(GetBackupVaultAccessPolicyRequest.Builder().apply(block).build())

    /**
     * Returns event notifications for the specified backup vault.
     */
    suspend fun getBackupVaultNotifications(input: GetBackupVaultNotificationsRequest): GetBackupVaultNotificationsResponse

    /**
     * Returns event notifications for the specified backup vault.
     */
    suspend fun getBackupVaultNotifications(block: GetBackupVaultNotificationsRequest.Builder.() -> Unit) = getBackupVaultNotifications(GetBackupVaultNotificationsRequest.Builder().apply(block).build())

    /**
     * Returns a set of metadata key-value pairs that were used to create the backup.
     */
    suspend fun getRecoveryPointRestoreMetadata(input: GetRecoveryPointRestoreMetadataRequest): GetRecoveryPointRestoreMetadataResponse

    /**
     * Returns a set of metadata key-value pairs that were used to create the backup.
     */
    suspend fun getRecoveryPointRestoreMetadata(block: GetRecoveryPointRestoreMetadataRequest.Builder.() -> Unit) = getRecoveryPointRestoreMetadata(GetRecoveryPointRestoreMetadataRequest.Builder().apply(block).build())

    /**
     * Returns the Amazon Web Services resource types supported by Backup.
     */
    suspend fun getSupportedResourceTypes(input: GetSupportedResourceTypesRequest = GetSupportedResourceTypesRequest {}): GetSupportedResourceTypesResponse

    /**
     * Returns the Amazon Web Services resource types supported by Backup.
     */
    suspend fun getSupportedResourceTypes(block: GetSupportedResourceTypesRequest.Builder.() -> Unit) = getSupportedResourceTypes(GetSupportedResourceTypesRequest.Builder().apply(block).build())

    /**
     * Returns a list of existing backup jobs for an authenticated account for the last 30 days. For a longer period of time, consider using these [monitoring tools](https://docs.aws.amazon.com/aws-backup/latest/devguide/monitoring.html).
     */
    suspend fun listBackupJobs(input: ListBackupJobsRequest = ListBackupJobsRequest {}): ListBackupJobsResponse

    /**
     * Returns a list of existing backup jobs for an authenticated account for the last 30 days. For a longer period of time, consider using these [monitoring tools](https://docs.aws.amazon.com/aws-backup/latest/devguide/monitoring.html).
     */
    suspend fun listBackupJobs(block: ListBackupJobsRequest.Builder.() -> Unit) = listBackupJobs(ListBackupJobsRequest.Builder().apply(block).build())

    /**
     * Returns metadata of your saved backup plan templates, including the template ID, name, and the creation and deletion dates.
     */
    suspend fun listBackupPlanTemplates(input: ListBackupPlanTemplatesRequest = ListBackupPlanTemplatesRequest {}): ListBackupPlanTemplatesResponse

    /**
     * Returns metadata of your saved backup plan templates, including the template ID, name, and the creation and deletion dates.
     */
    suspend fun listBackupPlanTemplates(block: ListBackupPlanTemplatesRequest.Builder.() -> Unit) = listBackupPlanTemplates(ListBackupPlanTemplatesRequest.Builder().apply(block).build())

    /**
     * Returns version metadata of your backup plans, including Amazon Resource Names (ARNs), backup plan IDs, creation and deletion dates, plan names, and version IDs.
     */
    suspend fun listBackupPlanVersions(input: ListBackupPlanVersionsRequest): ListBackupPlanVersionsResponse

    /**
     * Returns version metadata of your backup plans, including Amazon Resource Names (ARNs), backup plan IDs, creation and deletion dates, plan names, and version IDs.
     */
    suspend fun listBackupPlanVersions(block: ListBackupPlanVersionsRequest.Builder.() -> Unit) = listBackupPlanVersions(ListBackupPlanVersionsRequest.Builder().apply(block).build())

    /**
     * Returns a list of all active backup plans for an authenticated account. The list contains information such as Amazon Resource Names (ARNs), plan IDs, creation and deletion dates, version IDs, plan names, and creator request IDs.
     */
    suspend fun listBackupPlans(input: ListBackupPlansRequest = ListBackupPlansRequest {}): ListBackupPlansResponse

    /**
     * Returns a list of all active backup plans for an authenticated account. The list contains information such as Amazon Resource Names (ARNs), plan IDs, creation and deletion dates, version IDs, plan names, and creator request IDs.
     */
    suspend fun listBackupPlans(block: ListBackupPlansRequest.Builder.() -> Unit) = listBackupPlans(ListBackupPlansRequest.Builder().apply(block).build())

    /**
     * Returns an array containing metadata of the resources associated with the target backup plan.
     */
    suspend fun listBackupSelections(input: ListBackupSelectionsRequest): ListBackupSelectionsResponse

    /**
     * Returns an array containing metadata of the resources associated with the target backup plan.
     */
    suspend fun listBackupSelections(block: ListBackupSelectionsRequest.Builder.() -> Unit) = listBackupSelections(ListBackupSelectionsRequest.Builder().apply(block).build())

    /**
     * Returns a list of recovery point storage containers along with information about them.
     */
    suspend fun listBackupVaults(input: ListBackupVaultsRequest = ListBackupVaultsRequest {}): ListBackupVaultsResponse

    /**
     * Returns a list of recovery point storage containers along with information about them.
     */
    suspend fun listBackupVaults(block: ListBackupVaultsRequest.Builder.() -> Unit) = listBackupVaults(ListBackupVaultsRequest.Builder().apply(block).build())

    /**
     * Returns metadata about your copy jobs.
     */
    suspend fun listCopyJobs(input: ListCopyJobsRequest = ListCopyJobsRequest {}): ListCopyJobsResponse

    /**
     * Returns metadata about your copy jobs.
     */
    suspend fun listCopyJobs(block: ListCopyJobsRequest.Builder.() -> Unit) = listCopyJobs(ListCopyJobsRequest.Builder().apply(block).build())

    /**
     * Returns a list of all frameworks for an Amazon Web Services account and Amazon Web Services Region.
     */
    suspend fun listFrameworks(input: ListFrameworksRequest = ListFrameworksRequest {}): ListFrameworksResponse

    /**
     * Returns a list of all frameworks for an Amazon Web Services account and Amazon Web Services Region.
     */
    suspend fun listFrameworks(block: ListFrameworksRequest.Builder.() -> Unit) = listFrameworks(ListFrameworksRequest.Builder().apply(block).build())

    /**
     * Returns an array of resources successfully backed up by Backup, including the time the resource was saved, an Amazon Resource Name (ARN) of the resource, and a resource type.
     */
    suspend fun listProtectedResources(input: ListProtectedResourcesRequest = ListProtectedResourcesRequest {}): ListProtectedResourcesResponse

    /**
     * Returns an array of resources successfully backed up by Backup, including the time the resource was saved, an Amazon Resource Name (ARN) of the resource, and a resource type.
     */
    suspend fun listProtectedResources(block: ListProtectedResourcesRequest.Builder.() -> Unit) = listProtectedResources(ListProtectedResourcesRequest.Builder().apply(block).build())

    /**
     * Returns detailed information about the recovery points stored in a backup vault.
     */
    suspend fun listRecoveryPointsByBackupVault(input: ListRecoveryPointsByBackupVaultRequest): ListRecoveryPointsByBackupVaultResponse

    /**
     * Returns detailed information about the recovery points stored in a backup vault.
     */
    suspend fun listRecoveryPointsByBackupVault(block: ListRecoveryPointsByBackupVaultRequest.Builder.() -> Unit) = listRecoveryPointsByBackupVault(ListRecoveryPointsByBackupVaultRequest.Builder().apply(block).build())

    /**
     * Returns detailed information about all the recovery points of the type specified by a resource Amazon Resource Name (ARN).
     *
     * For Amazon EFS and Amazon EC2, this action only lists recovery points created by Backup.
     */
    suspend fun listRecoveryPointsByResource(input: ListRecoveryPointsByResourceRequest): ListRecoveryPointsByResourceResponse

    /**
     * Returns detailed information about all the recovery points of the type specified by a resource Amazon Resource Name (ARN).
     *
     * For Amazon EFS and Amazon EC2, this action only lists recovery points created by Backup.
     */
    suspend fun listRecoveryPointsByResource(block: ListRecoveryPointsByResourceRequest.Builder.() -> Unit) = listRecoveryPointsByResource(ListRecoveryPointsByResourceRequest.Builder().apply(block).build())

    /**
     * Returns details about your report jobs.
     */
    suspend fun listReportJobs(input: ListReportJobsRequest = ListReportJobsRequest {}): ListReportJobsResponse

    /**
     * Returns details about your report jobs.
     */
    suspend fun listReportJobs(block: ListReportJobsRequest.Builder.() -> Unit) = listReportJobs(ListReportJobsRequest.Builder().apply(block).build())

    /**
     * Returns a list of your report plans. For detailed information about a single report plan, use `DescribeReportPlan`.
     */
    suspend fun listReportPlans(input: ListReportPlansRequest = ListReportPlansRequest {}): ListReportPlansResponse

    /**
     * Returns a list of your report plans. For detailed information about a single report plan, use `DescribeReportPlan`.
     */
    suspend fun listReportPlans(block: ListReportPlansRequest.Builder.() -> Unit) = listReportPlans(ListReportPlansRequest.Builder().apply(block).build())

    /**
     * Returns a list of jobs that Backup initiated to restore a saved resource, including details about the recovery process.
     */
    suspend fun listRestoreJobs(input: ListRestoreJobsRequest = ListRestoreJobsRequest {}): ListRestoreJobsResponse

    /**
     * Returns a list of jobs that Backup initiated to restore a saved resource, including details about the recovery process.
     */
    suspend fun listRestoreJobs(block: ListRestoreJobsRequest.Builder.() -> Unit) = listRestoreJobs(ListRestoreJobsRequest.Builder().apply(block).build())

    /**
     * Returns a list of key-value pairs assigned to a target recovery point, backup plan, or backup vault.
     *
     * `ListTags` only works for resource types that support full Backup management of their backups. Those resource types are listed in the "Full Backup management" section of the [ Feature availability by resource](https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html#features-by-resource) table.
     */
    suspend fun listTags(input: ListTagsRequest): ListTagsResponse

    /**
     * Returns a list of key-value pairs assigned to a target recovery point, backup plan, or backup vault.
     *
     * `ListTags` only works for resource types that support full Backup management of their backups. Those resource types are listed in the "Full Backup management" section of the [ Feature availability by resource](https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html#features-by-resource) table.
     */
    suspend fun listTags(block: ListTagsRequest.Builder.() -> Unit) = listTags(ListTagsRequest.Builder().apply(block).build())

    /**
     * Sets a resource-based policy that is used to manage access permissions on the target backup vault. Requires a backup vault name and an access policy document in JSON format.
     */
    suspend fun putBackupVaultAccessPolicy(input: PutBackupVaultAccessPolicyRequest): PutBackupVaultAccessPolicyResponse

    /**
     * Sets a resource-based policy that is used to manage access permissions on the target backup vault. Requires a backup vault name and an access policy document in JSON format.
     */
    suspend fun putBackupVaultAccessPolicy(block: PutBackupVaultAccessPolicyRequest.Builder.() -> Unit) = putBackupVaultAccessPolicy(PutBackupVaultAccessPolicyRequest.Builder().apply(block).build())

    /**
     * Applies Backup Vault Lock to a backup vault, preventing attempts to delete any recovery point stored in or created in a backup vault. Vault Lock also prevents attempts to update the lifecycle policy that controls the retention period of any recovery point currently stored in a backup vault. If specified, Vault Lock enforces a minimum and maximum retention period for future backup and copy jobs that target a backup vault.
     *
     * Backup Vault Lock has yet to receive a third-party assessment for SEC 17a-4(f) and CFTC.
     */
    suspend fun putBackupVaultLockConfiguration(input: PutBackupVaultLockConfigurationRequest): PutBackupVaultLockConfigurationResponse

    /**
     * Applies Backup Vault Lock to a backup vault, preventing attempts to delete any recovery point stored in or created in a backup vault. Vault Lock also prevents attempts to update the lifecycle policy that controls the retention period of any recovery point currently stored in a backup vault. If specified, Vault Lock enforces a minimum and maximum retention period for future backup and copy jobs that target a backup vault.
     *
     * Backup Vault Lock has yet to receive a third-party assessment for SEC 17a-4(f) and CFTC.
     */
    suspend fun putBackupVaultLockConfiguration(block: PutBackupVaultLockConfigurationRequest.Builder.() -> Unit) = putBackupVaultLockConfiguration(PutBackupVaultLockConfigurationRequest.Builder().apply(block).build())

    /**
     * Turns on notifications on a backup vault for the specified topic and events.
     */
    suspend fun putBackupVaultNotifications(input: PutBackupVaultNotificationsRequest): PutBackupVaultNotificationsResponse

    /**
     * Turns on notifications on a backup vault for the specified topic and events.
     */
    suspend fun putBackupVaultNotifications(block: PutBackupVaultNotificationsRequest.Builder.() -> Unit) = putBackupVaultNotifications(PutBackupVaultNotificationsRequest.Builder().apply(block).build())

    /**
     * Starts an on-demand backup job for the specified resource.
     */
    suspend fun startBackupJob(input: StartBackupJobRequest): StartBackupJobResponse

    /**
     * Starts an on-demand backup job for the specified resource.
     */
    suspend fun startBackupJob(block: StartBackupJobRequest.Builder.() -> Unit) = startBackupJob(StartBackupJobRequest.Builder().apply(block).build())

    /**
     * Starts a job to create a one-time copy of the specified resource.
     *
     * Does not support continuous backups.
     */
    suspend fun startCopyJob(input: StartCopyJobRequest): StartCopyJobResponse

    /**
     * Starts a job to create a one-time copy of the specified resource.
     *
     * Does not support continuous backups.
     */
    suspend fun startCopyJob(block: StartCopyJobRequest.Builder.() -> Unit) = startCopyJob(StartCopyJobRequest.Builder().apply(block).build())

    /**
     * Starts an on-demand report job for the specified report plan.
     */
    suspend fun startReportJob(input: StartReportJobRequest): StartReportJobResponse

    /**
     * Starts an on-demand report job for the specified report plan.
     */
    suspend fun startReportJob(block: StartReportJobRequest.Builder.() -> Unit) = startReportJob(StartReportJobRequest.Builder().apply(block).build())

    /**
     * Recovers the saved resource identified by an Amazon Resource Name (ARN).
     */
    suspend fun startRestoreJob(input: StartRestoreJobRequest): StartRestoreJobResponse

    /**
     * Recovers the saved resource identified by an Amazon Resource Name (ARN).
     */
    suspend fun startRestoreJob(block: StartRestoreJobRequest.Builder.() -> Unit) = startRestoreJob(StartRestoreJobRequest.Builder().apply(block).build())

    /**
     * Attempts to cancel a job to create a one-time backup of a resource.
     */
    suspend fun stopBackupJob(input: StopBackupJobRequest): StopBackupJobResponse

    /**
     * Attempts to cancel a job to create a one-time backup of a resource.
     */
    suspend fun stopBackupJob(block: StopBackupJobRequest.Builder.() -> Unit) = stopBackupJob(StopBackupJobRequest.Builder().apply(block).build())

    /**
     * Assigns a set of key-value pairs to a recovery point, backup plan, or backup vault identified by an Amazon Resource Name (ARN).
     */
    suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Assigns a set of key-value pairs to a recovery point, backup plan, or backup vault identified by an Amazon Resource Name (ARN).
     */
    suspend fun tagResource(block: TagResourceRequest.Builder.() -> Unit) = tagResource(TagResourceRequest.Builder().apply(block).build())

    /**
     * Removes a set of key-value pairs from a recovery point, backup plan, or backup vault identified by an Amazon Resource Name (ARN)
     */
    suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Removes a set of key-value pairs from a recovery point, backup plan, or backup vault identified by an Amazon Resource Name (ARN)
     */
    suspend fun untagResource(block: UntagResourceRequest.Builder.() -> Unit) = untagResource(UntagResourceRequest.Builder().apply(block).build())

    /**
     * Updates an existing backup plan identified by its `backupPlanId` with the input document in JSON format. The new version is uniquely identified by a `VersionId`.
     */
    suspend fun updateBackupPlan(input: UpdateBackupPlanRequest): UpdateBackupPlanResponse

    /**
     * Updates an existing backup plan identified by its `backupPlanId` with the input document in JSON format. The new version is uniquely identified by a `VersionId`.
     */
    suspend fun updateBackupPlan(block: UpdateBackupPlanRequest.Builder.() -> Unit) = updateBackupPlan(UpdateBackupPlanRequest.Builder().apply(block).build())

    /**
     * Updates an existing framework identified by its `FrameworkName` with the input document in JSON format.
     */
    suspend fun updateFramework(input: UpdateFrameworkRequest): UpdateFrameworkResponse

    /**
     * Updates an existing framework identified by its `FrameworkName` with the input document in JSON format.
     */
    suspend fun updateFramework(block: UpdateFrameworkRequest.Builder.() -> Unit) = updateFramework(UpdateFrameworkRequest.Builder().apply(block).build())

    /**
     * Updates whether the Amazon Web Services account is opted in to cross-account backup. Returns an error if the account is not an Organizations management account. Use the `DescribeGlobalSettings` API to determine the current settings.
     */
    suspend fun updateGlobalSettings(input: UpdateGlobalSettingsRequest = UpdateGlobalSettingsRequest {}): UpdateGlobalSettingsResponse

    /**
     * Updates whether the Amazon Web Services account is opted in to cross-account backup. Returns an error if the account is not an Organizations management account. Use the `DescribeGlobalSettings` API to determine the current settings.
     */
    suspend fun updateGlobalSettings(block: UpdateGlobalSettingsRequest.Builder.() -> Unit) = updateGlobalSettings(UpdateGlobalSettingsRequest.Builder().apply(block).build())

    /**
     * Sets the transition lifecycle of a recovery point.
     *
     * The lifecycle defines when a protected resource is transitioned to cold storage and when it expires. Backup transitions and expires backups automatically according to the lifecycle that you define.
     *
     * Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days. Therefore, the “retention” setting must be 90 days greater than the “transition to cold after days” setting. The “transition to cold after days” setting cannot be changed after a backup has been transitioned to cold.
     *
     * Only resource types that support full Backup management can transition their backups to cold storage. Those resource types are listed in the "Full Backup management" section of the [ Feature availability by resource](https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html#features-by-resource) table. Backup ignores this expression for other resource types.
     *
     * This operation does not support continuous backups.
     */
    suspend fun updateRecoveryPointLifecycle(input: UpdateRecoveryPointLifecycleRequest): UpdateRecoveryPointLifecycleResponse

    /**
     * Sets the transition lifecycle of a recovery point.
     *
     * The lifecycle defines when a protected resource is transitioned to cold storage and when it expires. Backup transitions and expires backups automatically according to the lifecycle that you define.
     *
     * Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days. Therefore, the “retention” setting must be 90 days greater than the “transition to cold after days” setting. The “transition to cold after days” setting cannot be changed after a backup has been transitioned to cold.
     *
     * Only resource types that support full Backup management can transition their backups to cold storage. Those resource types are listed in the "Full Backup management" section of the [ Feature availability by resource](https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html#features-by-resource) table. Backup ignores this expression for other resource types.
     *
     * This operation does not support continuous backups.
     */
    suspend fun updateRecoveryPointLifecycle(block: UpdateRecoveryPointLifecycleRequest.Builder.() -> Unit) = updateRecoveryPointLifecycle(UpdateRecoveryPointLifecycleRequest.Builder().apply(block).build())

    /**
     * Updates the current service opt-in settings for the Region. If service-opt-in is enabled for a service, Backup tries to protect that service's resources in this Region, when the resource is included in an on-demand backup or scheduled backup plan. Otherwise, Backup does not try to protect that service's resources in this Region. Use the `DescribeRegionSettings` API to determine the resource types that are supported.
     */
    suspend fun updateRegionSettings(input: UpdateRegionSettingsRequest = UpdateRegionSettingsRequest {}): UpdateRegionSettingsResponse

    /**
     * Updates the current service opt-in settings for the Region. If service-opt-in is enabled for a service, Backup tries to protect that service's resources in this Region, when the resource is included in an on-demand backup or scheduled backup plan. Otherwise, Backup does not try to protect that service's resources in this Region. Use the `DescribeRegionSettings` API to determine the resource types that are supported.
     */
    suspend fun updateRegionSettings(block: UpdateRegionSettingsRequest.Builder.() -> Unit) = updateRegionSettings(UpdateRegionSettingsRequest.Builder().apply(block).build())

    /**
     * Updates an existing report plan identified by its `ReportPlanName` with the input document in JSON format.
     */
    suspend fun updateReportPlan(input: UpdateReportPlanRequest): UpdateReportPlanResponse

    /**
     * Updates an existing report plan identified by its `ReportPlanName` with the input document in JSON format.
     */
    suspend fun updateReportPlan(block: UpdateReportPlanRequest.Builder.() -> Unit) = updateReportPlan(UpdateReportPlanRequest.Builder().apply(block).build())
}
