// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.model



/**
 * Specifies a scheduled task used to back up a selection of resources.
 */
class BackupRule private constructor(builder: Builder) {
    /**
     * A value in minutes after a backup job is successfully started before it must be completed or it will be canceled by Backup. This value is optional.
     */
    val completionWindowMinutes: kotlin.Long? = builder.completionWindowMinutes
    /**
     * An array of `CopyAction` objects, which contains the details of the copy operation.
     */
    val copyActions: List<CopyAction>? = builder.copyActions
    /**
     * Specifies whether Backup creates continuous backups. True causes Backup to create continuous backups capable of point-in-time restore (PITR). False (or not specified) causes Backup to create snapshot backups.
     */
    val enableContinuousBackup: kotlin.Boolean? = builder.enableContinuousBackup
    /**
     * The lifecycle defines when a protected resource is transitioned to cold storage and when it expires. Backup transitions and expires backups automatically according to the lifecycle that you define.
     *
     * Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days. Therefore, the “retention” setting must be 90 days greater than the “transition to cold after days” setting. The “transition to cold after days” setting cannot be changed after a backup has been transitioned to cold.
     *
     * Only resource types that support full Backup management can transition their backups to cold storage. Those resource types are listed in the "Full Backup management" section of the [ Feature availability by resource](https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html#features-by-resource) table. Backup ignores this expression for other resource types.
     */
    val lifecycle: aws.sdk.kotlin.services.backup.model.Lifecycle? = builder.lifecycle
    /**
     * An array of key-value pair strings that are assigned to resources that are associated with this rule when restored from backup.
     */
    val recoveryPointTags: Map<String, String>? = builder.recoveryPointTags
    /**
     * Uniquely identifies a rule that is used to schedule the backup of a selection of resources.
     */
    val ruleId: kotlin.String? = builder.ruleId
    /**
     * A display name for a backup rule. Must contain 1 to 50 alphanumeric or '-_.' characters.
     */
    val ruleName: kotlin.String? = builder.ruleName
    /**
     * A cron expression in UTC specifying when Backup initiates a backup job. For more information about Amazon Web Services cron expressions, see [Schedule Expressions for Rules](https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html) in the *Amazon CloudWatch Events User Guide.*. Two examples of Amazon Web Services cron expressions are ` 15 * ? * * *` (take a backup every hour at 15 minutes past the hour) and `0 12 * * ? *` (take a backup every day at 12 noon UTC). For a table of examples, click the preceding link and scroll down the page.
     */
    val scheduleExpression: kotlin.String? = builder.scheduleExpression
    /**
     * A value in minutes after a backup is scheduled before a job will be canceled if it doesn't start successfully. This value is optional.
     */
    val startWindowMinutes: kotlin.Long? = builder.startWindowMinutes
    /**
     * The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Amazon Web Services Region where they are created. They consist of lowercase letters, numbers, and hyphens.
     */
    val targetBackupVaultName: kotlin.String? = builder.targetBackupVaultName

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.backup.model.BackupRule = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BackupRule(")
        append("completionWindowMinutes=$completionWindowMinutes,")
        append("copyActions=$copyActions,")
        append("enableContinuousBackup=$enableContinuousBackup,")
        append("lifecycle=$lifecycle,")
        append("recoveryPointTags=*** Sensitive Data Redacted ***,")
        append("ruleId=$ruleId,")
        append("ruleName=$ruleName,")
        append("scheduleExpression=$scheduleExpression,")
        append("startWindowMinutes=$startWindowMinutes,")
        append("targetBackupVaultName=$targetBackupVaultName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = completionWindowMinutes?.hashCode() ?: 0
        result = 31 * result + (copyActions?.hashCode() ?: 0)
        result = 31 * result + (enableContinuousBackup?.hashCode() ?: 0)
        result = 31 * result + (lifecycle?.hashCode() ?: 0)
        result = 31 * result + (recoveryPointTags?.hashCode() ?: 0)
        result = 31 * result + (ruleId?.hashCode() ?: 0)
        result = 31 * result + (ruleName?.hashCode() ?: 0)
        result = 31 * result + (scheduleExpression?.hashCode() ?: 0)
        result = 31 * result + (startWindowMinutes?.hashCode() ?: 0)
        result = 31 * result + (targetBackupVaultName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BackupRule

        if (completionWindowMinutes != other.completionWindowMinutes) return false
        if (copyActions != other.copyActions) return false
        if (enableContinuousBackup != other.enableContinuousBackup) return false
        if (lifecycle != other.lifecycle) return false
        if (recoveryPointTags != other.recoveryPointTags) return false
        if (ruleId != other.ruleId) return false
        if (ruleName != other.ruleName) return false
        if (scheduleExpression != other.scheduleExpression) return false
        if (startWindowMinutes != other.startWindowMinutes) return false
        if (targetBackupVaultName != other.targetBackupVaultName) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.backup.model.BackupRule = Builder(this).apply(block).build()

    class Builder {
        /**
         * A value in minutes after a backup job is successfully started before it must be completed or it will be canceled by Backup. This value is optional.
         */
        var completionWindowMinutes: kotlin.Long? = null
        /**
         * An array of `CopyAction` objects, which contains the details of the copy operation.
         */
        var copyActions: List<CopyAction>? = null
        /**
         * Specifies whether Backup creates continuous backups. True causes Backup to create continuous backups capable of point-in-time restore (PITR). False (or not specified) causes Backup to create snapshot backups.
         */
        var enableContinuousBackup: kotlin.Boolean? = null
        /**
         * The lifecycle defines when a protected resource is transitioned to cold storage and when it expires. Backup transitions and expires backups automatically according to the lifecycle that you define.
         *
         * Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days. Therefore, the “retention” setting must be 90 days greater than the “transition to cold after days” setting. The “transition to cold after days” setting cannot be changed after a backup has been transitioned to cold.
         *
         * Only resource types that support full Backup management can transition their backups to cold storage. Those resource types are listed in the "Full Backup management" section of the [ Feature availability by resource](https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html#features-by-resource) table. Backup ignores this expression for other resource types.
         */
        var lifecycle: aws.sdk.kotlin.services.backup.model.Lifecycle? = null
        /**
         * An array of key-value pair strings that are assigned to resources that are associated with this rule when restored from backup.
         */
        var recoveryPointTags: Map<String, String>? = null
        /**
         * Uniquely identifies a rule that is used to schedule the backup of a selection of resources.
         */
        var ruleId: kotlin.String? = null
        /**
         * A display name for a backup rule. Must contain 1 to 50 alphanumeric or '-_.' characters.
         */
        var ruleName: kotlin.String? = null
        /**
         * A cron expression in UTC specifying when Backup initiates a backup job. For more information about Amazon Web Services cron expressions, see [Schedule Expressions for Rules](https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html) in the *Amazon CloudWatch Events User Guide.*. Two examples of Amazon Web Services cron expressions are ` 15 * ? * * *` (take a backup every hour at 15 minutes past the hour) and `0 12 * * ? *` (take a backup every day at 12 noon UTC). For a table of examples, click the preceding link and scroll down the page.
         */
        var scheduleExpression: kotlin.String? = null
        /**
         * A value in minutes after a backup is scheduled before a job will be canceled if it doesn't start successfully. This value is optional.
         */
        var startWindowMinutes: kotlin.Long? = null
        /**
         * The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Amazon Web Services Region where they are created. They consist of lowercase letters, numbers, and hyphens.
         */
        var targetBackupVaultName: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.backup.model.BackupRule) : this() {
            this.completionWindowMinutes = x.completionWindowMinutes
            this.copyActions = x.copyActions
            this.enableContinuousBackup = x.enableContinuousBackup
            this.lifecycle = x.lifecycle
            this.recoveryPointTags = x.recoveryPointTags
            this.ruleId = x.ruleId
            this.ruleName = x.ruleName
            this.scheduleExpression = x.scheduleExpression
            this.startWindowMinutes = x.startWindowMinutes
            this.targetBackupVaultName = x.targetBackupVaultName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.backup.model.BackupRule = BackupRule(this)

        /**
         * construct an [aws.sdk.kotlin.services.backup.model.Lifecycle] inside the given [block]
         */
        fun lifecycle(block: aws.sdk.kotlin.services.backup.model.Lifecycle.Builder.() -> kotlin.Unit) {
            this.lifecycle = aws.sdk.kotlin.services.backup.model.Lifecycle.invoke(block)
        }
    }
}
