// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains detailed information about a framework. Frameworks contain controls, which evaluate and report on your backup events and resources. Frameworks generate daily compliance results.
 */
class Framework private constructor(builder: Builder) {
    /**
     * The date and time that a framework is created, in Unix format and Coordinated Universal Time (UTC). The value of `CreationTime` is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The deployment status of a framework. The statuses are:
     *
     * `CREATE_IN_PROGRESS | UPDATE_IN_PROGRESS | DELETE_IN_PROGRESS | COMPLETED | FAILED`
     */
    val deploymentStatus: kotlin.String? = builder.deploymentStatus
    /**
     * An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on the resource type.
     */
    val frameworkArn: kotlin.String? = builder.frameworkArn
    /**
     * An optional description of the framework with a maximum 1,024 characters.
     */
    val frameworkDescription: kotlin.String? = builder.frameworkDescription
    /**
     * The unique name of a framework. This name is between 1 and 256 characters, starting with a letter, and consisting of letters (a-z, A-Z), numbers (0-9), and underscores (_).
     */
    val frameworkName: kotlin.String? = builder.frameworkName
    /**
     * The number of controls contained by the framework.
     */
    val numberOfControls: kotlin.Int = builder.numberOfControls

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.backup.model.Framework = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Framework(")
        append("creationTime=$creationTime,")
        append("deploymentStatus=$deploymentStatus,")
        append("frameworkArn=$frameworkArn,")
        append("frameworkDescription=$frameworkDescription,")
        append("frameworkName=$frameworkName,")
        append("numberOfControls=$numberOfControls)")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTime?.hashCode() ?: 0
        result = 31 * result + (deploymentStatus?.hashCode() ?: 0)
        result = 31 * result + (frameworkArn?.hashCode() ?: 0)
        result = 31 * result + (frameworkDescription?.hashCode() ?: 0)
        result = 31 * result + (frameworkName?.hashCode() ?: 0)
        result = 31 * result + (numberOfControls)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Framework

        if (creationTime != other.creationTime) return false
        if (deploymentStatus != other.deploymentStatus) return false
        if (frameworkArn != other.frameworkArn) return false
        if (frameworkDescription != other.frameworkDescription) return false
        if (frameworkName != other.frameworkName) return false
        if (numberOfControls != other.numberOfControls) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.backup.model.Framework = Builder(this).apply(block).build()

    class Builder {
        /**
         * The date and time that a framework is created, in Unix format and Coordinated Universal Time (UTC). The value of `CreationTime` is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         */
        var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The deployment status of a framework. The statuses are:
         *
         * `CREATE_IN_PROGRESS | UPDATE_IN_PROGRESS | DELETE_IN_PROGRESS | COMPLETED | FAILED`
         */
        var deploymentStatus: kotlin.String? = null
        /**
         * An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on the resource type.
         */
        var frameworkArn: kotlin.String? = null
        /**
         * An optional description of the framework with a maximum 1,024 characters.
         */
        var frameworkDescription: kotlin.String? = null
        /**
         * The unique name of a framework. This name is between 1 and 256 characters, starting with a letter, and consisting of letters (a-z, A-Z), numbers (0-9), and underscores (_).
         */
        var frameworkName: kotlin.String? = null
        /**
         * The number of controls contained by the framework.
         */
        var numberOfControls: kotlin.Int = 0

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.backup.model.Framework) : this() {
            this.creationTime = x.creationTime
            this.deploymentStatus = x.deploymentStatus
            this.frameworkArn = x.frameworkArn
            this.frameworkDescription = x.frameworkDescription
            this.frameworkName = x.frameworkName
            this.numberOfControls = x.numberOfControls
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.backup.model.Framework = Framework(this)
    }
}
