// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains detailed information about a report job. A report job compiles a report based on a report plan and publishes it to Amazon S3.
 */
class ReportJob private constructor(builder: Builder) {
    /**
     * The date and time that a report job is completed, in Unix format and Coordinated Universal Time (UTC). The value of `CompletionTime` is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    val completionTime: aws.smithy.kotlin.runtime.time.Instant? = builder.completionTime
    /**
     * The date and time that a report job is created, in Unix format and Coordinated Universal Time (UTC). The value of `CreationTime` is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The S3 bucket name and S3 keys for the destination where the report job publishes the report.
     */
    val reportDestination: aws.sdk.kotlin.services.backup.model.ReportDestination? = builder.reportDestination
    /**
     * The identifier for a report job. A unique, randomly generated, Unicode, UTF-8 encoded string that is at most 1,024 bytes long. Report job IDs cannot be edited.
     */
    val reportJobId: kotlin.String? = builder.reportJobId
    /**
     * An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on the resource type.
     */
    val reportPlanArn: kotlin.String? = builder.reportPlanArn
    /**
     * Identifies the report template for the report. Reports are built using a report template. The report templates are:
     *
     * `RESOURCE_COMPLIANCE_REPORT | CONTROL_COMPLIANCE_REPORT | BACKUP_JOB_REPORT | COPY_JOB_REPORT | RESTORE_JOB_REPORT`
     */
    val reportTemplate: kotlin.String? = builder.reportTemplate
    /**
     * The status of a report job. The statuses are:
     *
     * `CREATED | RUNNING | COMPLETED | FAILED`
     *
     * `COMPLETED` means that the report is available for your review at your designated destination. If the status is `FAILED`, review the `StatusMessage` for the reason.
     */
    val status: kotlin.String? = builder.status
    /**
     * A message explaining the status of the report job.
     */
    val statusMessage: kotlin.String? = builder.statusMessage

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.backup.model.ReportJob = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ReportJob(")
        append("completionTime=$completionTime,")
        append("creationTime=$creationTime,")
        append("reportDestination=$reportDestination,")
        append("reportJobId=$reportJobId,")
        append("reportPlanArn=$reportPlanArn,")
        append("reportTemplate=$reportTemplate,")
        append("status=$status,")
        append("statusMessage=$statusMessage)")
    }

    override fun hashCode(): kotlin.Int {
        var result = completionTime?.hashCode() ?: 0
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (reportDestination?.hashCode() ?: 0)
        result = 31 * result + (reportJobId?.hashCode() ?: 0)
        result = 31 * result + (reportPlanArn?.hashCode() ?: 0)
        result = 31 * result + (reportTemplate?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusMessage?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ReportJob

        if (completionTime != other.completionTime) return false
        if (creationTime != other.creationTime) return false
        if (reportDestination != other.reportDestination) return false
        if (reportJobId != other.reportJobId) return false
        if (reportPlanArn != other.reportPlanArn) return false
        if (reportTemplate != other.reportTemplate) return false
        if (status != other.status) return false
        if (statusMessage != other.statusMessage) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.backup.model.ReportJob = Builder(this).apply(block).build()

    class Builder {
        /**
         * The date and time that a report job is completed, in Unix format and Coordinated Universal Time (UTC). The value of `CompletionTime` is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         */
        var completionTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The date and time that a report job is created, in Unix format and Coordinated Universal Time (UTC). The value of `CreationTime` is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         */
        var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The S3 bucket name and S3 keys for the destination where the report job publishes the report.
         */
        var reportDestination: aws.sdk.kotlin.services.backup.model.ReportDestination? = null
        /**
         * The identifier for a report job. A unique, randomly generated, Unicode, UTF-8 encoded string that is at most 1,024 bytes long. Report job IDs cannot be edited.
         */
        var reportJobId: kotlin.String? = null
        /**
         * An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on the resource type.
         */
        var reportPlanArn: kotlin.String? = null
        /**
         * Identifies the report template for the report. Reports are built using a report template. The report templates are:
         *
         * `RESOURCE_COMPLIANCE_REPORT | CONTROL_COMPLIANCE_REPORT | BACKUP_JOB_REPORT | COPY_JOB_REPORT | RESTORE_JOB_REPORT`
         */
        var reportTemplate: kotlin.String? = null
        /**
         * The status of a report job. The statuses are:
         *
         * `CREATED | RUNNING | COMPLETED | FAILED`
         *
         * `COMPLETED` means that the report is available for your review at your designated destination. If the status is `FAILED`, review the `StatusMessage` for the reason.
         */
        var status: kotlin.String? = null
        /**
         * A message explaining the status of the report job.
         */
        var statusMessage: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.backup.model.ReportJob) : this() {
            this.completionTime = x.completionTime
            this.creationTime = x.creationTime
            this.reportDestination = x.reportDestination
            this.reportJobId = x.reportJobId
            this.reportPlanArn = x.reportPlanArn
            this.reportTemplate = x.reportTemplate
            this.status = x.status
            this.statusMessage = x.statusMessage
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.backup.model.ReportJob = ReportJob(this)

        /**
         * construct an [aws.sdk.kotlin.services.backup.model.ReportDestination] inside the given [block]
         */
        fun reportDestination(block: aws.sdk.kotlin.services.backup.model.ReportDestination.Builder.() -> kotlin.Unit) {
            this.reportDestination = aws.sdk.kotlin.services.backup.model.ReportDestination.invoke(block)
        }
    }
}
