// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.backup.model.BackupException
import aws.sdk.kotlin.services.backup.model.CalculatedLifecycle
import aws.sdk.kotlin.services.backup.model.DescribeRecoveryPointResponse
import aws.sdk.kotlin.services.backup.model.Lifecycle
import aws.sdk.kotlin.services.backup.model.RecoveryPointCreator
import aws.sdk.kotlin.services.backup.model.RecoveryPointStatus
import aws.sdk.kotlin.services.backup.model.StorageClass
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class DescribeRecoveryPointOperationDeserializer: HttpDeserialize<DescribeRecoveryPointResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeRecoveryPointResponse {
        if (!response.status.isSuccess()) {
            throwDescribeRecoveryPointError(context, response)
        }
        val builder = DescribeRecoveryPointResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeRecoveryPointOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeRecoveryPointError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw BackupException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParameterValueException" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedResponse)
        "MissingParameterValueException" -> MissingParameterValueExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> BackupException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeRecoveryPointOperationBody(builder: DescribeRecoveryPointResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val BACKUPSIZEINBYTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("BackupSizeInBytes"))
    val BACKUPVAULTARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("BackupVaultArn"))
    val BACKUPVAULTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("BackupVaultName"))
    val CALCULATEDLIFECYCLE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("CalculatedLifecycle"))
    val COMPLETIONDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CompletionDate"))
    val CREATEDBY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("CreatedBy"))
    val CREATIONDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationDate"))
    val ENCRYPTIONKEYARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("EncryptionKeyArn"))
    val IAMROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("IamRoleArn"))
    val ISENCRYPTED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("IsEncrypted"))
    val LASTRESTORETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastRestoreTime"))
    val LIFECYCLE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Lifecycle"))
    val RECOVERYPOINTARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RecoveryPointArn"))
    val RESOURCEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ResourceArn"))
    val RESOURCETYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ResourceType"))
    val SOURCEBACKUPVAULTARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SourceBackupVaultArn"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Status"))
    val STATUSMESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("StatusMessage"))
    val STORAGECLASS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("StorageClass"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BACKUPSIZEINBYTES_DESCRIPTOR)
        field(BACKUPVAULTARN_DESCRIPTOR)
        field(BACKUPVAULTNAME_DESCRIPTOR)
        field(CALCULATEDLIFECYCLE_DESCRIPTOR)
        field(COMPLETIONDATE_DESCRIPTOR)
        field(CREATEDBY_DESCRIPTOR)
        field(CREATIONDATE_DESCRIPTOR)
        field(ENCRYPTIONKEYARN_DESCRIPTOR)
        field(IAMROLEARN_DESCRIPTOR)
        field(ISENCRYPTED_DESCRIPTOR)
        field(LASTRESTORETIME_DESCRIPTOR)
        field(LIFECYCLE_DESCRIPTOR)
        field(RECOVERYPOINTARN_DESCRIPTOR)
        field(RESOURCEARN_DESCRIPTOR)
        field(RESOURCETYPE_DESCRIPTOR)
        field(SOURCEBACKUPVAULTARN_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(STATUSMESSAGE_DESCRIPTOR)
        field(STORAGECLASS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BACKUPSIZEINBYTES_DESCRIPTOR.index -> builder.backupSizeInBytes = deserializeLong()
                BACKUPVAULTARN_DESCRIPTOR.index -> builder.backupVaultArn = deserializeString()
                BACKUPVAULTNAME_DESCRIPTOR.index -> builder.backupVaultName = deserializeString()
                CALCULATEDLIFECYCLE_DESCRIPTOR.index -> builder.calculatedLifecycle = deserializeCalculatedLifecycleDocument(deserializer)
                COMPLETIONDATE_DESCRIPTOR.index -> builder.completionDate = deserializeString().let { Instant.fromEpochSeconds(it) }
                CREATEDBY_DESCRIPTOR.index -> builder.createdBy = deserializeRecoveryPointCreatorDocument(deserializer)
                CREATIONDATE_DESCRIPTOR.index -> builder.creationDate = deserializeString().let { Instant.fromEpochSeconds(it) }
                ENCRYPTIONKEYARN_DESCRIPTOR.index -> builder.encryptionKeyArn = deserializeString()
                IAMROLEARN_DESCRIPTOR.index -> builder.iamRoleArn = deserializeString()
                ISENCRYPTED_DESCRIPTOR.index -> builder.isEncrypted = deserializeBoolean()
                LASTRESTORETIME_DESCRIPTOR.index -> builder.lastRestoreTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                LIFECYCLE_DESCRIPTOR.index -> builder.lifecycle = deserializeLifecycleDocument(deserializer)
                RECOVERYPOINTARN_DESCRIPTOR.index -> builder.recoveryPointArn = deserializeString()
                RESOURCEARN_DESCRIPTOR.index -> builder.resourceArn = deserializeString()
                RESOURCETYPE_DESCRIPTOR.index -> builder.resourceType = deserializeString()
                SOURCEBACKUPVAULTARN_DESCRIPTOR.index -> builder.sourceBackupVaultArn = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { RecoveryPointStatus.fromValue(it) }
                STATUSMESSAGE_DESCRIPTOR.index -> builder.statusMessage = deserializeString()
                STORAGECLASS_DESCRIPTOR.index -> builder.storageClass = deserializeString().let { StorageClass.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
