// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.backup.model.BackupException
import aws.sdk.kotlin.services.backup.model.BackupSelection
import aws.sdk.kotlin.services.backup.model.GetBackupSelectionResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class GetBackupSelectionOperationDeserializer: HttpDeserialize<GetBackupSelectionResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetBackupSelectionResponse {
        if (!response.status.isSuccess()) {
            throwGetBackupSelectionError(context, response)
        }
        val builder = GetBackupSelectionResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetBackupSelectionOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetBackupSelectionError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw BackupException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParameterValueException" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedResponse)
        "MissingParameterValueException" -> MissingParameterValueExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> BackupException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetBackupSelectionOperationBody(builder: GetBackupSelectionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val BACKUPPLANID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("BackupPlanId"))
    val BACKUPSELECTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("BackupSelection"))
    val CREATIONDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationDate"))
    val CREATORREQUESTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("CreatorRequestId"))
    val SELECTIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SelectionId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BACKUPPLANID_DESCRIPTOR)
        field(BACKUPSELECTION_DESCRIPTOR)
        field(CREATIONDATE_DESCRIPTOR)
        field(CREATORREQUESTID_DESCRIPTOR)
        field(SELECTIONID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BACKUPPLANID_DESCRIPTOR.index -> builder.backupPlanId = deserializeString()
                BACKUPSELECTION_DESCRIPTOR.index -> builder.backupSelection = deserializeBackupSelectionDocument(deserializer)
                CREATIONDATE_DESCRIPTOR.index -> builder.creationDate = deserializeString().let { Instant.fromEpochSeconds(it) }
                CREATORREQUESTID_DESCRIPTOR.index -> builder.creatorRequestId = deserializeString()
                SELECTIONID_DESCRIPTOR.index -> builder.selectionId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
