// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.backup.model.*
import aws.sdk.kotlin.services.backup.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


const val ServiceId: String = "Backup"
const val ServiceApiVersion: String = "2018-11-15"
const val SdkVersion: String = "0.16.6-beta"

internal class DefaultBackupClient(override val config: BackupClient.Config) : BackupClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Creates a backup plan using a backup plan name and backup rules. A backup plan is a document that contains information that Backup uses to schedule tasks that create recovery points for resources.
     *
     * If you call `CreateBackupPlan` with a plan that already exists, you receive an `AlreadyExistsException` exception.
     */
    override suspend fun createBackupPlan(input: CreateBackupPlanRequest): CreateBackupPlanResponse {
        val op = SdkHttpOperation.build<CreateBackupPlanRequest, CreateBackupPlanResponse> {
            serializer = CreateBackupPlanOperationSerializer()
            deserializer = CreateBackupPlanOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateBackupPlan"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "backup"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a JSON document that specifies a set of resources to assign to a backup plan. For examples, see [Assigning resources programmatically](https://docs.aws.amazon.com/aws-backup/latest/devguide/assigning-resources.html#assigning-resources-json).
     */
    override suspend fun createBackupSelection(input: CreateBackupSelectionRequest): CreateBackupSelectionResponse {
        val op = SdkHttpOperation.build<CreateBackupSelectionRequest, CreateBackupSelectionResponse> {
            serializer = CreateBackupSelectionOperationSerializer()
            deserializer = CreateBackupSelectionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateBackupSelection"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "backup"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a logical container where backups are stored. A `CreateBackupVault` request includes a name, optionally one or more resource tags, an encryption key, and a request ID.
     *
     * Do not include sensitive data, such as passport numbers, in the name of a backup vault.
     */
    override suspend fun createBackupVault(input: CreateBackupVaultRequest): CreateBackupVaultResponse {
        val op = SdkHttpOperation.build<CreateBackupVaultRequest, CreateBackupVaultResponse> {
            serializer = CreateBackupVaultOperationSerializer()
            deserializer = CreateBackupVaultOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateBackupVault"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "backup"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a framework with one or more controls. A framework is a collection of controls that you can use to evaluate your backup practices. By using pre-built customizable controls to define your policies, you can evaluate whether your backup practices comply with your policies and which resources are not yet in compliance.
     */
    override suspend fun createFramework(input: CreateFrameworkRequest): CreateFrameworkResponse {
        val op = SdkHttpOperation.build<CreateFrameworkRequest, CreateFrameworkResponse> {
            serializer = CreateFrameworkOperationSerializer()
            deserializer = CreateFrameworkOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateFramework"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "backup"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a report plan. A report plan is a document that contains information about the contents of the report and where Backup will deliver it.
     *
     * If you call `CreateReportPlan` with a plan that already exists, you receive an `AlreadyExistsException` exception.
     */
    override suspend fun createReportPlan(input: CreateReportPlanRequest): CreateReportPlanResponse {
        val op = SdkHttpOperation.build<CreateReportPlanRequest, CreateReportPlanResponse> {
            serializer = CreateReportPlanOperationSerializer()
            deserializer = CreateReportPlanOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateReportPlan"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "backup"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a backup plan. A backup plan can only be deleted after all associated selections of resources have been deleted. Deleting a backup plan deletes the current version of a backup plan. Previous versions, if any, will still exist.
     */
    override suspend fun deleteBackupPlan(input: DeleteBackupPlanRequest): DeleteBackupPlanResponse {
        val op = SdkHttpOperation.build<DeleteBackupPlanRequest, DeleteBackupPlanResponse> {
            serializer = DeleteBackupPlanOperationSerializer()
            deserializer = DeleteBackupPlanOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteBackupPlan"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "backup"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the resource selection associated with a backup plan that is specified by the `SelectionId`.
     */
    override suspend fun deleteBackupSelection(input: DeleteBackupSelectionRequest): DeleteBackupSelectionResponse {
        val op = SdkHttpOperation.build<DeleteBackupSelectionRequest, DeleteBackupSelectionResponse> {
            serializer = DeleteBackupSelectionOperationSerializer()
            deserializer = DeleteBackupSelectionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteBackupSelection"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "backup"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the backup vault identified by its name. A vault can be deleted only if it is empty.
     */
    override suspend fun deleteBackupVault(input: DeleteBackupVaultRequest): DeleteBackupVaultResponse {
        val op = SdkHttpOperation.build<DeleteBackupVaultRequest, DeleteBackupVaultResponse> {
            serializer = DeleteBackupVaultOperationSerializer()
            deserializer = DeleteBackupVaultOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteBackupVault"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "backup"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the policy document that manages permissions on a backup vault.
     */
    override suspend fun deleteBackupVaultAccessPolicy(input: DeleteBackupVaultAccessPolicyRequest): DeleteBackupVaultAccessPolicyResponse {
        val op = SdkHttpOperation.build<DeleteBackupVaultAccessPolicyRequest, DeleteBackupVaultAccessPolicyResponse> {
            serializer = DeleteBackupVaultAccessPolicyOperationSerializer()
            deserializer = DeleteBackupVaultAccessPolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteBackupVaultAccessPolicy"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "backup"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes Backup Vault Lock from a backup vault specified by a backup vault name.
     *
     * If the Vault Lock configuration is immutable, then you cannot delete Vault Lock using API operations, and you will receive an `InvalidRequestException` if you attempt to do so. For more information, see [Vault Lock](https://docs.aws.amazon.com/aws-backup/latest/devguide/vault-lock.html) in the *Backup Developer Guide*.
     */
    override suspend fun deleteBackupVaultLockConfiguration(input: DeleteBackupVaultLockConfigurationRequest): DeleteBackupVaultLockConfigurationResponse {
        val op = SdkHttpOperation.build<DeleteBackupVaultLockConfigurationRequest, DeleteBackupVaultLockConfigurationResponse> {
            serializer = DeleteBackupVaultLockConfigurationOperationSerializer()
            deserializer = DeleteBackupVaultLockConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteBackupVaultLockConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "backup"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes event notifications for the specified backup vault.
     */
    override suspend fun deleteBackupVaultNotifications(input: DeleteBackupVaultNotificationsRequest): DeleteBackupVaultNotificationsResponse {
        val op = SdkHttpOperation.build<DeleteBackupVaultNotificationsRequest, DeleteBackupVaultNotificationsResponse> {
            serializer = DeleteBackupVaultNotificationsOperationSerializer()
            deserializer = DeleteBackupVaultNotificationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteBackupVaultNotifications"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "backup"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the framework specified by a framework name.
     */
    override suspend fun deleteFramework(input: DeleteFrameworkRequest): DeleteFrameworkResponse {
        val op = SdkHttpOperation.build<DeleteFrameworkRequest, DeleteFrameworkResponse> {
            serializer = DeleteFrameworkOperationSerializer()
            deserializer = DeleteFrameworkOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteFramework"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "backup"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the recovery point specified by a recovery point ID.
     *
     * If the recovery point ID belongs to a continuous backup, calling this endpoint deletes the existing continuous backup and stops future continuous backup.
     */
    override suspend fun deleteRecoveryPoint(input: DeleteRecoveryPointRequest): DeleteRecoveryPointResponse {
        val op = SdkHttpOperation.build<DeleteRecoveryPointRequest, DeleteRecoveryPointResponse> {
            serializer = DeleteRecoveryPointOperationSerializer()
            deserializer = DeleteRecoveryPointOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteRecoveryPoint"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "backup"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the report plan specified by a report plan name.
     */
    override suspend fun deleteReportPlan(input: DeleteReportPlanRequest): DeleteReportPlanResponse {
        val op = SdkHttpOperation.build<DeleteReportPlanRequest, DeleteReportPlanResponse> {
            serializer = DeleteReportPlanOperationSerializer()
            deserializer = DeleteReportPlanOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteReportPlan"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "backup"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns backup job details for the specified `BackupJobId`.
     */
    override suspend fun describeBackupJob(input: DescribeBackupJobRequest): DescribeBackupJobResponse {
        val op = SdkHttpOperation.build<DescribeBackupJobRequest, DescribeBackupJobResponse> {
            serializer = DescribeBackupJobOperationSerializer()
            deserializer = DescribeBackupJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeBackupJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "backup"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns metadata about a backup vault specified by its name.
     */
    override suspend fun describeBackupVault(input: DescribeBackupVaultRequest): DescribeBackupVaultResponse {
        val op = SdkHttpOperation.build<DescribeBackupVaultRequest, DescribeBackupVaultResponse> {
            serializer = DescribeBackupVaultOperationSerializer()
            deserializer = DescribeBackupVaultOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeBackupVault"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "backup"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns metadata associated with creating a copy of a resource.
     */
    override suspend fun describeCopyJob(input: DescribeCopyJobRequest): DescribeCopyJobResponse {
        val op = SdkHttpOperation.build<DescribeCopyJobRequest, DescribeCopyJobResponse> {
            serializer = DescribeCopyJobOperationSerializer()
            deserializer = DescribeCopyJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeCopyJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "backup"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the framework details for the specified `FrameworkName`.
     */
    override suspend fun describeFramework(input: DescribeFrameworkRequest): DescribeFrameworkResponse {
        val op = SdkHttpOperation.build<DescribeFrameworkRequest, DescribeFrameworkResponse> {
            serializer = DescribeFrameworkOperationSerializer()
            deserializer = DescribeFrameworkOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeFramework"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "backup"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes whether the Amazon Web Services account is opted in to cross-account backup. Returns an error if the account is not a member of an Organizations organization. Example: `describe-global-settings --region us-west-2`
     */
    override suspend fun describeGlobalSettings(input: DescribeGlobalSettingsRequest): DescribeGlobalSettingsResponse {
        val op = SdkHttpOperation.build<DescribeGlobalSettingsRequest, DescribeGlobalSettingsResponse> {
            serializer = DescribeGlobalSettingsOperationSerializer()
            deserializer = DescribeGlobalSettingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeGlobalSettings"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "backup"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about a saved resource, including the last time it was backed up, its Amazon Resource Name (ARN), and the Amazon Web Services service type of the saved resource.
     */
    override suspend fun describeProtectedResource(input: DescribeProtectedResourceRequest): DescribeProtectedResourceResponse {
        val op = SdkHttpOperation.build<DescribeProtectedResourceRequest, DescribeProtectedResourceResponse> {
            serializer = DescribeProtectedResourceOperationSerializer()
            deserializer = DescribeProtectedResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeProtectedResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "backup"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns metadata associated with a recovery point, including ID, status, encryption, and lifecycle.
     */
    override suspend fun describeRecoveryPoint(input: DescribeRecoveryPointRequest): DescribeRecoveryPointResponse {
        val op = SdkHttpOperation.build<DescribeRecoveryPointRequest, DescribeRecoveryPointResponse> {
            serializer = DescribeRecoveryPointOperationSerializer()
            deserializer = DescribeRecoveryPointOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeRecoveryPoint"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "backup"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the current service opt-in settings for the Region. If service opt-in is enabled for a service, Backup tries to protect that service's resources in this Region, when the resource is included in an on-demand backup or scheduled backup plan. Otherwise, Backup does not try to protect that service's resources in this Region.
     */
    override suspend fun describeRegionSettings(input: DescribeRegionSettingsRequest): DescribeRegionSettingsResponse {
        val op = SdkHttpOperation.build<DescribeRegionSettingsRequest, DescribeRegionSettingsResponse> {
            serializer = DescribeRegionSettingsOperationSerializer()
            deserializer = DescribeRegionSettingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeRegionSettings"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "backup"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the details associated with creating a report as specified by its `ReportJobId`.
     */
    override suspend fun describeReportJob(input: DescribeReportJobRequest): DescribeReportJobResponse {
        val op = SdkHttpOperation.build<DescribeReportJobRequest, DescribeReportJobResponse> {
            serializer = DescribeReportJobOperationSerializer()
            deserializer = DescribeReportJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeReportJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "backup"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of all report plans for an Amazon Web Services account and Amazon Web Services Region.
     */
    override suspend fun describeReportPlan(input: DescribeReportPlanRequest): DescribeReportPlanResponse {
        val op = SdkHttpOperation.build<DescribeReportPlanRequest, DescribeReportPlanResponse> {
            serializer = DescribeReportPlanOperationSerializer()
            deserializer = DescribeReportPlanOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeReportPlan"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "backup"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns metadata associated with a restore job that is specified by a job ID.
     */
    override suspend fun describeRestoreJob(input: DescribeRestoreJobRequest): DescribeRestoreJobResponse {
        val op = SdkHttpOperation.build<DescribeRestoreJobRequest, DescribeRestoreJobResponse> {
            serializer = DescribeRestoreJobOperationSerializer()
            deserializer = DescribeRestoreJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeRestoreJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "backup"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified continuous backup recovery point from Backup and releases control of that continuous backup to the source service, such as Amazon RDS. The source service will continue to create and retain continuous backups using the lifecycle that you specified in your original backup plan.
     *
     * Does not support snapshot backup recovery points.
     */
    override suspend fun disassociateRecoveryPoint(input: DisassociateRecoveryPointRequest): DisassociateRecoveryPointResponse {
        val op = SdkHttpOperation.build<DisassociateRecoveryPointRequest, DisassociateRecoveryPointResponse> {
            serializer = DisassociateRecoveryPointOperationSerializer()
            deserializer = DisassociateRecoveryPointOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisassociateRecoveryPoint"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "backup"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the backup plan that is specified by the plan ID as a backup template.
     */
    override suspend fun exportBackupPlanTemplate(input: ExportBackupPlanTemplateRequest): ExportBackupPlanTemplateResponse {
        val op = SdkHttpOperation.build<ExportBackupPlanTemplateRequest, ExportBackupPlanTemplateResponse> {
            serializer = ExportBackupPlanTemplateOperationSerializer()
            deserializer = ExportBackupPlanTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ExportBackupPlanTemplate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "backup"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns `BackupPlan` details for the specified `BackupPlanId`. The details are the body of a backup plan in JSON format, in addition to plan metadata.
     */
    override suspend fun getBackupPlan(input: GetBackupPlanRequest): GetBackupPlanResponse {
        val op = SdkHttpOperation.build<GetBackupPlanRequest, GetBackupPlanResponse> {
            serializer = GetBackupPlanOperationSerializer()
            deserializer = GetBackupPlanOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetBackupPlan"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "backup"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a valid JSON document specifying a backup plan or an error.
     */
    override suspend fun getBackupPlanFromJson(input: GetBackupPlanFromJsonRequest): GetBackupPlanFromJsonResponse {
        val op = SdkHttpOperation.build<GetBackupPlanFromJsonRequest, GetBackupPlanFromJsonResponse> {
            serializer = GetBackupPlanFromJSONOperationSerializer()
            deserializer = GetBackupPlanFromJSONOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetBackupPlanFromJSON"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "backup"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the template specified by its `templateId` as a backup plan.
     */
    override suspend fun getBackupPlanFromTemplate(input: GetBackupPlanFromTemplateRequest): GetBackupPlanFromTemplateResponse {
        val op = SdkHttpOperation.build<GetBackupPlanFromTemplateRequest, GetBackupPlanFromTemplateResponse> {
            serializer = GetBackupPlanFromTemplateOperationSerializer()
            deserializer = GetBackupPlanFromTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetBackupPlanFromTemplate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "backup"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns selection metadata and a document in JSON format that specifies a list of resources that are associated with a backup plan.
     */
    override suspend fun getBackupSelection(input: GetBackupSelectionRequest): GetBackupSelectionResponse {
        val op = SdkHttpOperation.build<GetBackupSelectionRequest, GetBackupSelectionResponse> {
            serializer = GetBackupSelectionOperationSerializer()
            deserializer = GetBackupSelectionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetBackupSelection"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "backup"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the access policy document that is associated with the named backup vault.
     */
    override suspend fun getBackupVaultAccessPolicy(input: GetBackupVaultAccessPolicyRequest): GetBackupVaultAccessPolicyResponse {
        val op = SdkHttpOperation.build<GetBackupVaultAccessPolicyRequest, GetBackupVaultAccessPolicyResponse> {
            serializer = GetBackupVaultAccessPolicyOperationSerializer()
            deserializer = GetBackupVaultAccessPolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetBackupVaultAccessPolicy"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "backup"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns event notifications for the specified backup vault.
     */
    override suspend fun getBackupVaultNotifications(input: GetBackupVaultNotificationsRequest): GetBackupVaultNotificationsResponse {
        val op = SdkHttpOperation.build<GetBackupVaultNotificationsRequest, GetBackupVaultNotificationsResponse> {
            serializer = GetBackupVaultNotificationsOperationSerializer()
            deserializer = GetBackupVaultNotificationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetBackupVaultNotifications"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "backup"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a set of metadata key-value pairs that were used to create the backup.
     */
    override suspend fun getRecoveryPointRestoreMetadata(input: GetRecoveryPointRestoreMetadataRequest): GetRecoveryPointRestoreMetadataResponse {
        val op = SdkHttpOperation.build<GetRecoveryPointRestoreMetadataRequest, GetRecoveryPointRestoreMetadataResponse> {
            serializer = GetRecoveryPointRestoreMetadataOperationSerializer()
            deserializer = GetRecoveryPointRestoreMetadataOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetRecoveryPointRestoreMetadata"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "backup"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the Amazon Web Services resource types supported by Backup.
     */
    override suspend fun getSupportedResourceTypes(input: GetSupportedResourceTypesRequest): GetSupportedResourceTypesResponse {
        val op = SdkHttpOperation.build<GetSupportedResourceTypesRequest, GetSupportedResourceTypesResponse> {
            serializer = GetSupportedResourceTypesOperationSerializer()
            deserializer = GetSupportedResourceTypesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetSupportedResourceTypes"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "backup"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of existing backup jobs for an authenticated account for the last 30 days. For a longer period of time, consider using these [monitoring tools](https://docs.aws.amazon.com/aws-backup/latest/devguide/monitoring.html).
     */
    override suspend fun listBackupJobs(input: ListBackupJobsRequest): ListBackupJobsResponse {
        val op = SdkHttpOperation.build<ListBackupJobsRequest, ListBackupJobsResponse> {
            serializer = ListBackupJobsOperationSerializer()
            deserializer = ListBackupJobsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListBackupJobs"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "backup"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns metadata of your saved backup plan templates, including the template ID, name, and the creation and deletion dates.
     */
    override suspend fun listBackupPlanTemplates(input: ListBackupPlanTemplatesRequest): ListBackupPlanTemplatesResponse {
        val op = SdkHttpOperation.build<ListBackupPlanTemplatesRequest, ListBackupPlanTemplatesResponse> {
            serializer = ListBackupPlanTemplatesOperationSerializer()
            deserializer = ListBackupPlanTemplatesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListBackupPlanTemplates"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "backup"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns version metadata of your backup plans, including Amazon Resource Names (ARNs), backup plan IDs, creation and deletion dates, plan names, and version IDs.
     */
    override suspend fun listBackupPlanVersions(input: ListBackupPlanVersionsRequest): ListBackupPlanVersionsResponse {
        val op = SdkHttpOperation.build<ListBackupPlanVersionsRequest, ListBackupPlanVersionsResponse> {
            serializer = ListBackupPlanVersionsOperationSerializer()
            deserializer = ListBackupPlanVersionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListBackupPlanVersions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "backup"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of all active backup plans for an authenticated account. The list contains information such as Amazon Resource Names (ARNs), plan IDs, creation and deletion dates, version IDs, plan names, and creator request IDs.
     */
    override suspend fun listBackupPlans(input: ListBackupPlansRequest): ListBackupPlansResponse {
        val op = SdkHttpOperation.build<ListBackupPlansRequest, ListBackupPlansResponse> {
            serializer = ListBackupPlansOperationSerializer()
            deserializer = ListBackupPlansOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListBackupPlans"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "backup"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns an array containing metadata of the resources associated with the target backup plan.
     */
    override suspend fun listBackupSelections(input: ListBackupSelectionsRequest): ListBackupSelectionsResponse {
        val op = SdkHttpOperation.build<ListBackupSelectionsRequest, ListBackupSelectionsResponse> {
            serializer = ListBackupSelectionsOperationSerializer()
            deserializer = ListBackupSelectionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListBackupSelections"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "backup"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of recovery point storage containers along with information about them.
     */
    override suspend fun listBackupVaults(input: ListBackupVaultsRequest): ListBackupVaultsResponse {
        val op = SdkHttpOperation.build<ListBackupVaultsRequest, ListBackupVaultsResponse> {
            serializer = ListBackupVaultsOperationSerializer()
            deserializer = ListBackupVaultsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListBackupVaults"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "backup"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns metadata about your copy jobs.
     */
    override suspend fun listCopyJobs(input: ListCopyJobsRequest): ListCopyJobsResponse {
        val op = SdkHttpOperation.build<ListCopyJobsRequest, ListCopyJobsResponse> {
            serializer = ListCopyJobsOperationSerializer()
            deserializer = ListCopyJobsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListCopyJobs"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "backup"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of all frameworks for an Amazon Web Services account and Amazon Web Services Region.
     */
    override suspend fun listFrameworks(input: ListFrameworksRequest): ListFrameworksResponse {
        val op = SdkHttpOperation.build<ListFrameworksRequest, ListFrameworksResponse> {
            serializer = ListFrameworksOperationSerializer()
            deserializer = ListFrameworksOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListFrameworks"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "backup"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns an array of resources successfully backed up by Backup, including the time the resource was saved, an Amazon Resource Name (ARN) of the resource, and a resource type.
     */
    override suspend fun listProtectedResources(input: ListProtectedResourcesRequest): ListProtectedResourcesResponse {
        val op = SdkHttpOperation.build<ListProtectedResourcesRequest, ListProtectedResourcesResponse> {
            serializer = ListProtectedResourcesOperationSerializer()
            deserializer = ListProtectedResourcesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListProtectedResources"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "backup"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns detailed information about the recovery points stored in a backup vault.
     */
    override suspend fun listRecoveryPointsByBackupVault(input: ListRecoveryPointsByBackupVaultRequest): ListRecoveryPointsByBackupVaultResponse {
        val op = SdkHttpOperation.build<ListRecoveryPointsByBackupVaultRequest, ListRecoveryPointsByBackupVaultResponse> {
            serializer = ListRecoveryPointsByBackupVaultOperationSerializer()
            deserializer = ListRecoveryPointsByBackupVaultOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListRecoveryPointsByBackupVault"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "backup"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns detailed information about all the recovery points of the type specified by a resource Amazon Resource Name (ARN).
     *
     * For Amazon EFS and Amazon EC2, this action only lists recovery points created by Backup.
     */
    override suspend fun listRecoveryPointsByResource(input: ListRecoveryPointsByResourceRequest): ListRecoveryPointsByResourceResponse {
        val op = SdkHttpOperation.build<ListRecoveryPointsByResourceRequest, ListRecoveryPointsByResourceResponse> {
            serializer = ListRecoveryPointsByResourceOperationSerializer()
            deserializer = ListRecoveryPointsByResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListRecoveryPointsByResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "backup"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns details about your report jobs.
     */
    override suspend fun listReportJobs(input: ListReportJobsRequest): ListReportJobsResponse {
        val op = SdkHttpOperation.build<ListReportJobsRequest, ListReportJobsResponse> {
            serializer = ListReportJobsOperationSerializer()
            deserializer = ListReportJobsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListReportJobs"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "backup"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of your report plans. For detailed information about a single report plan, use `DescribeReportPlan`.
     */
    override suspend fun listReportPlans(input: ListReportPlansRequest): ListReportPlansResponse {
        val op = SdkHttpOperation.build<ListReportPlansRequest, ListReportPlansResponse> {
            serializer = ListReportPlansOperationSerializer()
            deserializer = ListReportPlansOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListReportPlans"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "backup"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of jobs that Backup initiated to restore a saved resource, including details about the recovery process.
     */
    override suspend fun listRestoreJobs(input: ListRestoreJobsRequest): ListRestoreJobsResponse {
        val op = SdkHttpOperation.build<ListRestoreJobsRequest, ListRestoreJobsResponse> {
            serializer = ListRestoreJobsOperationSerializer()
            deserializer = ListRestoreJobsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListRestoreJobs"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "backup"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of key-value pairs assigned to a target recovery point, backup plan, or backup vault.
     *
     * `ListTags` only works for resource types that support full Backup management of their backups. Those resource types are listed in the "Full Backup management" section of the [ Feature availability by resource](https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html#features-by-resource) table.
     */
    override suspend fun listTags(input: ListTagsRequest): ListTagsResponse {
        val op = SdkHttpOperation.build<ListTagsRequest, ListTagsResponse> {
            serializer = ListTagsOperationSerializer()
            deserializer = ListTagsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTags"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "backup"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Sets a resource-based policy that is used to manage access permissions on the target backup vault. Requires a backup vault name and an access policy document in JSON format.
     */
    override suspend fun putBackupVaultAccessPolicy(input: PutBackupVaultAccessPolicyRequest): PutBackupVaultAccessPolicyResponse {
        val op = SdkHttpOperation.build<PutBackupVaultAccessPolicyRequest, PutBackupVaultAccessPolicyResponse> {
            serializer = PutBackupVaultAccessPolicyOperationSerializer()
            deserializer = PutBackupVaultAccessPolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutBackupVaultAccessPolicy"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "backup"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Applies Backup Vault Lock to a backup vault, preventing attempts to delete any recovery point stored in or created in a backup vault. Vault Lock also prevents attempts to update the lifecycle policy that controls the retention period of any recovery point currently stored in a backup vault. If specified, Vault Lock enforces a minimum and maximum retention period for future backup and copy jobs that target a backup vault.
     *
     * Backup Vault Lock has yet to receive a third-party assessment for SEC 17a-4(f) and CFTC.
     */
    override suspend fun putBackupVaultLockConfiguration(input: PutBackupVaultLockConfigurationRequest): PutBackupVaultLockConfigurationResponse {
        val op = SdkHttpOperation.build<PutBackupVaultLockConfigurationRequest, PutBackupVaultLockConfigurationResponse> {
            serializer = PutBackupVaultLockConfigurationOperationSerializer()
            deserializer = PutBackupVaultLockConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutBackupVaultLockConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "backup"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Turns on notifications on a backup vault for the specified topic and events.
     */
    override suspend fun putBackupVaultNotifications(input: PutBackupVaultNotificationsRequest): PutBackupVaultNotificationsResponse {
        val op = SdkHttpOperation.build<PutBackupVaultNotificationsRequest, PutBackupVaultNotificationsResponse> {
            serializer = PutBackupVaultNotificationsOperationSerializer()
            deserializer = PutBackupVaultNotificationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutBackupVaultNotifications"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "backup"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Starts an on-demand backup job for the specified resource.
     */
    override suspend fun startBackupJob(input: StartBackupJobRequest): StartBackupJobResponse {
        val op = SdkHttpOperation.build<StartBackupJobRequest, StartBackupJobResponse> {
            serializer = StartBackupJobOperationSerializer()
            deserializer = StartBackupJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartBackupJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "backup"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Starts a job to create a one-time copy of the specified resource.
     *
     * Does not support continuous backups.
     */
    override suspend fun startCopyJob(input: StartCopyJobRequest): StartCopyJobResponse {
        val op = SdkHttpOperation.build<StartCopyJobRequest, StartCopyJobResponse> {
            serializer = StartCopyJobOperationSerializer()
            deserializer = StartCopyJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartCopyJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "backup"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Starts an on-demand report job for the specified report plan.
     */
    override suspend fun startReportJob(input: StartReportJobRequest): StartReportJobResponse {
        val op = SdkHttpOperation.build<StartReportJobRequest, StartReportJobResponse> {
            serializer = StartReportJobOperationSerializer()
            deserializer = StartReportJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartReportJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "backup"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Recovers the saved resource identified by an Amazon Resource Name (ARN).
     */
    override suspend fun startRestoreJob(input: StartRestoreJobRequest): StartRestoreJobResponse {
        val op = SdkHttpOperation.build<StartRestoreJobRequest, StartRestoreJobResponse> {
            serializer = StartRestoreJobOperationSerializer()
            deserializer = StartRestoreJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartRestoreJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "backup"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Attempts to cancel a job to create a one-time backup of a resource.
     */
    override suspend fun stopBackupJob(input: StopBackupJobRequest): StopBackupJobResponse {
        val op = SdkHttpOperation.build<StopBackupJobRequest, StopBackupJobResponse> {
            serializer = StopBackupJobOperationSerializer()
            deserializer = StopBackupJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StopBackupJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "backup"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Assigns a set of key-value pairs to a recovery point, backup plan, or backup vault identified by an Amazon Resource Name (ARN).
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "backup"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes a set of key-value pairs from a recovery point, backup plan, or backup vault identified by an Amazon Resource Name (ARN)
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UntagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "backup"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates an existing backup plan identified by its `backupPlanId` with the input document in JSON format. The new version is uniquely identified by a `VersionId`.
     */
    override suspend fun updateBackupPlan(input: UpdateBackupPlanRequest): UpdateBackupPlanResponse {
        val op = SdkHttpOperation.build<UpdateBackupPlanRequest, UpdateBackupPlanResponse> {
            serializer = UpdateBackupPlanOperationSerializer()
            deserializer = UpdateBackupPlanOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateBackupPlan"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "backup"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates an existing framework identified by its `FrameworkName` with the input document in JSON format.
     */
    override suspend fun updateFramework(input: UpdateFrameworkRequest): UpdateFrameworkResponse {
        val op = SdkHttpOperation.build<UpdateFrameworkRequest, UpdateFrameworkResponse> {
            serializer = UpdateFrameworkOperationSerializer()
            deserializer = UpdateFrameworkOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateFramework"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "backup"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates whether the Amazon Web Services account is opted in to cross-account backup. Returns an error if the account is not an Organizations management account. Use the `DescribeGlobalSettings` API to determine the current settings.
     */
    override suspend fun updateGlobalSettings(input: UpdateGlobalSettingsRequest): UpdateGlobalSettingsResponse {
        val op = SdkHttpOperation.build<UpdateGlobalSettingsRequest, UpdateGlobalSettingsResponse> {
            serializer = UpdateGlobalSettingsOperationSerializer()
            deserializer = UpdateGlobalSettingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateGlobalSettings"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "backup"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Sets the transition lifecycle of a recovery point.
     *
     * The lifecycle defines when a protected resource is transitioned to cold storage and when it expires. Backup transitions and expires backups automatically according to the lifecycle that you define.
     *
     * Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days. Therefore, the “retention” setting must be 90 days greater than the “transition to cold after days” setting. The “transition to cold after days” setting cannot be changed after a backup has been transitioned to cold.
     *
     * Only resource types that support full Backup management can transition their backups to cold storage. Those resource types are listed in the "Full Backup management" section of the [ Feature availability by resource](https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html#features-by-resource) table. Backup ignores this expression for other resource types.
     *
     * This operation does not support continuous backups.
     */
    override suspend fun updateRecoveryPointLifecycle(input: UpdateRecoveryPointLifecycleRequest): UpdateRecoveryPointLifecycleResponse {
        val op = SdkHttpOperation.build<UpdateRecoveryPointLifecycleRequest, UpdateRecoveryPointLifecycleResponse> {
            serializer = UpdateRecoveryPointLifecycleOperationSerializer()
            deserializer = UpdateRecoveryPointLifecycleOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateRecoveryPointLifecycle"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "backup"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the current service opt-in settings for the Region. If service-opt-in is enabled for a service, Backup tries to protect that service's resources in this Region, when the resource is included in an on-demand backup or scheduled backup plan. Otherwise, Backup does not try to protect that service's resources in this Region. Use the `DescribeRegionSettings` API to determine the resource types that are supported.
     */
    override suspend fun updateRegionSettings(input: UpdateRegionSettingsRequest): UpdateRegionSettingsResponse {
        val op = SdkHttpOperation.build<UpdateRegionSettingsRequest, UpdateRegionSettingsResponse> {
            serializer = UpdateRegionSettingsOperationSerializer()
            deserializer = UpdateRegionSettingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateRegionSettings"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "backup"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates an existing report plan identified by its `ReportPlanName` with the input document in JSON format.
     */
    override suspend fun updateReportPlan(input: UpdateReportPlanRequest): UpdateReportPlanResponse {
        val op = SdkHttpOperation.build<UpdateReportPlanRequest, UpdateReportPlanResponse> {
            serializer = UpdateReportPlanOperationSerializer()
            deserializer = UpdateReportPlanOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateReportPlan"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "backup"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "backup")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
        config.idempotencyTokenProvider?.let { ctx[SdkClientOption.IdempotencyTokenProvider] = it }
    }
}
