// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.model



/**
 * Contains an optional backup plan display name and an array of `BackupRule` objects, each of which specifies a backup rule. Each rule in a backup plan is a separate scheduled task and can back up a different selection of Amazon Web Services resources.
 */
class BackupPlan private constructor(builder: Builder) {
    /**
     * Contains a list of `BackupOptions` for each resource type.
     */
    val advancedBackupSettings: List<AdvancedBackupSetting>? = builder.advancedBackupSettings
    /**
     * The display name of a backup plan. Must contain 1 to 50 alphanumeric or '-_.' characters.
     */
    val backupPlanName: kotlin.String? = builder.backupPlanName
    /**
     * An array of `BackupRule` objects, each of which specifies a scheduled task that is used to back up a selection of resources.
     */
    val rules: List<BackupRule>? = builder.rules

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.backup.model.BackupPlan = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BackupPlan(")
        append("advancedBackupSettings=$advancedBackupSettings,")
        append("backupPlanName=$backupPlanName,")
        append("rules=$rules)")
    }

    override fun hashCode(): kotlin.Int {
        var result = advancedBackupSettings?.hashCode() ?: 0
        result = 31 * result + (backupPlanName?.hashCode() ?: 0)
        result = 31 * result + (rules?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BackupPlan

        if (advancedBackupSettings != other.advancedBackupSettings) return false
        if (backupPlanName != other.backupPlanName) return false
        if (rules != other.rules) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.backup.model.BackupPlan = Builder(this).apply(block).build()

    class Builder {
        /**
         * Contains a list of `BackupOptions` for each resource type.
         */
        var advancedBackupSettings: List<AdvancedBackupSetting>? = null
        /**
         * The display name of a backup plan. Must contain 1 to 50 alphanumeric or '-_.' characters.
         */
        var backupPlanName: kotlin.String? = null
        /**
         * An array of `BackupRule` objects, each of which specifies a scheduled task that is used to back up a selection of resources.
         */
        var rules: List<BackupRule>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.backup.model.BackupPlan) : this() {
            this.advancedBackupSettings = x.advancedBackupSettings
            this.backupPlanName = x.backupPlanName
            this.rules = x.rules
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.backup.model.BackupPlan = BackupPlan(this)
    }
}
