// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.model



/**
 * Used to specify a set of resources to a backup plan.
 */
class BackupSelection private constructor(builder: Builder) {
    /**
     * A list of conditions that you define to assign resources to your backup plans using tags. For example, `"StringEquals": {"Department": "accounting"`. Condition operators are case sensitive.
     *
     * `Conditions` differs from `ListOfTags` as follows:
     * + When you specify more than one condition, you only assign the resources that match ALL conditions (using AND logic).
     * + `Conditions` supports `StringEquals`, `StringLike`, `StringNotEquals`, and `StringNotLike`. `ListOfTags` only supports `StringEquals`.
     */
    val conditions: aws.sdk.kotlin.services.backup.model.Conditions? = builder.conditions
    /**
     * The ARN of the IAM role that Backup uses to authenticate when backing up the target resource; for example, `arn:aws:iam::123456789012:role/S3Access`.
     */
    val iamRoleArn: kotlin.String? = builder.iamRoleArn
    /**
     * A list of conditions that you define to assign resources to your backup plans using tags. For example, `"StringEquals": {"Department": "accounting"`. Condition operators are case sensitive.
     *
     * `ListOfTags` differs from `Conditions` as follows:
     * + When you specify more than one condition, you assign all resources that match AT LEAST ONE condition (using OR logic).
     * + `ListOfTags` only supports `StringEquals`. `Conditions` supports `StringEquals`, `StringLike`, `StringNotEquals`, and `StringNotLike`.
     */
    val listOfTags: List<Condition>? = builder.listOfTags
    /**
     * A list of Amazon Resource Names (ARNs) to exclude from a backup plan. The maximum number of ARNs is 500 without wildcards, or 30 ARNs with wildcards.
     *
     * If you need to exclude many resources from a backup plan, consider a different resource selection strategy, such as assigning only one or a few resource types or refining your resource selection using tags.
     */
    val notResources: List<String>? = builder.notResources
    /**
     * A list of Amazon Resource Names (ARNs) to assign to a backup plan. The maximum number of ARNs is 500 without wildcards, or 30 ARNs with wildcards.
     *
     * If you need to assign many resources to a backup plan, consider a different resource selection strategy, such as assigning all resources of a resource type or refining your resource selection using tags.
     */
    val resources: List<String>? = builder.resources
    /**
     * The display name of a resource selection document. Must contain 1 to 50 alphanumeric or '-_.' characters.
     */
    val selectionName: kotlin.String? = builder.selectionName

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.backup.model.BackupSelection = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BackupSelection(")
        append("conditions=$conditions,")
        append("iamRoleArn=$iamRoleArn,")
        append("listOfTags=$listOfTags,")
        append("notResources=$notResources,")
        append("resources=$resources,")
        append("selectionName=$selectionName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = conditions?.hashCode() ?: 0
        result = 31 * result + (iamRoleArn?.hashCode() ?: 0)
        result = 31 * result + (listOfTags?.hashCode() ?: 0)
        result = 31 * result + (notResources?.hashCode() ?: 0)
        result = 31 * result + (resources?.hashCode() ?: 0)
        result = 31 * result + (selectionName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BackupSelection

        if (conditions != other.conditions) return false
        if (iamRoleArn != other.iamRoleArn) return false
        if (listOfTags != other.listOfTags) return false
        if (notResources != other.notResources) return false
        if (resources != other.resources) return false
        if (selectionName != other.selectionName) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.backup.model.BackupSelection = Builder(this).apply(block).build()

    class Builder {
        /**
         * A list of conditions that you define to assign resources to your backup plans using tags. For example, `"StringEquals": {"Department": "accounting"`. Condition operators are case sensitive.
         *
         * `Conditions` differs from `ListOfTags` as follows:
         * + When you specify more than one condition, you only assign the resources that match ALL conditions (using AND logic).
         * + `Conditions` supports `StringEquals`, `StringLike`, `StringNotEquals`, and `StringNotLike`. `ListOfTags` only supports `StringEquals`.
         */
        var conditions: aws.sdk.kotlin.services.backup.model.Conditions? = null
        /**
         * The ARN of the IAM role that Backup uses to authenticate when backing up the target resource; for example, `arn:aws:iam::123456789012:role/S3Access`.
         */
        var iamRoleArn: kotlin.String? = null
        /**
         * A list of conditions that you define to assign resources to your backup plans using tags. For example, `"StringEquals": {"Department": "accounting"`. Condition operators are case sensitive.
         *
         * `ListOfTags` differs from `Conditions` as follows:
         * + When you specify more than one condition, you assign all resources that match AT LEAST ONE condition (using OR logic).
         * + `ListOfTags` only supports `StringEquals`. `Conditions` supports `StringEquals`, `StringLike`, `StringNotEquals`, and `StringNotLike`.
         */
        var listOfTags: List<Condition>? = null
        /**
         * A list of Amazon Resource Names (ARNs) to exclude from a backup plan. The maximum number of ARNs is 500 without wildcards, or 30 ARNs with wildcards.
         *
         * If you need to exclude many resources from a backup plan, consider a different resource selection strategy, such as assigning only one or a few resource types or refining your resource selection using tags.
         */
        var notResources: List<String>? = null
        /**
         * A list of Amazon Resource Names (ARNs) to assign to a backup plan. The maximum number of ARNs is 500 without wildcards, or 30 ARNs with wildcards.
         *
         * If you need to assign many resources to a backup plan, consider a different resource selection strategy, such as assigning all resources of a resource type or refining your resource selection using tags.
         */
        var resources: List<String>? = null
        /**
         * The display name of a resource selection document. Must contain 1 to 50 alphanumeric or '-_.' characters.
         */
        var selectionName: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.backup.model.BackupSelection) : this() {
            this.conditions = x.conditions
            this.iamRoleArn = x.iamRoleArn
            this.listOfTags = x.listOfTags
            this.notResources = x.notResources
            this.resources = x.resources
            this.selectionName = x.selectionName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.backup.model.BackupSelection = BackupSelection(this)

        /**
         * construct an [aws.sdk.kotlin.services.backup.model.Conditions] inside the given [block]
         */
        fun conditions(block: aws.sdk.kotlin.services.backup.model.Conditions.Builder.() -> kotlin.Unit) {
            this.conditions = aws.sdk.kotlin.services.backup.model.Conditions.invoke(block)
        }
    }
}
