// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.model



class CreateBackupVaultRequest private constructor(builder: Builder) {
    /**
     * The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Amazon Web Services Region where they are created. They consist of letters, numbers, and hyphens.
     */
    val backupVaultName: kotlin.String? = requireNotNull(builder.backupVaultName) { "A non-null value must be provided for backupVaultName" }
    /**
     * Metadata that you can assign to help organize the resources that you create. Each tag is a key-value pair.
     */
    val backupVaultTags: Map<String, String>? = builder.backupVaultTags
    /**
     * A unique string that identifies the request and allows failed requests to be retried without the risk of running the operation twice. This parameter is optional.
     *
     * If used, this parameter must contain 1 to 50 alphanumeric or '-_.' characters.
     */
    val creatorRequestId: kotlin.String? = builder.creatorRequestId
    /**
     * The server-side encryption key that is used to protect your backups; for example, `arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`.
     */
    val encryptionKeyArn: kotlin.String? = builder.encryptionKeyArn

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.backup.model.CreateBackupVaultRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateBackupVaultRequest(")
        append("backupVaultName=$backupVaultName,")
        append("backupVaultTags=*** Sensitive Data Redacted ***,")
        append("creatorRequestId=$creatorRequestId,")
        append("encryptionKeyArn=$encryptionKeyArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = backupVaultName?.hashCode() ?: 0
        result = 31 * result + (backupVaultTags?.hashCode() ?: 0)
        result = 31 * result + (creatorRequestId?.hashCode() ?: 0)
        result = 31 * result + (encryptionKeyArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateBackupVaultRequest

        if (backupVaultName != other.backupVaultName) return false
        if (backupVaultTags != other.backupVaultTags) return false
        if (creatorRequestId != other.creatorRequestId) return false
        if (encryptionKeyArn != other.encryptionKeyArn) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.backup.model.CreateBackupVaultRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Amazon Web Services Region where they are created. They consist of letters, numbers, and hyphens.
         */
        var backupVaultName: kotlin.String? = null
        /**
         * Metadata that you can assign to help organize the resources that you create. Each tag is a key-value pair.
         */
        var backupVaultTags: Map<String, String>? = null
        /**
         * A unique string that identifies the request and allows failed requests to be retried without the risk of running the operation twice. This parameter is optional.
         *
         * If used, this parameter must contain 1 to 50 alphanumeric or '-_.' characters.
         */
        var creatorRequestId: kotlin.String? = null
        /**
         * The server-side encryption key that is used to protect your backups; for example, `arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`.
         */
        var encryptionKeyArn: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.backup.model.CreateBackupVaultRequest) : this() {
            this.backupVaultName = x.backupVaultName
            this.backupVaultTags = x.backupVaultTags
            this.creatorRequestId = x.creatorRequestId
            this.encryptionKeyArn = x.encryptionKeyArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.backup.model.CreateBackupVaultRequest = CreateBackupVaultRequest(this)
    }
}
