// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.model



/**
 * Contains an array of `Transition` objects specifying how long in days before a recovery point transitions to cold storage or is deleted.
 *
 * Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days. Therefore, on the console, the “retention” setting must be 90 days greater than the “transition to cold after days” setting. The “transition to cold after days” setting cannot be changed after a backup has been transitioned to cold.
 *
 * Only resource types that support full Backup management can transition their backups to cold storage. Those resource types are listed in the "Full Backup management" section of the [ Feature availability by resource](https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html#features-by-resource) table. Backup ignores this expression for other resource types.
 */
class Lifecycle private constructor(builder: Builder) {
    /**
     * Specifies the number of days after creation that a recovery point is deleted. Must be greater than 90 days plus `MoveToColdStorageAfterDays`.
     */
    val deleteAfterDays: kotlin.Long? = builder.deleteAfterDays
    /**
     * Specifies the number of days after creation that a recovery point is moved to cold storage.
     */
    val moveToColdStorageAfterDays: kotlin.Long? = builder.moveToColdStorageAfterDays

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.backup.model.Lifecycle = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Lifecycle(")
        append("deleteAfterDays=$deleteAfterDays,")
        append("moveToColdStorageAfterDays=$moveToColdStorageAfterDays)")
    }

    override fun hashCode(): kotlin.Int {
        var result = deleteAfterDays?.hashCode() ?: 0
        result = 31 * result + (moveToColdStorageAfterDays?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Lifecycle

        if (deleteAfterDays != other.deleteAfterDays) return false
        if (moveToColdStorageAfterDays != other.moveToColdStorageAfterDays) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.backup.model.Lifecycle = Builder(this).apply(block).build()

    class Builder {
        /**
         * Specifies the number of days after creation that a recovery point is deleted. Must be greater than 90 days plus `MoveToColdStorageAfterDays`.
         */
        var deleteAfterDays: kotlin.Long? = null
        /**
         * Specifies the number of days after creation that a recovery point is moved to cold storage.
         */
        var moveToColdStorageAfterDays: kotlin.Long? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.backup.model.Lifecycle) : this() {
            this.deleteAfterDays = x.deleteAfterDays
            this.moveToColdStorageAfterDays = x.moveToColdStorageAfterDays
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.backup.model.Lifecycle = Lifecycle(this)
    }
}
