// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains detailed information about a saved recovery point.
 */
public class RecoveryPointByResource private constructor(builder: Builder) {
    /**
     * The size, in bytes, of a backup.
     */
    public val backupSizeBytes: kotlin.Long? = builder.backupSizeBytes
    /**
     * The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Amazon Web Services Region where they are created. They consist of lowercase letters, numbers, and hyphens.
     */
    public val backupVaultName: kotlin.String? = builder.backupVaultName
    /**
     * The date and time a recovery point is created, in Unix format and Coordinated Universal Time (UTC). The value of `CreationDate` is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public val creationDate: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDate
    /**
     * The server-side encryption key that is used to protect your backups; for example, `arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`.
     */
    public val encryptionKeyArn: kotlin.String? = builder.encryptionKeyArn
    /**
     * An Amazon Resource Name (ARN) that uniquely identifies a recovery point; for example, `arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45`.
     */
    public val recoveryPointArn: kotlin.String? = builder.recoveryPointArn
    /**
     * A status code specifying the state of the recovery point.
     */
    public val status: aws.sdk.kotlin.services.backup.model.RecoveryPointStatus? = builder.status
    /**
     * A message explaining the reason of the recovery point deletion failure.
     */
    public val statusMessage: kotlin.String? = builder.statusMessage

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.backup.model.RecoveryPointByResource = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RecoveryPointByResource(")
        append("backupSizeBytes=$backupSizeBytes,")
        append("backupVaultName=$backupVaultName,")
        append("creationDate=$creationDate,")
        append("encryptionKeyArn=$encryptionKeyArn,")
        append("recoveryPointArn=$recoveryPointArn,")
        append("status=$status,")
        append("statusMessage=$statusMessage)")
    }

    override fun hashCode(): kotlin.Int {
        var result = backupSizeBytes?.hashCode() ?: 0
        result = 31 * result + (backupVaultName?.hashCode() ?: 0)
        result = 31 * result + (creationDate?.hashCode() ?: 0)
        result = 31 * result + (encryptionKeyArn?.hashCode() ?: 0)
        result = 31 * result + (recoveryPointArn?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusMessage?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RecoveryPointByResource

        if (backupSizeBytes != other.backupSizeBytes) return false
        if (backupVaultName != other.backupVaultName) return false
        if (creationDate != other.creationDate) return false
        if (encryptionKeyArn != other.encryptionKeyArn) return false
        if (recoveryPointArn != other.recoveryPointArn) return false
        if (status != other.status) return false
        if (statusMessage != other.statusMessage) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.backup.model.RecoveryPointByResource = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The size, in bytes, of a backup.
         */
        public var backupSizeBytes: kotlin.Long? = null
        /**
         * The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Amazon Web Services Region where they are created. They consist of lowercase letters, numbers, and hyphens.
         */
        public var backupVaultName: kotlin.String? = null
        /**
         * The date and time a recovery point is created, in Unix format and Coordinated Universal Time (UTC). The value of `CreationDate` is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         */
        public var creationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The server-side encryption key that is used to protect your backups; for example, `arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`.
         */
        public var encryptionKeyArn: kotlin.String? = null
        /**
         * An Amazon Resource Name (ARN) that uniquely identifies a recovery point; for example, `arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45`.
         */
        public var recoveryPointArn: kotlin.String? = null
        /**
         * A status code specifying the state of the recovery point.
         */
        public var status: aws.sdk.kotlin.services.backup.model.RecoveryPointStatus? = null
        /**
         * A message explaining the reason of the recovery point deletion failure.
         */
        public var statusMessage: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.backup.model.RecoveryPointByResource) : this() {
            this.backupSizeBytes = x.backupSizeBytes
            this.backupVaultName = x.backupVaultName
            this.creationDate = x.creationDate
            this.encryptionKeyArn = x.encryptionKeyArn
            this.recoveryPointArn = x.recoveryPointArn
            this.status = x.status
            this.statusMessage = x.statusMessage
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.backup.model.RecoveryPointByResource = RecoveryPointByResource(this)
    }
}
