// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.model



/**
 * Contains information about the backup plan and rule that Backup used to initiate the recovery point backup.
 */
public class RecoveryPointCreator private constructor(builder: Builder) {
    /**
     * An Amazon Resource Name (ARN) that uniquely identifies a backup plan; for example, `arn:aws:backup:us-east-1:123456789012:plan:8F81F553-3A74-4A3F-B93D-B3360DC80C50`.
     */
    public val backupPlanArn: kotlin.String? = builder.backupPlanArn
    /**
     * Uniquely identifies a backup plan.
     */
    public val backupPlanId: kotlin.String? = builder.backupPlanId
    /**
     * Version IDs are unique, randomly generated, Unicode, UTF-8 encoded strings that are at most 1,024 bytes long. They cannot be edited.
     */
    public val backupPlanVersion: kotlin.String? = builder.backupPlanVersion
    /**
     * Uniquely identifies a rule used to schedule the backup of a selection of resources.
     */
    public val backupRuleId: kotlin.String? = builder.backupRuleId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.backup.model.RecoveryPointCreator = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RecoveryPointCreator(")
        append("backupPlanArn=$backupPlanArn,")
        append("backupPlanId=$backupPlanId,")
        append("backupPlanVersion=$backupPlanVersion,")
        append("backupRuleId=$backupRuleId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = backupPlanArn?.hashCode() ?: 0
        result = 31 * result + (backupPlanId?.hashCode() ?: 0)
        result = 31 * result + (backupPlanVersion?.hashCode() ?: 0)
        result = 31 * result + (backupRuleId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RecoveryPointCreator

        if (backupPlanArn != other.backupPlanArn) return false
        if (backupPlanId != other.backupPlanId) return false
        if (backupPlanVersion != other.backupPlanVersion) return false
        if (backupRuleId != other.backupRuleId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.backup.model.RecoveryPointCreator = Builder(this).apply(block).build()

    public class Builder {
        /**
         * An Amazon Resource Name (ARN) that uniquely identifies a backup plan; for example, `arn:aws:backup:us-east-1:123456789012:plan:8F81F553-3A74-4A3F-B93D-B3360DC80C50`.
         */
        public var backupPlanArn: kotlin.String? = null
        /**
         * Uniquely identifies a backup plan.
         */
        public var backupPlanId: kotlin.String? = null
        /**
         * Version IDs are unique, randomly generated, Unicode, UTF-8 encoded strings that are at most 1,024 bytes long. They cannot be edited.
         */
        public var backupPlanVersion: kotlin.String? = null
        /**
         * Uniquely identifies a rule used to schedule the backup of a selection of resources.
         */
        public var backupRuleId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.backup.model.RecoveryPointCreator) : this() {
            this.backupPlanArn = x.backupPlanArn
            this.backupPlanId = x.backupPlanId
            this.backupPlanVersion = x.backupPlanVersion
            this.backupRuleId = x.backupRuleId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.backup.model.RecoveryPointCreator = RecoveryPointCreator(this)
    }
}
