// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.model



/**
 * Contains an optional backup plan display name and an array of `BackupRule` objects, each of which specifies a backup rule. Each rule in a backup plan is a separate scheduled task.
 */
public class BackupPlanInput private constructor(builder: Builder) {
    /**
     * Specifies a list of `BackupOptions` for each resource type. These settings are only available for Windows Volume Shadow Copy Service (VSS) backup jobs.
     */
    public val advancedBackupSettings: List<AdvancedBackupSetting>? = builder.advancedBackupSettings
    /**
     * The display name of a backup plan. Must contain 1 to 50 alphanumeric or '-_.' characters.
     */
    public val backupPlanName: kotlin.String? = builder.backupPlanName
    /**
     * An array of `BackupRule` objects, each of which specifies a scheduled task that is used to back up a selection of resources.
     */
    public val rules: List<BackupRuleInput>? = builder.rules

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.backup.model.BackupPlanInput = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BackupPlanInput(")
        append("advancedBackupSettings=$advancedBackupSettings,")
        append("backupPlanName=$backupPlanName,")
        append("rules=$rules")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = advancedBackupSettings?.hashCode() ?: 0
        result = 31 * result + (backupPlanName?.hashCode() ?: 0)
        result = 31 * result + (rules?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BackupPlanInput

        if (advancedBackupSettings != other.advancedBackupSettings) return false
        if (backupPlanName != other.backupPlanName) return false
        if (rules != other.rules) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.backup.model.BackupPlanInput = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies a list of `BackupOptions` for each resource type. These settings are only available for Windows Volume Shadow Copy Service (VSS) backup jobs.
         */
        public var advancedBackupSettings: List<AdvancedBackupSetting>? = null
        /**
         * The display name of a backup plan. Must contain 1 to 50 alphanumeric or '-_.' characters.
         */
        public var backupPlanName: kotlin.String? = null
        /**
         * An array of `BackupRule` objects, each of which specifies a scheduled task that is used to back up a selection of resources.
         */
        public var rules: List<BackupRuleInput>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.backup.model.BackupPlanInput) : this() {
            this.advancedBackupSettings = x.advancedBackupSettings
            this.backupPlanName = x.backupPlanName
            this.rules = x.rules
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.backup.model.BackupPlanInput = BackupPlanInput(this)
    }
}
