// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.model



/**
 * Specifies a scheduled task used to back up a selection of resources.
 */
public class BackupRuleInput private constructor(builder: Builder) {
    /**
     * A value in minutes after a backup job is successfully started before it must be completed or it will be canceled by Backup. This value is optional.
     */
    public val completionWindowMinutes: kotlin.Long? = builder.completionWindowMinutes
    /**
     * An array of `CopyAction` objects, which contains the details of the copy operation.
     */
    public val copyActions: List<CopyAction>? = builder.copyActions
    /**
     * Specifies whether Backup creates continuous backups. True causes Backup to create continuous backups capable of point-in-time restore (PITR). False (or not specified) causes Backup to create snapshot backups.
     */
    public val enableContinuousBackup: kotlin.Boolean? = builder.enableContinuousBackup
    /**
     * The lifecycle defines when a protected resource is transitioned to cold storage and when it expires. Backup will transition and expire backups automatically according to the lifecycle that you define.
     *
     * Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days. Therefore, the “retention” setting must be 90 days greater than the “transition to cold after days” setting. The “transition to cold after days” setting cannot be changed after a backup has been transitioned to cold.
     *
     * Resource types that are able to be transitioned to cold storage are listed in the "Lifecycle to cold storage" section of the [ Feature availability by resource](https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html#features-by-resource) table. Backup ignores this expression for other resource types.
     */
    public val lifecycle: aws.sdk.kotlin.services.backup.model.Lifecycle? = builder.lifecycle
    /**
     * To help organize your resources, you can assign your own metadata to the resources that you create. Each tag is a key-value pair.
     */
    public val recoveryPointTags: Map<String, String>? = builder.recoveryPointTags
    /**
     * A display name for a backup rule. Must contain 1 to 50 alphanumeric or '-_.' characters.
     */
    public val ruleName: kotlin.String? = builder.ruleName
    /**
     * A CRON expression in UTC specifying when Backup initiates a backup job.
     */
    public val scheduleExpression: kotlin.String? = builder.scheduleExpression
    /**
     * A value in minutes after a backup is scheduled before a job will be canceled if it doesn't start successfully. This value is optional. If this value is included, it must be at least 60 minutes to avoid errors.
     */
    public val startWindowMinutes: kotlin.Long? = builder.startWindowMinutes
    /**
     * The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Amazon Web Services Region where they are created. They consist of lowercase letters, numbers, and hyphens.
     */
    public val targetBackupVaultName: kotlin.String? = builder.targetBackupVaultName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.backup.model.BackupRuleInput = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BackupRuleInput(")
        append("completionWindowMinutes=$completionWindowMinutes,")
        append("copyActions=$copyActions,")
        append("enableContinuousBackup=$enableContinuousBackup,")
        append("lifecycle=$lifecycle,")
        append("recoveryPointTags=*** Sensitive Data Redacted ***,")
        append("ruleName=$ruleName,")
        append("scheduleExpression=$scheduleExpression,")
        append("startWindowMinutes=$startWindowMinutes,")
        append("targetBackupVaultName=$targetBackupVaultName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = completionWindowMinutes?.hashCode() ?: 0
        result = 31 * result + (copyActions?.hashCode() ?: 0)
        result = 31 * result + (enableContinuousBackup?.hashCode() ?: 0)
        result = 31 * result + (lifecycle?.hashCode() ?: 0)
        result = 31 * result + (recoveryPointTags?.hashCode() ?: 0)
        result = 31 * result + (ruleName?.hashCode() ?: 0)
        result = 31 * result + (scheduleExpression?.hashCode() ?: 0)
        result = 31 * result + (startWindowMinutes?.hashCode() ?: 0)
        result = 31 * result + (targetBackupVaultName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BackupRuleInput

        if (completionWindowMinutes != other.completionWindowMinutes) return false
        if (copyActions != other.copyActions) return false
        if (enableContinuousBackup != other.enableContinuousBackup) return false
        if (lifecycle != other.lifecycle) return false
        if (recoveryPointTags != other.recoveryPointTags) return false
        if (ruleName != other.ruleName) return false
        if (scheduleExpression != other.scheduleExpression) return false
        if (startWindowMinutes != other.startWindowMinutes) return false
        if (targetBackupVaultName != other.targetBackupVaultName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.backup.model.BackupRuleInput = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A value in minutes after a backup job is successfully started before it must be completed or it will be canceled by Backup. This value is optional.
         */
        public var completionWindowMinutes: kotlin.Long? = null
        /**
         * An array of `CopyAction` objects, which contains the details of the copy operation.
         */
        public var copyActions: List<CopyAction>? = null
        /**
         * Specifies whether Backup creates continuous backups. True causes Backup to create continuous backups capable of point-in-time restore (PITR). False (or not specified) causes Backup to create snapshot backups.
         */
        public var enableContinuousBackup: kotlin.Boolean? = null
        /**
         * The lifecycle defines when a protected resource is transitioned to cold storage and when it expires. Backup will transition and expire backups automatically according to the lifecycle that you define.
         *
         * Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days. Therefore, the “retention” setting must be 90 days greater than the “transition to cold after days” setting. The “transition to cold after days” setting cannot be changed after a backup has been transitioned to cold.
         *
         * Resource types that are able to be transitioned to cold storage are listed in the "Lifecycle to cold storage" section of the [ Feature availability by resource](https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html#features-by-resource) table. Backup ignores this expression for other resource types.
         */
        public var lifecycle: aws.sdk.kotlin.services.backup.model.Lifecycle? = null
        /**
         * To help organize your resources, you can assign your own metadata to the resources that you create. Each tag is a key-value pair.
         */
        public var recoveryPointTags: Map<String, String>? = null
        /**
         * A display name for a backup rule. Must contain 1 to 50 alphanumeric or '-_.' characters.
         */
        public var ruleName: kotlin.String? = null
        /**
         * A CRON expression in UTC specifying when Backup initiates a backup job.
         */
        public var scheduleExpression: kotlin.String? = null
        /**
         * A value in minutes after a backup is scheduled before a job will be canceled if it doesn't start successfully. This value is optional. If this value is included, it must be at least 60 minutes to avoid errors.
         */
        public var startWindowMinutes: kotlin.Long? = null
        /**
         * The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Amazon Web Services Region where they are created. They consist of lowercase letters, numbers, and hyphens.
         */
        public var targetBackupVaultName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.backup.model.BackupRuleInput) : this() {
            this.completionWindowMinutes = x.completionWindowMinutes
            this.copyActions = x.copyActions
            this.enableContinuousBackup = x.enableContinuousBackup
            this.lifecycle = x.lifecycle
            this.recoveryPointTags = x.recoveryPointTags
            this.ruleName = x.ruleName
            this.scheduleExpression = x.scheduleExpression
            this.startWindowMinutes = x.startWindowMinutes
            this.targetBackupVaultName = x.targetBackupVaultName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.backup.model.BackupRuleInput = BackupRuleInput(this)

        /**
         * construct an [aws.sdk.kotlin.services.backup.model.Lifecycle] inside the given [block]
         */
        public fun lifecycle(block: aws.sdk.kotlin.services.backup.model.Lifecycle.Builder.() -> kotlin.Unit) {
            this.lifecycle = aws.sdk.kotlin.services.backup.model.Lifecycle.invoke(block)
        }
    }
}
