// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.model

import aws.smithy.kotlin.runtime.time.Instant

public class DescribeRecoveryPointResponse private constructor(builder: Builder) {
    /**
     * The size, in bytes, of a backup.
     */
    public val backupSizeInBytes: kotlin.Long? = builder.backupSizeInBytes
    /**
     * An ARN that uniquely identifies a backup vault; for example, `arn:aws:backup:us-east-1:123456789012:vault:aBackupVault`.
     */
    public val backupVaultArn: kotlin.String? = builder.backupVaultArn
    /**
     * The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Region where they are created. They consist of lowercase letters, numbers, and hyphens.
     */
    public val backupVaultName: kotlin.String? = builder.backupVaultName
    /**
     * A `CalculatedLifecycle` object containing `DeleteAt` and `MoveToColdStorageAt` timestamps.
     */
    public val calculatedLifecycle: aws.sdk.kotlin.services.backup.model.CalculatedLifecycle? = builder.calculatedLifecycle
    /**
     * The date and time that a job to create a recovery point is completed, in Unix format and Coordinated Universal Time (UTC). The value of `CompletionDate` is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public val completionDate: aws.smithy.kotlin.runtime.time.Instant? = builder.completionDate
    /**
     * This is the identifier of a resource within a composite group, such as nested (child) recovery point belonging to a composite (parent) stack. The ID is transferred from the [ logical ID](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/resources-section-structure.html#resources-section-structure-syntax) within a stack.
     */
    public val compositeMemberIdentifier: kotlin.String? = builder.compositeMemberIdentifier
    /**
     * Contains identifying information about the creation of a recovery point, including the `BackupPlanArn`, `BackupPlanId`, `BackupPlanVersion`, and `BackupRuleId` of the backup plan used to create it.
     */
    public val createdBy: aws.sdk.kotlin.services.backup.model.RecoveryPointCreator? = builder.createdBy
    /**
     * The date and time that a recovery point is created, in Unix format and Coordinated Universal Time (UTC). The value of `CreationDate` is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public val creationDate: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDate
    /**
     * The server-side encryption key used to protect your backups; for example, `arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`.
     */
    public val encryptionKeyArn: kotlin.String? = builder.encryptionKeyArn
    /**
     * Specifies the IAM role ARN used to create the target recovery point; for example, `arn:aws:iam::123456789012:role/S3Access`.
     */
    public val iamRoleArn: kotlin.String? = builder.iamRoleArn
    /**
     * A Boolean value that is returned as `TRUE` if the specified recovery point is encrypted, or `FALSE` if the recovery point is not encrypted.
     */
    public val isEncrypted: kotlin.Boolean = builder.isEncrypted
    /**
     * This returns the boolean value that a recovery point is a parent (composite) job.
     */
    public val isParent: kotlin.Boolean = builder.isParent
    /**
     * The date and time that a recovery point was last restored, in Unix format and Coordinated Universal Time (UTC). The value of `LastRestoreTime` is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public val lastRestoreTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastRestoreTime
    /**
     * The lifecycle defines when a protected resource is transitioned to cold storage and when it expires. Backup transitions and expires backups automatically according to the lifecycle that you define.
     *
     * Backups that are transitioned to cold storage must be stored in cold storage for a minimum of 90 days. Therefore, the “retention” setting must be 90 days greater than the “transition to cold after days” setting. The “transition to cold after days” setting cannot be changed after a backup has been transitioned to cold.
     *
     * Resource types that are able to be transitioned to cold storage are listed in the "Lifecycle to cold storage" section of the [ Feature availability by resource](https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html#features-by-resource) table. Backup ignores this expression for other resource types.
     */
    public val lifecycle: aws.sdk.kotlin.services.backup.model.Lifecycle? = builder.lifecycle
    /**
     * This is an ARN that uniquely identifies a parent (composite) recovery point; for example, `arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45`.
     */
    public val parentRecoveryPointArn: kotlin.String? = builder.parentRecoveryPointArn
    /**
     * An ARN that uniquely identifies a recovery point; for example, `arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45`.
     */
    public val recoveryPointArn: kotlin.String? = builder.recoveryPointArn
    /**
     * An ARN that uniquely identifies a saved resource. The format of the ARN depends on the resource type.
     */
    public val resourceArn: kotlin.String? = builder.resourceArn
    /**
     * The type of Amazon Web Services resource to save as a recovery point; for example, an Amazon Elastic Block Store (Amazon EBS) volume or an Amazon Relational Database Service (Amazon RDS) database.
     */
    public val resourceType: kotlin.String? = builder.resourceType
    /**
     * An Amazon Resource Name (ARN) that uniquely identifies the source vault where the resource was originally backed up in; for example, `arn:aws:backup:us-east-1:123456789012:vault:BackupVault`. If the recovery is restored to the same Amazon Web Services account or Region, this value will be `null`.
     */
    public val sourceBackupVaultArn: kotlin.String? = builder.sourceBackupVaultArn
    /**
     * A status code specifying the state of the recovery point.
     *
     * `PARTIAL` status indicates Backup could not create the recovery point before the backup window closed. To increase your backup plan window using the API, see [UpdateBackupPlan](https://docs.aws.amazon.com/aws-backup/latest/devguide/API_UpdateBackupPlan.html). You can also increase your backup plan window using the Console by choosing and editing your backup plan.
     *
     * `EXPIRED` status indicates that the recovery point has exceeded its retention period, but Backup lacks permission or is otherwise unable to delete it. To manually delete these recovery points, see [ Step 3: Delete the recovery points](https://docs.aws.amazon.com/aws-backup/latest/devguide/gs-cleanup-resources.html#cleanup-backups) in the *Clean up resources* section of *Getting started*.
     *
     * `STOPPED` status occurs on a continuous backup where a user has taken some action that causes the continuous backup to be disabled. This can be caused by the removal of permissions, turning off versioning, turning off events being sent to EventBridge, or disabling the EventBridge rules that are put in place by Backup.
     *
     * To resolve `STOPPED` status, ensure that all requested permissions are in place and that versioning is enabled on the S3 bucket. Once these conditions are met, the next instance of a backup rule running will result in a new continuous recovery point being created. The recovery points with STOPPED status do not need to be deleted.
     */
    public val status: aws.sdk.kotlin.services.backup.model.RecoveryPointStatus? = builder.status
    /**
     * A status message explaining the reason for the recovery point deletion failure.
     */
    public val statusMessage: kotlin.String? = builder.statusMessage
    /**
     * Specifies the storage class of the recovery point. Valid values are `WARM` or `COLD`.
     */
    public val storageClass: aws.sdk.kotlin.services.backup.model.StorageClass? = builder.storageClass

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.backup.model.DescribeRecoveryPointResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeRecoveryPointResponse(")
        append("backupSizeInBytes=$backupSizeInBytes,")
        append("backupVaultArn=$backupVaultArn,")
        append("backupVaultName=$backupVaultName,")
        append("calculatedLifecycle=$calculatedLifecycle,")
        append("completionDate=$completionDate,")
        append("compositeMemberIdentifier=$compositeMemberIdentifier,")
        append("createdBy=$createdBy,")
        append("creationDate=$creationDate,")
        append("encryptionKeyArn=$encryptionKeyArn,")
        append("iamRoleArn=$iamRoleArn,")
        append("isEncrypted=$isEncrypted,")
        append("isParent=$isParent,")
        append("lastRestoreTime=$lastRestoreTime,")
        append("lifecycle=$lifecycle,")
        append("parentRecoveryPointArn=$parentRecoveryPointArn,")
        append("recoveryPointArn=$recoveryPointArn,")
        append("resourceArn=$resourceArn,")
        append("resourceType=$resourceType,")
        append("sourceBackupVaultArn=$sourceBackupVaultArn,")
        append("status=$status,")
        append("statusMessage=$statusMessage,")
        append("storageClass=$storageClass")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = backupSizeInBytes?.hashCode() ?: 0
        result = 31 * result + (backupVaultArn?.hashCode() ?: 0)
        result = 31 * result + (backupVaultName?.hashCode() ?: 0)
        result = 31 * result + (calculatedLifecycle?.hashCode() ?: 0)
        result = 31 * result + (completionDate?.hashCode() ?: 0)
        result = 31 * result + (compositeMemberIdentifier?.hashCode() ?: 0)
        result = 31 * result + (createdBy?.hashCode() ?: 0)
        result = 31 * result + (creationDate?.hashCode() ?: 0)
        result = 31 * result + (encryptionKeyArn?.hashCode() ?: 0)
        result = 31 * result + (iamRoleArn?.hashCode() ?: 0)
        result = 31 * result + (isEncrypted.hashCode())
        result = 31 * result + (isParent.hashCode())
        result = 31 * result + (lastRestoreTime?.hashCode() ?: 0)
        result = 31 * result + (lifecycle?.hashCode() ?: 0)
        result = 31 * result + (parentRecoveryPointArn?.hashCode() ?: 0)
        result = 31 * result + (recoveryPointArn?.hashCode() ?: 0)
        result = 31 * result + (resourceArn?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        result = 31 * result + (sourceBackupVaultArn?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusMessage?.hashCode() ?: 0)
        result = 31 * result + (storageClass?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeRecoveryPointResponse

        if (backupSizeInBytes != other.backupSizeInBytes) return false
        if (backupVaultArn != other.backupVaultArn) return false
        if (backupVaultName != other.backupVaultName) return false
        if (calculatedLifecycle != other.calculatedLifecycle) return false
        if (completionDate != other.completionDate) return false
        if (compositeMemberIdentifier != other.compositeMemberIdentifier) return false
        if (createdBy != other.createdBy) return false
        if (creationDate != other.creationDate) return false
        if (encryptionKeyArn != other.encryptionKeyArn) return false
        if (iamRoleArn != other.iamRoleArn) return false
        if (isEncrypted != other.isEncrypted) return false
        if (isParent != other.isParent) return false
        if (lastRestoreTime != other.lastRestoreTime) return false
        if (lifecycle != other.lifecycle) return false
        if (parentRecoveryPointArn != other.parentRecoveryPointArn) return false
        if (recoveryPointArn != other.recoveryPointArn) return false
        if (resourceArn != other.resourceArn) return false
        if (resourceType != other.resourceType) return false
        if (sourceBackupVaultArn != other.sourceBackupVaultArn) return false
        if (status != other.status) return false
        if (statusMessage != other.statusMessage) return false
        if (storageClass != other.storageClass) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.backup.model.DescribeRecoveryPointResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The size, in bytes, of a backup.
         */
        public var backupSizeInBytes: kotlin.Long? = null
        /**
         * An ARN that uniquely identifies a backup vault; for example, `arn:aws:backup:us-east-1:123456789012:vault:aBackupVault`.
         */
        public var backupVaultArn: kotlin.String? = null
        /**
         * The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Region where they are created. They consist of lowercase letters, numbers, and hyphens.
         */
        public var backupVaultName: kotlin.String? = null
        /**
         * A `CalculatedLifecycle` object containing `DeleteAt` and `MoveToColdStorageAt` timestamps.
         */
        public var calculatedLifecycle: aws.sdk.kotlin.services.backup.model.CalculatedLifecycle? = null
        /**
         * The date and time that a job to create a recovery point is completed, in Unix format and Coordinated Universal Time (UTC). The value of `CompletionDate` is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         */
        public var completionDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * This is the identifier of a resource within a composite group, such as nested (child) recovery point belonging to a composite (parent) stack. The ID is transferred from the [ logical ID](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/resources-section-structure.html#resources-section-structure-syntax) within a stack.
         */
        public var compositeMemberIdentifier: kotlin.String? = null
        /**
         * Contains identifying information about the creation of a recovery point, including the `BackupPlanArn`, `BackupPlanId`, `BackupPlanVersion`, and `BackupRuleId` of the backup plan used to create it.
         */
        public var createdBy: aws.sdk.kotlin.services.backup.model.RecoveryPointCreator? = null
        /**
         * The date and time that a recovery point is created, in Unix format and Coordinated Universal Time (UTC). The value of `CreationDate` is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         */
        public var creationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The server-side encryption key used to protect your backups; for example, `arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`.
         */
        public var encryptionKeyArn: kotlin.String? = null
        /**
         * Specifies the IAM role ARN used to create the target recovery point; for example, `arn:aws:iam::123456789012:role/S3Access`.
         */
        public var iamRoleArn: kotlin.String? = null
        /**
         * A Boolean value that is returned as `TRUE` if the specified recovery point is encrypted, or `FALSE` if the recovery point is not encrypted.
         */
        public var isEncrypted: kotlin.Boolean = false
        /**
         * This returns the boolean value that a recovery point is a parent (composite) job.
         */
        public var isParent: kotlin.Boolean = false
        /**
         * The date and time that a recovery point was last restored, in Unix format and Coordinated Universal Time (UTC). The value of `LastRestoreTime` is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         */
        public var lastRestoreTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The lifecycle defines when a protected resource is transitioned to cold storage and when it expires. Backup transitions and expires backups automatically according to the lifecycle that you define.
         *
         * Backups that are transitioned to cold storage must be stored in cold storage for a minimum of 90 days. Therefore, the “retention” setting must be 90 days greater than the “transition to cold after days” setting. The “transition to cold after days” setting cannot be changed after a backup has been transitioned to cold.
         *
         * Resource types that are able to be transitioned to cold storage are listed in the "Lifecycle to cold storage" section of the [ Feature availability by resource](https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html#features-by-resource) table. Backup ignores this expression for other resource types.
         */
        public var lifecycle: aws.sdk.kotlin.services.backup.model.Lifecycle? = null
        /**
         * This is an ARN that uniquely identifies a parent (composite) recovery point; for example, `arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45`.
         */
        public var parentRecoveryPointArn: kotlin.String? = null
        /**
         * An ARN that uniquely identifies a recovery point; for example, `arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45`.
         */
        public var recoveryPointArn: kotlin.String? = null
        /**
         * An ARN that uniquely identifies a saved resource. The format of the ARN depends on the resource type.
         */
        public var resourceArn: kotlin.String? = null
        /**
         * The type of Amazon Web Services resource to save as a recovery point; for example, an Amazon Elastic Block Store (Amazon EBS) volume or an Amazon Relational Database Service (Amazon RDS) database.
         */
        public var resourceType: kotlin.String? = null
        /**
         * An Amazon Resource Name (ARN) that uniquely identifies the source vault where the resource was originally backed up in; for example, `arn:aws:backup:us-east-1:123456789012:vault:BackupVault`. If the recovery is restored to the same Amazon Web Services account or Region, this value will be `null`.
         */
        public var sourceBackupVaultArn: kotlin.String? = null
        /**
         * A status code specifying the state of the recovery point.
         *
         * `PARTIAL` status indicates Backup could not create the recovery point before the backup window closed. To increase your backup plan window using the API, see [UpdateBackupPlan](https://docs.aws.amazon.com/aws-backup/latest/devguide/API_UpdateBackupPlan.html). You can also increase your backup plan window using the Console by choosing and editing your backup plan.
         *
         * `EXPIRED` status indicates that the recovery point has exceeded its retention period, but Backup lacks permission or is otherwise unable to delete it. To manually delete these recovery points, see [ Step 3: Delete the recovery points](https://docs.aws.amazon.com/aws-backup/latest/devguide/gs-cleanup-resources.html#cleanup-backups) in the *Clean up resources* section of *Getting started*.
         *
         * `STOPPED` status occurs on a continuous backup where a user has taken some action that causes the continuous backup to be disabled. This can be caused by the removal of permissions, turning off versioning, turning off events being sent to EventBridge, or disabling the EventBridge rules that are put in place by Backup.
         *
         * To resolve `STOPPED` status, ensure that all requested permissions are in place and that versioning is enabled on the S3 bucket. Once these conditions are met, the next instance of a backup rule running will result in a new continuous recovery point being created. The recovery points with STOPPED status do not need to be deleted.
         */
        public var status: aws.sdk.kotlin.services.backup.model.RecoveryPointStatus? = null
        /**
         * A status message explaining the reason for the recovery point deletion failure.
         */
        public var statusMessage: kotlin.String? = null
        /**
         * Specifies the storage class of the recovery point. Valid values are `WARM` or `COLD`.
         */
        public var storageClass: aws.sdk.kotlin.services.backup.model.StorageClass? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.backup.model.DescribeRecoveryPointResponse) : this() {
            this.backupSizeInBytes = x.backupSizeInBytes
            this.backupVaultArn = x.backupVaultArn
            this.backupVaultName = x.backupVaultName
            this.calculatedLifecycle = x.calculatedLifecycle
            this.completionDate = x.completionDate
            this.compositeMemberIdentifier = x.compositeMemberIdentifier
            this.createdBy = x.createdBy
            this.creationDate = x.creationDate
            this.encryptionKeyArn = x.encryptionKeyArn
            this.iamRoleArn = x.iamRoleArn
            this.isEncrypted = x.isEncrypted
            this.isParent = x.isParent
            this.lastRestoreTime = x.lastRestoreTime
            this.lifecycle = x.lifecycle
            this.parentRecoveryPointArn = x.parentRecoveryPointArn
            this.recoveryPointArn = x.recoveryPointArn
            this.resourceArn = x.resourceArn
            this.resourceType = x.resourceType
            this.sourceBackupVaultArn = x.sourceBackupVaultArn
            this.status = x.status
            this.statusMessage = x.statusMessage
            this.storageClass = x.storageClass
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.backup.model.DescribeRecoveryPointResponse = DescribeRecoveryPointResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.backup.model.CalculatedLifecycle] inside the given [block]
         */
        public fun calculatedLifecycle(block: aws.sdk.kotlin.services.backup.model.CalculatedLifecycle.Builder.() -> kotlin.Unit) {
            this.calculatedLifecycle = aws.sdk.kotlin.services.backup.model.CalculatedLifecycle.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.backup.model.RecoveryPointCreator] inside the given [block]
         */
        public fun createdBy(block: aws.sdk.kotlin.services.backup.model.RecoveryPointCreator.Builder.() -> kotlin.Unit) {
            this.createdBy = aws.sdk.kotlin.services.backup.model.RecoveryPointCreator.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.backup.model.Lifecycle] inside the given [block]
         */
        public fun lifecycle(block: aws.sdk.kotlin.services.backup.model.Lifecycle.Builder.() -> kotlin.Unit) {
            this.lifecycle = aws.sdk.kotlin.services.backup.model.Lifecycle.invoke(block)
        }
    }
}
