// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.model



/**
 * This specifies criteria to assign a set of resources, such as resource types or backup vaults.
 */
public class RecoveryPointSelection private constructor(builder: Builder) {
    /**
     * This is a resource filter containing FromDate: DateTime and ToDate: DateTime. Both values are required. Future DateTime values are not permitted.
     *
     * The date and time are in Unix format and Coordinated Universal Time (UTC), and it is accurate to milliseconds ((milliseconds are optional). For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public val dateRange: aws.sdk.kotlin.services.backup.model.DateRange? = builder.dateRange
    /**
     * These are the resources included in the resource selection (including type of resources and vaults).
     */
    public val resourceIdentifiers: List<String>? = builder.resourceIdentifiers
    /**
     * These are the names of the vaults in which the selected recovery points are contained.
     */
    public val vaultNames: List<String>? = builder.vaultNames

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.backup.model.RecoveryPointSelection = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RecoveryPointSelection(")
        append("dateRange=$dateRange,")
        append("resourceIdentifiers=$resourceIdentifiers,")
        append("vaultNames=$vaultNames")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dateRange?.hashCode() ?: 0
        result = 31 * result + (resourceIdentifiers?.hashCode() ?: 0)
        result = 31 * result + (vaultNames?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RecoveryPointSelection

        if (dateRange != other.dateRange) return false
        if (resourceIdentifiers != other.resourceIdentifiers) return false
        if (vaultNames != other.vaultNames) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.backup.model.RecoveryPointSelection = Builder(this).apply(block).build()

    public class Builder {
        /**
         * This is a resource filter containing FromDate: DateTime and ToDate: DateTime. Both values are required. Future DateTime values are not permitted.
         *
         * The date and time are in Unix format and Coordinated Universal Time (UTC), and it is accurate to milliseconds ((milliseconds are optional). For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         */
        public var dateRange: aws.sdk.kotlin.services.backup.model.DateRange? = null
        /**
         * These are the resources included in the resource selection (including type of resources and vaults).
         */
        public var resourceIdentifiers: List<String>? = null
        /**
         * These are the names of the vaults in which the selected recovery points are contained.
         */
        public var vaultNames: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.backup.model.RecoveryPointSelection) : this() {
            this.dateRange = x.dateRange
            this.resourceIdentifiers = x.resourceIdentifiers
            this.vaultNames = x.vaultNames
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.backup.model.RecoveryPointSelection = RecoveryPointSelection(this)

        /**
         * construct an [aws.sdk.kotlin.services.backup.model.DateRange] inside the given [block]
         */
        public fun dateRange(block: aws.sdk.kotlin.services.backup.model.DateRange.Builder.() -> kotlin.Unit) {
            this.dateRange = aws.sdk.kotlin.services.backup.model.DateRange.invoke(block)
        }
    }
}
