// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.model



/**
 * Contains information from your report plan about where to deliver your reports, specifically your Amazon S3 bucket name, S3 key prefix, and the formats of your reports.
 */
public class ReportDeliveryChannel private constructor(builder: Builder) {
    /**
     * A list of the format of your reports: `CSV`, `JSON`, or both. If not specified, the default format is `CSV`.
     */
    public val formats: List<String>? = builder.formats
    /**
     * The unique name of the S3 bucket that receives your reports.
     */
    public val s3BucketName: kotlin.String? = builder.s3BucketName
    /**
     * The prefix for where Backup Audit Manager delivers your reports to Amazon S3. The prefix is this part of the following path: s3://your-bucket-name/`prefix`/Backup/us-west-2/year/month/day/report-name. If not specified, there is no prefix.
     */
    public val s3KeyPrefix: kotlin.String? = builder.s3KeyPrefix

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.backup.model.ReportDeliveryChannel = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ReportDeliveryChannel(")
        append("formats=$formats,")
        append("s3BucketName=$s3BucketName,")
        append("s3KeyPrefix=$s3KeyPrefix")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = formats?.hashCode() ?: 0
        result = 31 * result + (s3BucketName?.hashCode() ?: 0)
        result = 31 * result + (s3KeyPrefix?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ReportDeliveryChannel

        if (formats != other.formats) return false
        if (s3BucketName != other.s3BucketName) return false
        if (s3KeyPrefix != other.s3KeyPrefix) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.backup.model.ReportDeliveryChannel = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A list of the format of your reports: `CSV`, `JSON`, or both. If not specified, the default format is `CSV`.
         */
        public var formats: List<String>? = null
        /**
         * The unique name of the S3 bucket that receives your reports.
         */
        public var s3BucketName: kotlin.String? = null
        /**
         * The prefix for where Backup Audit Manager delivers your reports to Amazon S3. The prefix is this part of the following path: s3://your-bucket-name/`prefix`/Backup/us-west-2/year/month/day/report-name. If not specified, there is no prefix.
         */
        public var s3KeyPrefix: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.backup.model.ReportDeliveryChannel) : this() {
            this.formats = x.formats
            this.s3BucketName = x.s3BucketName
            this.s3KeyPrefix = x.s3KeyPrefix
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.backup.model.ReportDeliveryChannel = ReportDeliveryChannel(this)
    }
}
