// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.model



public class StartCopyJobRequest private constructor(builder: Builder) {
    /**
     * An Amazon Resource Name (ARN) that uniquely identifies a destination backup vault to copy to; for example, `arn:aws:backup:us-east-1:123456789012:vault:aBackupVault`.
     */
    public val destinationBackupVaultArn: kotlin.String? = builder.destinationBackupVaultArn
    /**
     * Specifies the IAM role ARN used to copy the target recovery point; for example, `arn:aws:iam::123456789012:role/S3Access`.
     */
    public val iamRoleArn: kotlin.String? = builder.iamRoleArn
    /**
     * A customer-chosen string that you can use to distinguish between otherwise identical calls to `StartCopyJob`. Retrying a successful request with the same idempotency token results in a success message with no action taken.
     */
    public val idempotencyToken: kotlin.String? = builder.idempotencyToken
    /**
     * Contains an array of `Transition` objects specifying how long in days before a recovery point transitions to cold storage or is deleted.
     *
     * Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days. Therefore, on the console, the “retention” setting must be 90 days greater than the “transition to cold after days” setting. The “transition to cold after days” setting cannot be changed after a backup has been transitioned to cold.
     *
     * Resource types that are able to be transitioned to cold storage are listed in the "Lifecycle to cold storage" section of the [ Feature availability by resource](https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html#features-by-resource) table. Backup ignores this expression for other resource types.
     */
    public val lifecycle: aws.sdk.kotlin.services.backup.model.Lifecycle? = builder.lifecycle
    /**
     * An ARN that uniquely identifies a recovery point to use for the copy job; for example, arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45.
     */
    public val recoveryPointArn: kotlin.String? = builder.recoveryPointArn
    /**
     * The name of a logical source container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Amazon Web Services Region where they are created. They consist of lowercase letters, numbers, and hyphens.
     */
    public val sourceBackupVaultName: kotlin.String? = builder.sourceBackupVaultName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.backup.model.StartCopyJobRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StartCopyJobRequest(")
        append("destinationBackupVaultArn=$destinationBackupVaultArn,")
        append("iamRoleArn=$iamRoleArn,")
        append("idempotencyToken=$idempotencyToken,")
        append("lifecycle=$lifecycle,")
        append("recoveryPointArn=$recoveryPointArn,")
        append("sourceBackupVaultName=$sourceBackupVaultName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = destinationBackupVaultArn?.hashCode() ?: 0
        result = 31 * result + (iamRoleArn?.hashCode() ?: 0)
        result = 31 * result + (idempotencyToken?.hashCode() ?: 0)
        result = 31 * result + (lifecycle?.hashCode() ?: 0)
        result = 31 * result + (recoveryPointArn?.hashCode() ?: 0)
        result = 31 * result + (sourceBackupVaultName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StartCopyJobRequest

        if (destinationBackupVaultArn != other.destinationBackupVaultArn) return false
        if (iamRoleArn != other.iamRoleArn) return false
        if (idempotencyToken != other.idempotencyToken) return false
        if (lifecycle != other.lifecycle) return false
        if (recoveryPointArn != other.recoveryPointArn) return false
        if (sourceBackupVaultName != other.sourceBackupVaultName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.backup.model.StartCopyJobRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * An Amazon Resource Name (ARN) that uniquely identifies a destination backup vault to copy to; for example, `arn:aws:backup:us-east-1:123456789012:vault:aBackupVault`.
         */
        public var destinationBackupVaultArn: kotlin.String? = null
        /**
         * Specifies the IAM role ARN used to copy the target recovery point; for example, `arn:aws:iam::123456789012:role/S3Access`.
         */
        public var iamRoleArn: kotlin.String? = null
        /**
         * A customer-chosen string that you can use to distinguish between otherwise identical calls to `StartCopyJob`. Retrying a successful request with the same idempotency token results in a success message with no action taken.
         */
        public var idempotencyToken: kotlin.String? = null
        /**
         * Contains an array of `Transition` objects specifying how long in days before a recovery point transitions to cold storage or is deleted.
         *
         * Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days. Therefore, on the console, the “retention” setting must be 90 days greater than the “transition to cold after days” setting. The “transition to cold after days” setting cannot be changed after a backup has been transitioned to cold.
         *
         * Resource types that are able to be transitioned to cold storage are listed in the "Lifecycle to cold storage" section of the [ Feature availability by resource](https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html#features-by-resource) table. Backup ignores this expression for other resource types.
         */
        public var lifecycle: aws.sdk.kotlin.services.backup.model.Lifecycle? = null
        /**
         * An ARN that uniquely identifies a recovery point to use for the copy job; for example, arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45.
         */
        public var recoveryPointArn: kotlin.String? = null
        /**
         * The name of a logical source container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Amazon Web Services Region where they are created. They consist of lowercase letters, numbers, and hyphens.
         */
        public var sourceBackupVaultName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.backup.model.StartCopyJobRequest) : this() {
            this.destinationBackupVaultArn = x.destinationBackupVaultArn
            this.iamRoleArn = x.iamRoleArn
            this.idempotencyToken = x.idempotencyToken
            this.lifecycle = x.lifecycle
            this.recoveryPointArn = x.recoveryPointArn
            this.sourceBackupVaultName = x.sourceBackupVaultName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.backup.model.StartCopyJobRequest = StartCopyJobRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.backup.model.Lifecycle] inside the given [block]
         */
        public fun lifecycle(block: aws.sdk.kotlin.services.backup.model.Lifecycle.Builder.() -> kotlin.Unit) {
            this.lifecycle = aws.sdk.kotlin.services.backup.model.Lifecycle.invoke(block)
        }
    }
}
