// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.model



public class UpdateRecoveryPointLifecycleRequest private constructor(builder: Builder) {
    /**
     * The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Amazon Web Services Region where they are created. They consist of lowercase letters, numbers, and hyphens.
     */
    public val backupVaultName: kotlin.String? = requireNotNull(builder.backupVaultName) { "A non-null value must be provided for backupVaultName" }
    /**
     * The lifecycle defines when a protected resource is transitioned to cold storage and when it expires. Backup transitions and expires backups automatically according to the lifecycle that you define.
     *
     * Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days. Therefore, the “retention” setting must be 90 days greater than the “transition to cold after days” setting. The “transition to cold after days” setting cannot be changed after a backup has been transitioned to cold.
     */
    public val lifecycle: aws.sdk.kotlin.services.backup.model.Lifecycle? = builder.lifecycle
    /**
     * An Amazon Resource Name (ARN) that uniquely identifies a recovery point; for example, `arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45`.
     */
    public val recoveryPointArn: kotlin.String? = requireNotNull(builder.recoveryPointArn) { "A non-null value must be provided for recoveryPointArn" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.backup.model.UpdateRecoveryPointLifecycleRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateRecoveryPointLifecycleRequest(")
        append("backupVaultName=$backupVaultName,")
        append("lifecycle=$lifecycle,")
        append("recoveryPointArn=$recoveryPointArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = backupVaultName?.hashCode() ?: 0
        result = 31 * result + (lifecycle?.hashCode() ?: 0)
        result = 31 * result + (recoveryPointArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateRecoveryPointLifecycleRequest

        if (backupVaultName != other.backupVaultName) return false
        if (lifecycle != other.lifecycle) return false
        if (recoveryPointArn != other.recoveryPointArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.backup.model.UpdateRecoveryPointLifecycleRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Amazon Web Services Region where they are created. They consist of lowercase letters, numbers, and hyphens.
         */
        public var backupVaultName: kotlin.String? = null
        /**
         * The lifecycle defines when a protected resource is transitioned to cold storage and when it expires. Backup transitions and expires backups automatically according to the lifecycle that you define.
         *
         * Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days. Therefore, the “retention” setting must be 90 days greater than the “transition to cold after days” setting. The “transition to cold after days” setting cannot be changed after a backup has been transitioned to cold.
         */
        public var lifecycle: aws.sdk.kotlin.services.backup.model.Lifecycle? = null
        /**
         * An Amazon Resource Name (ARN) that uniquely identifies a recovery point; for example, `arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45`.
         */
        public var recoveryPointArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.backup.model.UpdateRecoveryPointLifecycleRequest) : this() {
            this.backupVaultName = x.backupVaultName
            this.lifecycle = x.lifecycle
            this.recoveryPointArn = x.recoveryPointArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.backup.model.UpdateRecoveryPointLifecycleRequest = UpdateRecoveryPointLifecycleRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.backup.model.Lifecycle] inside the given [block]
         */
        public fun lifecycle(block: aws.sdk.kotlin.services.backup.model.Lifecycle.Builder.() -> kotlin.Unit) {
            this.lifecycle = aws.sdk.kotlin.services.backup.model.Lifecycle.invoke(block)
        }
    }
}
