// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.paginators

import aws.sdk.kotlin.services.backup.BackupClient
import aws.sdk.kotlin.services.backup.model.BackupJob
import aws.sdk.kotlin.services.backup.model.BackupPlanTemplatesListMember
import aws.sdk.kotlin.services.backup.model.BackupPlansListMember
import aws.sdk.kotlin.services.backup.model.BackupSelectionsListMember
import aws.sdk.kotlin.services.backup.model.BackupVaultListMember
import aws.sdk.kotlin.services.backup.model.CopyJob
import aws.sdk.kotlin.services.backup.model.LegalHold
import aws.sdk.kotlin.services.backup.model.ListBackupJobsRequest
import aws.sdk.kotlin.services.backup.model.ListBackupJobsResponse
import aws.sdk.kotlin.services.backup.model.ListBackupPlanTemplatesRequest
import aws.sdk.kotlin.services.backup.model.ListBackupPlanTemplatesResponse
import aws.sdk.kotlin.services.backup.model.ListBackupPlanVersionsRequest
import aws.sdk.kotlin.services.backup.model.ListBackupPlanVersionsResponse
import aws.sdk.kotlin.services.backup.model.ListBackupPlansRequest
import aws.sdk.kotlin.services.backup.model.ListBackupPlansResponse
import aws.sdk.kotlin.services.backup.model.ListBackupSelectionsRequest
import aws.sdk.kotlin.services.backup.model.ListBackupSelectionsResponse
import aws.sdk.kotlin.services.backup.model.ListBackupVaultsRequest
import aws.sdk.kotlin.services.backup.model.ListBackupVaultsResponse
import aws.sdk.kotlin.services.backup.model.ListCopyJobsRequest
import aws.sdk.kotlin.services.backup.model.ListCopyJobsResponse
import aws.sdk.kotlin.services.backup.model.ListFrameworksRequest
import aws.sdk.kotlin.services.backup.model.ListFrameworksResponse
import aws.sdk.kotlin.services.backup.model.ListLegalHoldsRequest
import aws.sdk.kotlin.services.backup.model.ListLegalHoldsResponse
import aws.sdk.kotlin.services.backup.model.ListProtectedResourcesRequest
import aws.sdk.kotlin.services.backup.model.ListProtectedResourcesResponse
import aws.sdk.kotlin.services.backup.model.ListRecoveryPointsByBackupVaultRequest
import aws.sdk.kotlin.services.backup.model.ListRecoveryPointsByBackupVaultResponse
import aws.sdk.kotlin.services.backup.model.ListRecoveryPointsByLegalHoldRequest
import aws.sdk.kotlin.services.backup.model.ListRecoveryPointsByLegalHoldResponse
import aws.sdk.kotlin.services.backup.model.ListRecoveryPointsByResourceRequest
import aws.sdk.kotlin.services.backup.model.ListRecoveryPointsByResourceResponse
import aws.sdk.kotlin.services.backup.model.ListReportJobsRequest
import aws.sdk.kotlin.services.backup.model.ListReportJobsResponse
import aws.sdk.kotlin.services.backup.model.ListReportPlansRequest
import aws.sdk.kotlin.services.backup.model.ListReportPlansResponse
import aws.sdk.kotlin.services.backup.model.ListRestoreJobsRequest
import aws.sdk.kotlin.services.backup.model.ListRestoreJobsResponse
import aws.sdk.kotlin.services.backup.model.ListTagsRequest
import aws.sdk.kotlin.services.backup.model.ListTagsResponse
import aws.sdk.kotlin.services.backup.model.ProtectedResource
import aws.sdk.kotlin.services.backup.model.RecoveryPointByBackupVault
import aws.sdk.kotlin.services.backup.model.RecoveryPointByResource
import aws.sdk.kotlin.services.backup.model.RecoveryPointMember
import aws.sdk.kotlin.services.backup.model.RestoreJobsListMember
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListBackupJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListBackupJobsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListBackupJobsResponse]
 */
public fun BackupClient.listBackupJobsPaginated(initialRequest: ListBackupJobsRequest): Flow<ListBackupJobsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listBackupJobsPaginated.listBackupJobs(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListBackupJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListBackupJobsResponse]
 */
public fun BackupClient.listBackupJobsPaginated(block: ListBackupJobsRequest.Builder.() -> Unit): Flow<ListBackupJobsResponse> =
    listBackupJobsPaginated(ListBackupJobsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listBackupJobsPaginated]
 * to access the nested member [BackupJob]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [BackupJob]
 */
@JvmName("listBackupJobsResponseBackupJob")
public fun Flow<ListBackupJobsResponse>.backupJobs(): Flow<BackupJob> =
    transform() { response ->
        response.backupJobs?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListBackupPlansResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListBackupPlansRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListBackupPlansResponse]
 */
public fun BackupClient.listBackupPlansPaginated(initialRequest: ListBackupPlansRequest): Flow<ListBackupPlansResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listBackupPlansPaginated.listBackupPlans(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListBackupPlansResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListBackupPlansResponse]
 */
public fun BackupClient.listBackupPlansPaginated(block: ListBackupPlansRequest.Builder.() -> Unit): Flow<ListBackupPlansResponse> =
    listBackupPlansPaginated(ListBackupPlansRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listBackupPlansPaginated]
 * to access the nested member [BackupPlansListMember]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [BackupPlansListMember]
 */
@JvmName("listBackupPlansResponseBackupPlansListMember")
public fun Flow<ListBackupPlansResponse>.backupPlansList(): Flow<BackupPlansListMember> =
    transform() { response ->
        response.backupPlansList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListBackupPlanTemplatesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListBackupPlanTemplatesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListBackupPlanTemplatesResponse]
 */
public fun BackupClient.listBackupPlanTemplatesPaginated(initialRequest: ListBackupPlanTemplatesRequest): Flow<ListBackupPlanTemplatesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listBackupPlanTemplatesPaginated.listBackupPlanTemplates(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListBackupPlanTemplatesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListBackupPlanTemplatesResponse]
 */
public fun BackupClient.listBackupPlanTemplatesPaginated(block: ListBackupPlanTemplatesRequest.Builder.() -> Unit): Flow<ListBackupPlanTemplatesResponse> =
    listBackupPlanTemplatesPaginated(ListBackupPlanTemplatesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listBackupPlanTemplatesPaginated]
 * to access the nested member [BackupPlanTemplatesListMember]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [BackupPlanTemplatesListMember]
 */
@JvmName("listBackupPlanTemplatesResponseBackupPlanTemplatesListMember")
public fun Flow<ListBackupPlanTemplatesResponse>.backupPlanTemplatesList(): Flow<BackupPlanTemplatesListMember> =
    transform() { response ->
        response.backupPlanTemplatesList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListBackupPlanVersionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListBackupPlanVersionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListBackupPlanVersionsResponse]
 */
public fun BackupClient.listBackupPlanVersionsPaginated(initialRequest: ListBackupPlanVersionsRequest): Flow<ListBackupPlanVersionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listBackupPlanVersionsPaginated.listBackupPlanVersions(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListBackupPlanVersionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListBackupPlanVersionsResponse]
 */
public fun BackupClient.listBackupPlanVersionsPaginated(block: ListBackupPlanVersionsRequest.Builder.() -> Unit): Flow<ListBackupPlanVersionsResponse> =
    listBackupPlanVersionsPaginated(ListBackupPlanVersionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listBackupPlanVersionsPaginated]
 * to access the nested member [BackupPlansListMember]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [BackupPlansListMember]
 */
@JvmName("listBackupPlanVersionsResponseBackupPlansListMember")
public fun Flow<ListBackupPlanVersionsResponse>.backupPlanVersionsList(): Flow<BackupPlansListMember> =
    transform() { response ->
        response.backupPlanVersionsList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListBackupSelectionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListBackupSelectionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListBackupSelectionsResponse]
 */
public fun BackupClient.listBackupSelectionsPaginated(initialRequest: ListBackupSelectionsRequest): Flow<ListBackupSelectionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listBackupSelectionsPaginated.listBackupSelections(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListBackupSelectionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListBackupSelectionsResponse]
 */
public fun BackupClient.listBackupSelectionsPaginated(block: ListBackupSelectionsRequest.Builder.() -> Unit): Flow<ListBackupSelectionsResponse> =
    listBackupSelectionsPaginated(ListBackupSelectionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listBackupSelectionsPaginated]
 * to access the nested member [BackupSelectionsListMember]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [BackupSelectionsListMember]
 */
@JvmName("listBackupSelectionsResponseBackupSelectionsListMember")
public fun Flow<ListBackupSelectionsResponse>.backupSelectionsList(): Flow<BackupSelectionsListMember> =
    transform() { response ->
        response.backupSelectionsList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListBackupVaultsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListBackupVaultsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListBackupVaultsResponse]
 */
public fun BackupClient.listBackupVaultsPaginated(initialRequest: ListBackupVaultsRequest): Flow<ListBackupVaultsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listBackupVaultsPaginated.listBackupVaults(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListBackupVaultsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListBackupVaultsResponse]
 */
public fun BackupClient.listBackupVaultsPaginated(block: ListBackupVaultsRequest.Builder.() -> Unit): Flow<ListBackupVaultsResponse> =
    listBackupVaultsPaginated(ListBackupVaultsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listBackupVaultsPaginated]
 * to access the nested member [BackupVaultListMember]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [BackupVaultListMember]
 */
@JvmName("listBackupVaultsResponseBackupVaultListMember")
public fun Flow<ListBackupVaultsResponse>.backupVaultList(): Flow<BackupVaultListMember> =
    transform() { response ->
        response.backupVaultList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListCopyJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListCopyJobsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCopyJobsResponse]
 */
public fun BackupClient.listCopyJobsPaginated(initialRequest: ListCopyJobsRequest): Flow<ListCopyJobsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listCopyJobsPaginated.listCopyJobs(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListCopyJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCopyJobsResponse]
 */
public fun BackupClient.listCopyJobsPaginated(block: ListCopyJobsRequest.Builder.() -> Unit): Flow<ListCopyJobsResponse> =
    listCopyJobsPaginated(ListCopyJobsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listCopyJobsPaginated]
 * to access the nested member [CopyJob]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [CopyJob]
 */
@JvmName("listCopyJobsResponseCopyJob")
public fun Flow<ListCopyJobsResponse>.copyJobs(): Flow<CopyJob> =
    transform() { response ->
        response.copyJobs?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListFrameworksResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListFrameworksRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFrameworksResponse]
 */
public fun BackupClient.listFrameworksPaginated(initialRequest: ListFrameworksRequest): Flow<ListFrameworksResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listFrameworksPaginated.listFrameworks(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListFrameworksResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFrameworksResponse]
 */
public fun BackupClient.listFrameworksPaginated(block: ListFrameworksRequest.Builder.() -> Unit): Flow<ListFrameworksResponse> =
    listFrameworksPaginated(ListFrameworksRequest.Builder().apply(block).build())

/**
 * Paginate over [ListLegalHoldsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListLegalHoldsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListLegalHoldsResponse]
 */
public fun BackupClient.listLegalHoldsPaginated(initialRequest: ListLegalHoldsRequest): Flow<ListLegalHoldsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listLegalHoldsPaginated.listLegalHolds(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListLegalHoldsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListLegalHoldsResponse]
 */
public fun BackupClient.listLegalHoldsPaginated(block: ListLegalHoldsRequest.Builder.() -> Unit): Flow<ListLegalHoldsResponse> =
    listLegalHoldsPaginated(ListLegalHoldsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listLegalHoldsPaginated]
 * to access the nested member [LegalHold]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [LegalHold]
 */
@JvmName("listLegalHoldsResponseLegalHold")
public fun Flow<ListLegalHoldsResponse>.legalHolds(): Flow<LegalHold> =
    transform() { response ->
        response.legalHolds?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListProtectedResourcesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListProtectedResourcesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListProtectedResourcesResponse]
 */
public fun BackupClient.listProtectedResourcesPaginated(initialRequest: ListProtectedResourcesRequest): Flow<ListProtectedResourcesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listProtectedResourcesPaginated.listProtectedResources(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListProtectedResourcesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListProtectedResourcesResponse]
 */
public fun BackupClient.listProtectedResourcesPaginated(block: ListProtectedResourcesRequest.Builder.() -> Unit): Flow<ListProtectedResourcesResponse> =
    listProtectedResourcesPaginated(ListProtectedResourcesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listProtectedResourcesPaginated]
 * to access the nested member [ProtectedResource]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ProtectedResource]
 */
@JvmName("listProtectedResourcesResponseProtectedResource")
public fun Flow<ListProtectedResourcesResponse>.results(): Flow<ProtectedResource> =
    transform() { response ->
        response.results?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListRecoveryPointsByBackupVaultResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListRecoveryPointsByBackupVaultRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRecoveryPointsByBackupVaultResponse]
 */
public fun BackupClient.listRecoveryPointsByBackupVaultPaginated(initialRequest: ListRecoveryPointsByBackupVaultRequest): Flow<ListRecoveryPointsByBackupVaultResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listRecoveryPointsByBackupVaultPaginated.listRecoveryPointsByBackupVault(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListRecoveryPointsByBackupVaultResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRecoveryPointsByBackupVaultResponse]
 */
public fun BackupClient.listRecoveryPointsByBackupVaultPaginated(block: ListRecoveryPointsByBackupVaultRequest.Builder.() -> Unit): Flow<ListRecoveryPointsByBackupVaultResponse> =
    listRecoveryPointsByBackupVaultPaginated(ListRecoveryPointsByBackupVaultRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listRecoveryPointsByBackupVaultPaginated]
 * to access the nested member [RecoveryPointByBackupVault]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [RecoveryPointByBackupVault]
 */
@JvmName("listRecoveryPointsByBackupVaultResponseRecoveryPointByBackupVault")
public fun Flow<ListRecoveryPointsByBackupVaultResponse>.recoveryPoints(): Flow<RecoveryPointByBackupVault> =
    transform() { response ->
        response.recoveryPoints?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListRecoveryPointsByLegalHoldResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListRecoveryPointsByLegalHoldRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRecoveryPointsByLegalHoldResponse]
 */
public fun BackupClient.listRecoveryPointsByLegalHoldPaginated(initialRequest: ListRecoveryPointsByLegalHoldRequest): Flow<ListRecoveryPointsByLegalHoldResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listRecoveryPointsByLegalHoldPaginated.listRecoveryPointsByLegalHold(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListRecoveryPointsByLegalHoldResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRecoveryPointsByLegalHoldResponse]
 */
public fun BackupClient.listRecoveryPointsByLegalHoldPaginated(block: ListRecoveryPointsByLegalHoldRequest.Builder.() -> Unit): Flow<ListRecoveryPointsByLegalHoldResponse> =
    listRecoveryPointsByLegalHoldPaginated(ListRecoveryPointsByLegalHoldRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listRecoveryPointsByLegalHoldPaginated]
 * to access the nested member [RecoveryPointMember]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [RecoveryPointMember]
 */
@JvmName("listRecoveryPointsByLegalHoldResponseRecoveryPointMember")
public fun Flow<ListRecoveryPointsByLegalHoldResponse>.recoveryPoints(): Flow<RecoveryPointMember> =
    transform() { response ->
        response.recoveryPoints?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListRecoveryPointsByResourceResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListRecoveryPointsByResourceRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRecoveryPointsByResourceResponse]
 */
public fun BackupClient.listRecoveryPointsByResourcePaginated(initialRequest: ListRecoveryPointsByResourceRequest): Flow<ListRecoveryPointsByResourceResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listRecoveryPointsByResourcePaginated.listRecoveryPointsByResource(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListRecoveryPointsByResourceResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRecoveryPointsByResourceResponse]
 */
public fun BackupClient.listRecoveryPointsByResourcePaginated(block: ListRecoveryPointsByResourceRequest.Builder.() -> Unit): Flow<ListRecoveryPointsByResourceResponse> =
    listRecoveryPointsByResourcePaginated(ListRecoveryPointsByResourceRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listRecoveryPointsByResourcePaginated]
 * to access the nested member [RecoveryPointByResource]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [RecoveryPointByResource]
 */
@JvmName("listRecoveryPointsByResourceResponseRecoveryPointByResource")
public fun Flow<ListRecoveryPointsByResourceResponse>.recoveryPoints(): Flow<RecoveryPointByResource> =
    transform() { response ->
        response.recoveryPoints?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListReportJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListReportJobsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListReportJobsResponse]
 */
public fun BackupClient.listReportJobsPaginated(initialRequest: ListReportJobsRequest): Flow<ListReportJobsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listReportJobsPaginated.listReportJobs(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListReportJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListReportJobsResponse]
 */
public fun BackupClient.listReportJobsPaginated(block: ListReportJobsRequest.Builder.() -> Unit): Flow<ListReportJobsResponse> =
    listReportJobsPaginated(ListReportJobsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListReportPlansResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListReportPlansRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListReportPlansResponse]
 */
public fun BackupClient.listReportPlansPaginated(initialRequest: ListReportPlansRequest): Flow<ListReportPlansResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listReportPlansPaginated.listReportPlans(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListReportPlansResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListReportPlansResponse]
 */
public fun BackupClient.listReportPlansPaginated(block: ListReportPlansRequest.Builder.() -> Unit): Flow<ListReportPlansResponse> =
    listReportPlansPaginated(ListReportPlansRequest.Builder().apply(block).build())

/**
 * Paginate over [ListRestoreJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListRestoreJobsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRestoreJobsResponse]
 */
public fun BackupClient.listRestoreJobsPaginated(initialRequest: ListRestoreJobsRequest): Flow<ListRestoreJobsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listRestoreJobsPaginated.listRestoreJobs(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListRestoreJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRestoreJobsResponse]
 */
public fun BackupClient.listRestoreJobsPaginated(block: ListRestoreJobsRequest.Builder.() -> Unit): Flow<ListRestoreJobsResponse> =
    listRestoreJobsPaginated(ListRestoreJobsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listRestoreJobsPaginated]
 * to access the nested member [RestoreJobsListMember]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [RestoreJobsListMember]
 */
@JvmName("listRestoreJobsResponseRestoreJobsListMember")
public fun Flow<ListRestoreJobsResponse>.restoreJobs(): Flow<RestoreJobsListMember> =
    transform() { response ->
        response.restoreJobs?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListTagsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTagsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTagsResponse]
 */
public fun BackupClient.listTagsPaginated(initialRequest: ListTagsRequest): Flow<ListTagsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTagsPaginated.listTags(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListTagsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTagsResponse]
 */
public fun BackupClient.listTagsPaginated(block: ListTagsRequest.Builder.() -> Unit): Flow<ListTagsResponse> =
    listTagsPaginated(ListTagsRequest.Builder().apply(block).build())
