// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.transform

import aws.sdk.kotlin.services.backup.model.BackupSelection
import aws.sdk.kotlin.services.backup.model.CreateBackupSelectionRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateBackupSelectionOperationSerializer: HttpSerialize<CreateBackupSelectionRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateBackupSelectionRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            val pathSegments = listOf<String>(
                "backup",
                "plans",
                "${input.backupPlanId}".encodeLabel(),
                "selections",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeCreateBackupSelectionOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateBackupSelectionOperationBody(context: ExecutionContext, input: CreateBackupSelectionRequest): ByteArray {
    val serializer = JsonSerializer()
    val BACKUPSELECTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("BackupSelection"))
    val CREATORREQUESTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("CreatorRequestId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BACKUPSELECTION_DESCRIPTOR)
        field(CREATORREQUESTID_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.backupSelection?.let { field(BACKUPSELECTION_DESCRIPTOR, it, ::serializeBackupSelectionDocument) }
        input.creatorRequestId?.let { field(CREATORREQUESTID_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
