// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.backup.model.BackupException
import aws.sdk.kotlin.services.backup.model.CreateFrameworkResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateFrameworkOperationDeserializer: HttpDeserialize<CreateFrameworkResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateFrameworkResponse {
        if (!response.status.isSuccess()) {
            throwCreateFrameworkError(context, response)
        }
        val builder = CreateFrameworkResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateFrameworkOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwCreateFrameworkError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw BackupException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AlreadyExistsException" -> AlreadyExistsExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidParameterValueException" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedResponse)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "MissingParameterValueException" -> MissingParameterValueExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> BackupException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateFrameworkOperationBody(builder: CreateFrameworkResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val FRAMEWORKARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FrameworkArn"))
    val FRAMEWORKNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FrameworkName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(FRAMEWORKARN_DESCRIPTOR)
        field(FRAMEWORKNAME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                FRAMEWORKARN_DESCRIPTOR.index -> builder.frameworkArn = deserializeString()
                FRAMEWORKNAME_DESCRIPTOR.index -> builder.frameworkName = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
