// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.backup.model.BackupException
import aws.sdk.kotlin.services.backup.model.DescribeRegionSettingsResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableMapOf


internal class DescribeRegionSettingsOperationDeserializer: HttpDeserialize<DescribeRegionSettingsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeRegionSettingsResponse {
        if (!response.status.isSuccess()) {
            throwDescribeRegionSettingsError(context, response)
        }
        val builder = DescribeRegionSettingsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeRegionSettingsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeRegionSettingsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw BackupException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> BackupException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeRegionSettingsOperationBody(builder: DescribeRegionSettingsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val RESOURCETYPEMANAGEMENTPREFERENCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("ResourceTypeManagementPreference"))
    val RESOURCETYPEOPTINPREFERENCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("ResourceTypeOptInPreference"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(RESOURCETYPEMANAGEMENTPREFERENCE_DESCRIPTOR)
        field(RESOURCETYPEOPTINPREFERENCE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                RESOURCETYPEMANAGEMENTPREFERENCE_DESCRIPTOR.index -> builder.resourceTypeManagementPreference =
                    deserializer.deserializeMap(RESOURCETYPEMANAGEMENTPREFERENCE_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, Boolean>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeBoolean() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                RESOURCETYPEOPTINPREFERENCE_DESCRIPTOR.index -> builder.resourceTypeOptInPreference =
                    deserializer.deserializeMap(RESOURCETYPEOPTINPREFERENCE_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, Boolean>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeBoolean() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
